//
//   File : kvi_regusersdb.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_regusersdb.cpp)
//   Last major modification : Fri May 28 1999 00:30:54 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_fileutils.h"
#include "kvi_defines.h"
#include "kvi_regusersdb.h"
#include "kvi_locale.h"

//#warning "Command to set/get the pass"

KviRegisteredUsersDb::KviRegisteredUsersDb()
{
	m_pRegList = new QList<KviRegisteredUser>;
	m_pRegList->setAutoDelete(true);
}

KviRegisteredUsersDb::~KviRegisteredUsersDb()
{
	delete m_pRegList;
}

void KviRegisteredUsersDb::registerUser(KviRegisteredUser * u,const char *flags)
{
	if(flags){
		setFlags(u, flags);
	}
	m_pRegList->append(u);
}


void KviRegisteredUsersDb::deleteFlags(KviRegisteredUser * u, const char *flags)
{
	KviStr *tempFlags = new KviStr();
	KviStr *deleteFlags = new KviStr(flags);
	char *oldFlags = u->allFlags.ptr();

	 while (*oldFlags) {

		if (! deleteFlags->contains(*oldFlags))tempFlags->append(*oldFlags);
		if (deleteFlags->contains("n"))u->bNotify = 0;
		if (deleteFlags->contains("i"))u->bIgnore = 0;

		oldFlags++;
	}

	u->allFlags = tempFlags->ptr();
}

void KviRegisteredUsersDb::addFlags(KviRegisteredUser * u,const char *flags)
{
	while(*flags){
		if(*flags == 'n')u->bNotify = 1;
		else if(*flags == 'i')u->bIgnore = 1;
		if(!(u->allFlags.contains(*flags,true))) // is there a better way to do the following ???
			if(((*flags >= 'A') && (*flags <= 'Z')) || ((*flags >= 'a') && (*flags <= 'z')) || ((*flags >= '0') && (*flags <= '9')))
				u->allFlags.append(*flags);
		flags++;
	}
}

void KviRegisteredUsersDb::setFlags(KviRegisteredUser * u,const char *flags)
{
	u->allFlags.setLen(0);
	u->bNotify = 0;
	u->bIgnore = 0;
	addFlags(u, flags);
}

void KviRegisteredUsersDb::setPasswd(KviRegisteredUser * u,const char *passwd)
{
	u->passwd=passwd;
}

void KviRegisteredUsersDb::getPasswd(KviRegisteredUser * u,KviStr &buf)
{
	buf=u->passwd;
}

void KviRegisteredUsersDb::setComment(KviRegisteredUser * u,const char *comment)
{
	u->comment=comment;
}

void KviRegisteredUsersDb::getComment(KviRegisteredUser * u,KviStr &buf)
{
	buf=u->comment;
}


void KviRegisteredUsersDb::unregisterUser(KviRegisteredUser * u)
{
	m_pRegList->removeRef(u);
}

void KviRegisteredUsersDb::clear()
{
	delete m_pRegList;
	m_pRegList = new QList<KviRegisteredUser>;
	m_pRegList->setAutoDelete(true);
}

//void KviRegisteredUsersDb::copyList(QList<KviRegisteredUser> *dst,QList<KviRegisteredUser> *src)
//{
//	if(dst == 0){
//		// clear()
//		delete m_pRegList;
//		m_pRegList = new QList<KviRegisteredUser>;
//		m_pRegList->setAutoDelete(true);
//		dst = m_pRegList;
//	}
//	if(src == 0)src = m_pRegList;
//
//	__range_valid(src != dst);
//
//	for(KviRegisteredUser * r = src->first();r;r=src->next())
//	{
//		KviRegisteredUser * u = new KviRegisteredUser;
//		KviStr tmp;
//		r->user.mask(tmp);
//		u->user.setMask(tmp.ptr());
//		u->bNotify = r->bNotify;
//		u->bIgnore = r->bIgnore;
//		dst->append(u);
//	}
//}

KviRegisteredUser * KviRegisteredUsersDb::findUserByMask(const char *mask)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		if(r->user.matches(mask))return r;
	}
	return 0;
}

KviRegisteredUser * KviRegisteredUsersDb::findUserWithFlagByMask(const char *mask,char flag)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		if(r->user.matches(mask)){
			if(r->allFlags.findFirstIdx(flag) >= 0)return r;
		}
	}
	return 0;
}

// speed up the lookups
KviRegisteredUser * KviRegisteredUsersDb::findIgnoredUserByMask(const char *mask)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		if(r->user.matches(mask)){
			if(r->bIgnore == 1)return r;
		}
	}
	return 0;
}

KviRegisteredUser * KviRegisteredUsersDb::findExactMatch(const char *mask)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		KviStr m;
		r->user.mask(m);
		if(kvi_strEqualCI(m.ptr(),mask))return r;
	}
	return 0;
}

void KviRegisteredUsersDb::getFlags(const char *mask, KviStr &buf)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		if(r->user.matches(mask)) {
			if (!buf.hasData())
				buf = r->allFlags;
			else {
				char * flags=r->allFlags.ptr();
				while(*flags){
					if(!(buf.contains(*flags,true)))
						buf.append(*flags);
					flags++;
				}
			}
		}
	}
}

void KviRegisteredUsersDb::getFlagsExact(const char *mask, KviStr &buf)
{
	KviRegisteredUser * r = findExactMatch(mask);
	if(r)
		buf = r->allFlags;
}

void KviRegisteredUsersDb::getWatchString(KviStr &buf)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		if(r->bNotify != 0){
			KviStr tmp=r->user.nick();
			if(tmp.findFirstIdx('*')==-1){
				if(buf.hasData())buf.append(' ');
				buf.append('+');
				buf.append(r->user.nick());	
			}
		}
	}
}

void KviRegisteredUsersDb::getNotifyString(KviStr &buf)
{
	for(KviRegisteredUser * r = m_pRegList->first();r;r=m_pRegList->next())
	{
		if(r->bNotify != 0){
			KviStr tmp=r->user.nick();
			if(tmp.findFirstIdx('*')==-1){
				if(buf.hasData())buf.append(' ');
				buf.append(r->user.nick());	
			}
		}
	}
}

bool KviRegisteredUsersDb::load(const char *filename,KviStr &error)
{
	KviStr buffer;
	if(!kvi_loadFile(filename,buffer)){
		error = __tr("Unable to load file");
		return false;
	}
	if(!kvi_strEqualCSN(KVI_MAGIC_STRING,buffer.ptr(),KVI_MAGIC_STRING_LENGTH)){
		error = __tr("Invalid magic");
		return false; //not a kvirc file
	}
	buffer.cutLeft(KVI_MAGIC_STRING_LENGTH);
	buffer.stripLeftWhiteSpace(); //be flexible...allow some spaces...for manual editing by experts :)

	if(buffer.isEmpty())return true; //done
	while(buffer.hasData()){
		KviStr line;
		buffer.getLine(line);
		if(line.isEmpty())continue;
		KviRegisteredUser * u = new KviRegisteredUser;

		KviStr tmp, aux;
		tmp = u->user.setMask(line.ptr(),' ');
		tmp.stripLeftWhiteSpace();
		// get flags
		tmp.getToken(aux,' ');
		registerUser(u,aux.ptr());

		// get passwd
		tmp.getToken(aux,' ');
		if (aux.hasData())
			setPasswd(u,aux.ptr());

		// get passwd
		if (tmp.hasData())
			setComment(u,tmp.ptr());
	}
	return true;
}

bool KviRegisteredUsersDb::save(const char *filename)
{
	QFile f(filename);
	if(!f.open(IO_WriteOnly | IO_Truncate))return false;

	f.writeBlock(KVI_MAGIC_STRING,KVI_MAGIC_STRING_LENGTH);

	for(KviRegisteredUser *r=m_pRegList->first();r;r=m_pRegList->next()){
		KviStr tmp;
		r->user.mask(tmp);

		// want to user any flags... not only n, i
		if((r->allFlags.hasData())) {
			tmp.append(" ");
			tmp.append(r->allFlags);
		} else
			tmp.append(" -");	// placeholder if we have no flags

		if((r->passwd.hasData())) {
			tmp.append(" ");
			tmp.append(r->passwd);
		} else
			tmp.append(" -");	// placeholder if we have no password


		if((r->comment.hasData())) {
			tmp.append(" ");
			tmp.append(r->comment);
		}

/*		KviStr flags = r->bNotify ? "n" : "";
		if(r->bIgnore)flags.append('i');
		if(flags.hasData()){
			tmp.append(" ");
			tmp.append(flags);
		}
*/
		f.writeBlock(tmp.ptr(),tmp.len());


		f.writeBlock("\n",1);
	}

	f.close();
	return true;
}
