#ifndef _KVI_LIST_H_INCLUDED_
#define _KVI_LIST_H_INCLUDED_

//
//   File : kvi_list.h (/usr/build/KVICVS/kvirc/src/kvirc/kvi_list.h)
//   Last major modification : Sun Sep 12 1999 16:31:42 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"

//#include <qsplitter.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlist.h>
#include <qlabel.h>

typedef struct KviChanListEntryTag
{
	KviStr channel;
	int nUsers;
	KviStr topic;
} KviChanListEntry;

class KviListWindow : public KviWindow
{
//	friend class KviServerParser; //Users our list box
	Q_OBJECT
public:		// Consruction & Destruction
	KviListWindow(KviFrame *lpFrm);
	~KviListWindow();
public:		// Fields
//	QSplitter   *m_pHorSplitter;
	QSplitter   *m_pVerSplitter;
	QListView   *m_pListView;
	QWidget     *m_pPanel;
	QLineEdit   *m_pListParams;
	QPushButton *m_pRequestList;
	QLineEdit   *m_pChannelRegexp;
	QLineEdit   *m_pTopicRegexp;
	QLineEdit   *m_pMinUsers;
	QLineEdit   *m_pMaxUsers;
	QPushButton *m_pApplyFilter;
	QList<KviChanListEntry> *m_pChanList;
	QLabel      *m_pDisplayedItems;
	bool         m_bInRequest;
	KviStr       m_szLastServer;
	KviStr       m_szLastDate;
	QTimer      *m_pChanListLoadTimer;
	KviStr       m_szChanListData;
	const char  *m_pChanListData;
public:		// Methods
	void endOfList();
	void startOfList();
	void processListEntry(const char *msg);
	void notifyDisconnected();
//	void notifyConnected();
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual void setProperties(KviWindowProperty *p);
	virtual void saveProperties();
	void clearChanList();
	void brokenListEntry(const char *msg);
	void updateDisplayedItems();
	void saveChanList();
	void loadChanList();
protected slots:
	void loadChanListChunk();
	void applyFilter();
	void requestList();
	void joinChannel(QListViewItem *it);
//	void showHostPopup(QListViewItem *i,const QPoint &p,int c);
//	void hostPopupClicked(int id);
//private:
//	QListViewItem * insertLink(KviLink * l);
//	QListViewItem * getItemByHost(const char *host,QListViewItem * par);
};

#endif //_KVI_LIST_H_INCLUDED_
