#ifndef _KVI_LINKS_H_INCLUDED_
#define _KVI_LINKS_H_INCLUDED_

//
//   File : kvi_links.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_links.h)
//   Last major modification : Thu Feb 11 1999 20:06:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"

#include <qlistview.h>
#include <qpopupmenu.h>

typedef struct KviLink
{
	KviStr host;
	KviStr parent;
	int hops;
	KviStr description;
};

class KviLinksWindow : public KviWindow
{
	friend class KviServerParser; //Users our list box
	Q_OBJECT
public:		// Consruction & Destruction
	KviLinksWindow(KviFrame *lpFrm);
	~KviLinksWindow();
public:		// Fields
//	QSplitter  *m_pSplitter;
	QListView  *m_pListView;
	QList<KviLink> * m_pLinkList;
	QPopupMenu *m_pHostPopup;
public:		// Methods
	void endOfLinks();
	void processLink(const char *msg);
	void reset();
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual void setProperties(KviWindowProperty *p);
	virtual void saveProperties();
protected slots:
	void showHostPopup(QListViewItem *i,const QPoint &p,int c);
	void hostPopupClicked(int id);
private:
	QListViewItem * insertLink(KviLink * l);
	QListViewItem * getItemByHost(const char *host,QListViewItem * par);
};

#endif //_KVI_CONSOLE_H_INCLUDED_
