//
//   File : kvi_dlgoptions.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dlgoptions.cpp)
//   Last major modification : Tue May 4 1999 18:02:42 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define _KVI_DLGOPTIONS_CPP_

#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"

#include "kvi_dlgoptions.h"

#include "kvi_locale.h"

#include "kvi_defines.h"

#include "kvi_event.h"

#include "kvi_app.h"
#include "kvi_selectors.h"
#include "kvi_listview.h"
#include "kvi_mime.h"

#include "kvi_options.h"
#include "kvi_strsub.h"

#include "kvi_fileutils.h"

#include "kvi_config.h"
#include "kvi_helpqml.h"

#include "kvi_frame.h"

#ifdef COMPILE_PLUGIN_SUPPORT

	#include "kvi_error.h"
	#include "kvi_console.h"
	#include "kvi_plugin.h"
	extern KviPluginManager * g_pPluginManager;

#endif

#ifdef COMPILE_NEED_CHARSET_TRANSLATION

	#include "kvi_translate.h"
	extern KviCharsetTranslator * g_pCharsetTranslator;

#endif

#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qheader.h>
#include <qpixmap.h>
#include <qfiledialog.h>
#include <qsplitter.h>

//#include <unistd.h> // for usleep()

#include <qstyle.h>
#include <qobjcoll.h>

#include <qvbox.h>

extern KviEventManager	* g_pEventManager;

// Declared in kvi_options.cpp
extern QRgb defaultMircRgb[16];
// Declared in kvi_app.cpp and managed by KviApp class
extern QPixmap * g_pixViewOut[KVI_OUT_NUM_IMAGES];

// This must match the order of the KVI_OUT_* constants order
// (declared in kvi_defines.h)
const char * messageTypeString[KVI_OUT_NUM_IMAGES + 2]=
{
	_i19n_("Normal text"),
	_i19n_("Internal messages"),
	_i19n_("Internal errors"),
	_i19n_("KVIrc logo text"),
	_i19n_("'Echoed' text"),
	_i19n_("Socket messages"),
	_i19n_("Server information"),
	_i19n_("Unhandled server replies"),
	_i19n_("Server message of the day"),
	_i19n_("Unhandled error messages"),
	_i19n_("Nickname error messages"),
	_i19n_("Server pings"),
	_i19n_("Join messages"),
	_i19n_("Topic changes"),
	_i19n_("Time messages"),
	_i19n_("Internal desync notices"),
	_i19n_("Names reply"),
	_i19n_("Part messages"),
	_i19n_("Kick messages"),
	_i19n_("Quit messages"),
	_i19n_("Quit on split messages"),
	_i19n_("Split warnings"),
	_i19n_("Own user mode changes"),
	_i19n_("Op messages"),
	_i19n_("Deop messages"),
	_i19n_("Voice messages"),
	_i19n_("Devoice messages"),
	_i19n_("Ban messages"),
	_i19n_("Unban messages"),
	_i19n_("Ban exception messages"),
	_i19n_("Ban unexception messages"),
	_i19n_("Key (mode +k) messages"),
	_i19n_("Limit (mode +l) messages"),
	_i19n_("Other channel mode messages"),
	_i19n_("Who replies"),
	_i19n_("Private messages not handled"),
	_i19n_("CTCP requests"),
	_i19n_("CTCP replies"),
	_i19n_("CTCP errors"),
	_i19n_("Raw text to server"),
	_i19n_("Own channel and query text"),
	_i19n_("Spam warnings"),
	_i19n_("Nick changes"),
	_i19n_("Flood warnings"),
	_i19n_("Actions"),
	_i19n_("Notices"),
	_i19n_("DNS results"),
	_i19n_("Notify list changes"),
	_i19n_("Highlighted text"),
	_i19n_("Invite messages"),
	_i19n_("DCC Info"),
	_i19n_("DCC Warnings"),
	_i19n_("DCC Errors"),
	_i19n_("Help text"),
	_i19n_("Process stdin"),
	_i19n_("Process stdout"),
	_i19n_("Process stderr"),
	_i19n_("Directory entries of /DIR"),
	_i19n_("File entries of /DIR"),
	_i19n_("Plugin output"),
	_i19n_("Happy text"),
	_i19n_("Unhappy text"),
	_i19n_("Angry text"),
	_i19n_("Kill text"),
	_i19n_("Killed text"),
	_i19n_("CTCP multimedia"),
	_i19n_("Wallops"),
	_i19n_("Log"),
	_i19n_("Idea"),
	_i19n_("Input"),
	_i19n_("Packet"),
	_i19n_("Talk"),
	_i19n_("Script"),
	_i19n_("Colors"),
	_i19n_("Op notices"),
	_i19n_("mIRC"),
	_i19n_("Widget"),
	_i19n_("Server errors"),
	_i19n_("Console"),     // #define KVI_OUT_WND_CONSOLE 78
	_i19n_("Channel"),     // #define KVI_OUT_WND_CHANNEL 79
	_i19n_("Query"),       // #define KVI_OUT_WND_QUERY 80
	_i19n_("Chat"),        // #define KVI_OUT_WND_CHAT 81
	_i19n_("Send"),        // #define KVI_OUT_WND_SEND 82
	_i19n_("Help browser"),  // #define KVI_OUT_WND_HELPWINDOW 83
	_i19n_("Directory browser"),  // #define KVI_OUT_WND_DIRBROWSER 84
	_i19n_("Voice"),       // #define KVI_OUT_WND_VOICE 85
	_i19n_("Links"),       // #define KVI_OUT_WND_LINKS 86
	_i19n_("List"),        // #define KVI_OUT_WND_LIST 87
	_i19n_("User window"), // #define KVI_OUT_WND_UWINDOW 88
	_i19n_("Halfop messages"),
	_i19n_("Dehalfop messages"),
	_i19n_("Userop messages"),
	_i19n_("Deuserop messages"),
	_i19n_("Owner messages"),
	_i19n_("Deowner messages"),
	//New message types go BEFORE THIS LINE!
	_i19n_("Selected text"),
	_i19n_("URL highlight (foreground only)")
};



#define KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER 4
#define KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE 2

KviGeneralOptionsWidget::KviGeneralOptionsWidget(QWidget *parent,int id)
:QFrame(parent)
{
	m_id = id;
	setFrameStyle(QFrame::Panel | QFrame::Sunken);
}

KviGeneralOptionsWidget::~KviGeneralOptionsWidget()
{
}

void KviGeneralOptionsWidget::commitChanges()
{
	// nothing here
}


void KviGeneralOptionsWidget::commitColorSelectors()
{
	QObjectList * l = queryList("KviNewColorSelector");
	if(!l)return;
	QObjectListIt it(*l);
	while(it.current())
	{
		((KviNewColorSelector *)it.current())->commitChanges();
		++it;
	}
	delete l;
}


void KviGeneralOptionsWidget::commitFileSelectors()
{
	QObjectList * l = queryList("KviNewFileSelector");
	if(!l)return;
	QObjectListIt it(*l);
	while(it.current())
	{
		((KviNewFileSelector *)it.current())->commitChanges();
		++it;
	}
	delete l;
}

void KviGeneralOptionsWidget::commitImageSelectors()
{
	QObjectList * l = queryList("KviNewImageSelector");
	if(!l)return;
	QObjectListIt it(*l);
	while(it.current())
	{
		((KviNewImageSelector *)it.current())->commitChanges();
		++it;
	}
	delete l;
}



void KviGeneralOptionsWidget::commitCharSelectors()
{
	QObjectList * l = queryList("KviNewCharSelector");
	if(!l)return;
	QObjectListIt it(*l);
	while(it.current())
	{
		((KviNewCharSelector *)it.current())->commitChanges();
		++it;
	}
	delete l;
}


void KviGeneralOptionsWidget::commitIpSelectors()
{
	QObjectList * l = queryList("KviNewIpSelector");
	if(!l)return;
	QObjectListIt it(*l);
	while(it.current())
	{
		((KviNewIpSelector *)it.current())->commitChanges();
		++it;
	}
	delete l;
}


void KviGeneralOptionsWidget::commitFontSelectors()
{
	QObjectList * l = queryList("KviNewFontSelector");
	if(!l)return;
	QObjectListIt it(*l);
	while(it.current())
	{
		((KviNewFontSelector *)it.current())->commitChanges();
		++it;
	}
	delete l;
}

/////////////////

KviGeneralOptionsFrontWidget::KviGeneralOptionsFrontWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_NONE)
{
	QGridLayout *g = new QGridLayout(this,1,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);
//	QLabel * l1 = new QLabel(this);
//	l1->setPixmap(QPixmap("/usr/build/kvirc/sites/www/img/btn_install.gif"));
//	g->addWidget(l1,0,0);
	QLabel * l = new QLabel(_CHAR_2_QSTRING(__tr( \
					"<h1><b><center>General Options</center></b></h1><br>" \
					"<hr><br>" \
					"<center>Select a category from the list view on the left<br>" \
					"to view the related options.<br>" \
					"When you have finished, click OK to accept your changes<br>" \
					"or Cancel to discard them.</center>" \
				)),this);
	l->setAlignment(AlignCenter);
	g->addWidget(l,0,0);
}

KviGeneralOptionsFrontWidget::~KviGeneralOptionsFrontWidget()
{
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsDefaultMessagesWidget
	@widget: Default messages
		Here you can set the default text strings that will be sent to the server
		when you specify no replacement.<br>
		The "PART reason" is the additional text automatically sent to the server
		when you close a channel window.<br>
		The other users on the channel will see something like:<br>
		&lt;Yournick&gt; has left #channel (&lt;reason&gt;).<br>
		You can override this setting by sending manually the <a href="part.kvihelp">/PART</a> message.<br>
		The "KICK reason" is the default reason for the <a href="kick.kvihelp">/KICK</a> command.<br>
		It is used when no other reason is specified.<br>
		The "QUIT reason" is the additional text automatically sent to the server
		when you terminate an IRC connection by pressing the "Disconnect" button
		on the toolbar or selecting "Disconnect" from the menu.<br>
		You can override this setting by sending manually the <a href="quit.kvihelp">/QUIT</a> message.<br>		
*/


KviGeneralOptionsDefaultMessagesWidget::KviGeneralOptionsDefaultMessagesWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES)
{
	QGridLayout *g = new QGridLayout(this,4,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewStringSelector * s = new KviNewStringSelector(this,__tr("Part reason:"),&(g_pOptions->m_szPartMessage));
	g->addWidget(s,0,0);
	s = new KviNewStringSelector(this,__tr("Kick reason:"),&(g_pOptions->m_szKickMessage));
	g->addWidget(s,1,0);
	s = new KviNewStringSelector(this,__tr("Quit reason:"),&(g_pOptions->m_szQuitMessage));
	g->addWidget(s,2,0);

	// Trick
	QFrame * f = new QFrame(this);
	g->addWidget(f,3,0);
	g->setRowStretch(3,1);
}

KviGeneralOptionsDefaultMessagesWidget::~KviGeneralOptionsDefaultMessagesWidget()
{
}


void KviGeneralOptionsDefaultMessagesWidget::commitChanges()
{
	KviNewStringSelector::commitAll(this);
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsInputWidget
	@widget: Input widget options
		Here you can set the options for the commandline input widget.<br>
		In channel windows the widget is capable of nick / mask completion (Tab / Shift + Tab).<br>
		The completed words can have an user defined postfix (like ": ").<br>
		It is possible to specify a personal command prefix to be used instead of '/'.<br>
		The widget is also capable to automatically substitute specified strings.<br>
		For example , you might want to substitute all occurences of the string "AFAIK",
		with the expanded version "As far as I know".<br>
		To achieve this , just click the "Add new string" button.<br>
		A new entry will appear in the string substitution list box.<br>
		Double click on the left column and then type in the string "AFAIK".<br>
		In the same way type in the second column "As far as I know" and then click OK.<br>
		Now type in the commandline input "Hey , AFAIK<SPACE>" and voila! , the input line
		shows "Hey , As far as I know ".<br>
		The substitution is performed when you type in a space (to give you some visual feedback),
		period or you press the return key.<br>
*/


KviGeneralOptionsInputWidget::KviGeneralOptionsInputWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT)
{
	QGridLayout *g = new QGridLayout(this,11,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewStringSelector * s = new KviNewStringSelector(this,__tr("Nick/mask completion postfix:"),&(g_pOptions->m_szStringToAddAfterCompletedNick),true,180);
	g->addMultiCellWidget(s,0,0,0,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Apply completion postfix to first word only"),&(g_pOptions->m_bApplyCompletionPostfixForFirstWordOnly));
	g->addMultiCellWidget(b,1,1,0,1);
	b = new KviNewBoolSelector(this,__tr("Replace whole word"),&(g_pOptions->m_bCompletionReplaceWholeWord));
	g->addMultiCellWidget(b,2,2,0,1);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,3,3,0,1);

	b = new KviNewBoolSelector(this,__tr("Warp input cursor to end when browsing command history"),&(g_pOptions->m_bInputHistoryCursorAtEnd));
	g->addMultiCellWidget(b,4,4,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,5,5,0,1);

	KviNewCharSelector * ch = new KviNewCharSelector(this,__tr("Personal command prefix:"),&(g_pOptions->m_cPersonalCommandPrefix),true,180);
	g->addMultiCellWidget(ch,6,6,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,7,7,0,1);

	b = new KviNewBoolSelector(this,__tr("String substitution"),&(g_pOptions->m_bUseStringSubstitution));
	g->addMultiCellWidget(b,8,8,0,1);

	m_pStrSubView = new KviListView(this);
	m_pStrSubView->addColumn(_CHAR_2_QSTRING(__tr("String")));
	m_pStrSubView->addColumn(_CHAR_2_QSTRING(__tr("Substitute")));
	m_pStrSubView->setMinimumHeight((m_pStrSubView->fontMetrics().height())*4);
	m_pStrSubView->setSorting(-1);
	m_pStrSubView->setEnabled(g_pOptions->m_bUseStringSubstitution);

	connect(b,SIGNAL(toggled(bool)),m_pStrSubView,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(m_pStrSubView,9,9,0,1);

	QPushButton * pb = new QPushButton(_CHAR_2_QSTRING(__tr("&Add String")),this);
	pb->setEnabled(g_pOptions->m_bUseStringSubstitution);
	connect(b,SIGNAL(toggled(bool)),pb,SLOT(setEnabled(bool)));
	connect(pb,SIGNAL(clicked()),this,SLOT(addNewString()));
	g->addWidget(pb,10,0);


	pb = new QPushButton(_CHAR_2_QSTRING(__tr("&Remove String")),this);
	pb->setEnabled(g_pOptions->m_bUseStringSubstitution);
	connect(b,SIGNAL(toggled(bool)),pb,SLOT(setEnabled(bool)));
	connect(pb,SIGNAL(clicked()),this,SLOT(deleteSelectedStrings()));
	g->addWidget(pb,10,1);

	QListViewItem * it;

	for(KviStrSubItem * m=g_pOptions->m_pStrSub->m_pList->first();m;m=g_pOptions->m_pStrSub->m_pList->next()){
		it = new QListViewItem(m_pStrSubView,_CHAR_2_QSTRING(m->szOriginal.ptr()),_CHAR_2_QSTRING(m->szSubstitute.ptr()));
	}

	g->setRowStretch(9,1);
}

KviGeneralOptionsInputWidget::~KviGeneralOptionsInputWidget()
{
}

void KviGeneralOptionsInputWidget::addNewString()
{
	(void) new QListViewItem(m_pStrSubView,
			_CHAR_2_QSTRING(__tr("*")),_CHAR_2_QSTRING("*"),
			_CHAR_2_QSTRING(""),_CHAR_2_QSTRING(""),
			_CHAR_2_QSTRING(""));
}

void KviGeneralOptionsInputWidget::deleteSelectedStrings()
{
	QListViewItem * it = m_pStrSubView->firstChild();
	while(it){
		QListViewItem * tmp = it;
		it = it->nextSibling();
		if(tmp->isSelected())delete tmp;
	}
}

void KviGeneralOptionsInputWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewStringSelector::commitAll(this);
	commitCharSelectors();

		while(g_pOptions->m_pStrSub->m_pList->first())g_pOptions->m_pStrSub->m_pList->removeFirst();
		QListViewItem * it = m_pStrSubView->firstChild();
		while(it){
			KviStrSubItem *item = new KviStrSubItem;
			item->szOriginal = it->text(0);
			item->szOriginal.stripWhiteSpace();
			item->szSubstitute = it->text(1);
			item->szSubstitute.stripWhiteSpace();
			if(item->szOriginal.hasData() && item->szSubstitute.hasData())g_pOptions->m_pStrSub->m_pList->append(item);
			else delete item; //incomplete...unuseful...
			it = it->nextSibling();
		}
		// Disable substitution when there are no items
		if(g_pOptions->m_pStrSub->m_pList->count() == 0)g_pOptions->m_bUseStringSubstitution = false;
}

/////////////////
/*
	@quickhelp: KviGeneralOptionsViewWidget
	@widget: View widget options
		Here you can set the view widget options.<br>
		The "View widget buffer size" is the number of lines that the widget
		will keep in memory as "scrollback" buffer.<br>
		The widget is able to highlight PRIVATE MESSAGES that contain
		specified words.<br>
		This feature is commonly used to highlight lines that contain your own nickname.<br>
		Multiple words can be specified , separating it by spaces.<br>
		The widget is also able to recognize common URL formats and to
		show it as clickable links.<br>
		The action taken after the double-click may be specified as "Browser commandline": it is a shell command.<br>
		KVIrc comes with a shell script called kvi_run_netscape.sh that is able to
		redirect the url to an existing Netscape window or to start a new session
		if no window is currently open.<br>
		You may also decide to use a different browser: just put the command to be executed
		in the "Browser commandline" option input line.<br>
		The '%' character in that commandline will be substituted with the double-clicked URL.<br>
		Examples:<br><br>
		<b>kvi_run_netscape.sh %</b><br>
		<b>netscape %</b><br>
		<b>kfmclient openURL %</b><br>
		<b>kfmexec openURL %</b><br>
		<b>opera -remote openURL(%,new-window)</b><br><br>
*/


KviGeneralOptionsViewWidget::KviGeneralOptionsViewWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW)
{
	QGridLayout *g = new QGridLayout(this,21,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewIntegerSelector *i = new KviNewIntegerSelector(this,__tr("View widget buffer size (32-65535):"),&(g_pOptions->m_iViewMaxBufferSize),KviNewIntegerSelector::Int,32,65535,KVI_IRCVIEW_MAX_LINES,true,180);
	g->addMultiCellWidget(i,0,0,0,1);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,1,1,0,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("When selecting text, copy to clipboard instead of displaying menu"),&(g_pOptions->m_bDoNotShowThePopupOnTextSelected));
	g->addMultiCellWidget(b,2,2,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,3,3,0,1);

	b = new KviNewBoolSelector(this,__tr("Highlight text that contains specified words (for privmsg && notice only)"),&(g_pOptions->m_bWordHighlighting));
	g->addMultiCellWidget(b,4,4,0,1);
	KviNewStringSelector * s = new KviNewStringSelector(this,__tr("Words to highlight (separate with spaces):"),&(g_pOptions->m_szHighlightWords),g_pOptions->m_bWordHighlighting,180);
	g->addMultiCellWidget(s,5,5,0,1);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,6,6,0,1);

	b = new KviNewBoolSelector(this,__tr("Highlight URLs"),&(g_pOptions->m_bUrlHighlighting));
	g->addMultiCellWidget(b,7,7,0,1);


	QLabel * l=new QLabel(_CHAR_2_QSTRING(__tr("Open URLs with:")),this);
//	l->setMinimumSize(l->sizeHint());
	g->addWidget(l,8,0);
	connect(b,SIGNAL(toggled(bool)),l,SLOT(setEnabled(bool)));

	m_pBrowserCommandlineBox = new QComboBox(false,this);
	g->addWidget(m_pBrowserCommandlineBox,8,1);
	connect(b,SIGNAL(toggled(bool)),m_pBrowserCommandlineBox,SLOT(setEnabled(bool)));

	l = new QLabel(_CHAR_2_QSTRING(__tr("Browser commandline (%s = URL):")),this);
	g->addWidget(l,9,0);
	connect(b,SIGNAL(toggled(bool)),l,SLOT(setEnabled(bool)));

	m_pBrowserCommandlineEdit = new QLineEdit(this);
	m_pBrowserCommandlineEdit->setText(g_pOptions->m_szBrowserCommandline.ptr());
	g->addWidget(m_pBrowserCommandlineEdit,9,1);
	connect(b,SIGNAL(toggled(bool)),m_pBrowserCommandlineEdit,SLOT(setEnabled(bool)));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,10,10,0,1);

	b = new KviNewBoolSelector(this,__tr("Privmsg nicknames are links"),&(g_pOptions->m_bPrivmsgFormatNickIsALink));
	g->addMultiCellWidget(b,11,11,0,1);
	s = new KviNewStringSelector(this,__tr("Double-click on nickname link executes command:"),&(g_pOptions->m_szPrivmsgFormatNickLinkCommand),g_pOptions->m_bPrivmsgFormatNickIsALink,180);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(s,12,12,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,13,13,0,1);

	QLabel * l1 = new QLabel(_CHAR_2_QSTRING(__tr("This is the extended privmsg nickname format: [prefix]nick[!user@host][postfix]")),this);
	g->addMultiCellWidget(l1,14,14,0,1);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Use extended privmsg nick formatting"),&(g_pOptions->m_bUseExtendedPrivmsgView));
	g->addMultiCellWidget(b1,15,15,0,1);
	b = new KviNewBoolSelector(this,__tr("Show user and host in privmsgs"),&(g_pOptions->m_bShowUserAndHostInPrivmsgs),g_pOptions->m_bUseExtendedPrivmsgView);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(b,16,16,0,1);
	s = new KviNewStringSelector(this,__tr("Nickname format prefix:"),&(g_pOptions->m_szExtPrivmsgPrefix),g_pOptions->m_bUseExtendedPrivmsgView,180);
	connect(b1,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(s,17,17,0,1);
	s = new KviNewStringSelector(this,__tr("Nickname format postfix:"),&(g_pOptions->m_szExtPrivmsgPostfix),g_pOptions->m_bUseExtendedPrivmsgView,180);
	connect(b1,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(s,18,18,0,1);
	b = new KviNewBoolSelector(this,__tr("Prefix nicknames with channel mode"),&(g_pOptions->m_bEnableNickModePrefix));
	g->addMultiCellWidget(b,19,19,0,1);

	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f,20,20,0,1); //f,19,0
	g->setRowStretch(20,1); //19,1

	fillBrowserCommandlineBox();
}

KviGeneralOptionsViewWidget::~KviGeneralOptionsViewWidget()
{
}

static const char * browserCommandlineTable[] = {
	"kfmclient openURL \%s",
	"mozilla \%s",
	"kvi_run_netscape.sh \%s",
	"opera -remote openURL(\%s,new-window)",
	"galeon \%s",
	"skipstone \%s",
	"xterm -ls -e links \%s",
	"xterm -ls -e lynx \%s",
	0
};

void KviGeneralOptionsViewWidget::fillBrowserCommandlineBox()
{
	int index = 8;
	m_pBrowserCommandlineBox->insertItem("Konqueror");
	m_pBrowserCommandlineBox->insertItem("Mozilla");
	m_pBrowserCommandlineBox->insertItem("Netscape");
	m_pBrowserCommandlineBox->insertItem("Opera");
	m_pBrowserCommandlineBox->insertItem("Galeon");
	m_pBrowserCommandlineBox->insertItem("SkipStone");
	m_pBrowserCommandlineBox->insertItem("Links");
	m_pBrowserCommandlineBox->insertItem("Lynx");
	m_pBrowserCommandlineBox->insertItem(__tr("Other browser"));
	if(g_pOptions->m_szBrowserCommandline.isEmpty())index = 0;
	else for(int i=0;i < 8;i++){
		if(kvi_strEqualCS(g_pOptions->m_szBrowserCommandline.ptr(),browserCommandlineTable[i])){
			index = i;
			break;
		}
	}
	m_pBrowserCommandlineBox->setCurrentItem(index);
	connect(m_pBrowserCommandlineBox,SIGNAL(activated(int)),this,SLOT(fillBrowserCommandlineEdit(int)));
}

void KviGeneralOptionsViewWidget::fillBrowserCommandlineEdit(int index)
{
	if(m_pBrowserCommandlineBox->currentItem() < 8)
		m_pBrowserCommandlineEdit->setText(browserCommandlineTable[m_pBrowserCommandlineBox->currentItem()]);
	else if(!g_pOptions->m_szBrowserCommandline.isEmpty())
		m_pBrowserCommandlineEdit->setText(g_pOptions->m_szBrowserCommandline.ptr());
}

void KviGeneralOptionsViewWidget::commitChanges()
{
	KviNewIntegerSelector::commitAll(this);
	KviNewBoolSelector::commitAll(this);
	KviNewStringSelector::commitAll(this);
	g_pOptions->fillHighlightWordsList();
	g_pOptions->m_szBrowserCommandline = m_pBrowserCommandlineEdit->text();
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsCtcpMessagesWidget
	@widget: Ctcp text messages
		Here you can set the default text strings that will be sent to the
		remote clients in the CTCP messages when you specify no replacement.<br>
		The postfixes are strings that will be APPENDED to the default replies.<br>
*/


KviGeneralOptionsCtcpMessagesWidget::KviGeneralOptionsCtcpMessagesWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES)
{
	QGridLayout *g = new QGridLayout(this,10,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewStringSelector * s = new KviNewStringSelector(this,__tr("VERSION reply postfix:"),&(g_pOptions->m_szCtcpVersionAppendix));
	g->addWidget(s,0,0);
	s = new KviNewStringSelector(this,__tr("USERINFO reply postfix:"),&(g_pOptions->m_szCtcpUserinfoAppendix));
	g->addWidget(s,1,0);
	s = new KviNewStringSelector(this,__tr("CLIENTINFO reply postfix:"),&(g_pOptions->m_szCtcpClientinfoAppendix));
	g->addWidget(s,2,0);
	s = new KviNewStringSelector(this,__tr("SOURCE reply postfix:"),&(g_pOptions->m_szCtcpSourceAppendix));
	g->addWidget(s,3,0);
	s = new KviNewStringSelector(this,__tr("FINGER reply:"),&(g_pOptions->m_szCtcpFingerReply));
	g->addWidget(s,4,0);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,5,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Append real username to the USERINFO reply"),&(g_pOptions->m_bAppendRealUsernameToUserinfoReply));
	g->addWidget(b,6,0);

#if defined(HAVE_SYS_UTSNAME_H) && defined(HAVE_UNAME)
	b = new KviNewBoolSelector(this,__tr("Append system info (uname) to the CLIENTINFO reply"),&(g_pOptions->m_bAppendUnameToClientinfoReply));
#else
	b = new KviNewBoolSelector(this,__tr("Append system info (uname) to the CLIENTINFO reply"),&(g_pOptions->m_bAppendUnameToClientinfoReply),false);
#endif

	g->addWidget(b,7,0);

	b = new KviNewBoolSelector(this,__tr("Reply CTCP ERRMSG to unknown CTCP requests"),&(g_pOptions->m_bReplyErrmsgOnUnknownCtcp));
	g->addWidget(b,8,0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f,9,0);
	g->setRowStretch(9,1);

}

KviGeneralOptionsCtcpMessagesWidget::~KviGeneralOptionsCtcpMessagesWidget()
{
}


void KviGeneralOptionsCtcpMessagesWidget::commitChanges()
{
	KviNewStringSelector::commitAll(this);
	KviNewBoolSelector::commitAll(this);
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsCtcpProtectionWidget
	@widget: Ctcp protection options
		KVIrc has a primitive built-in protection against the CTCP FLOOD attack.<br>
		When protection is enabled KVIrc will reply only to a limited
		number of CTCP messages.<br>
		For example , if you allow one CTCP request in 5 seconds,
		KVIrc will happily reply to the first CTCP and then ignore all
		the other requests until 5 secons have been passed.<br>
		The unreplied requests are treated as "CTCP flood" attacks,
		will trigger an <a href="onctcpflood.kvihelp">OnCtcpFlood</a> event and eventually will be signaled with a warning.<br>
		The protection mechanism works only for the CTCP requests that require a reply.<br>
		A CTCP ACTION (for example) does not require a reply , so it can't be used
		in a "CTCP flood" attack.<br>
		The flood warnings will be signaled in the current window by default , but may
		be redirected to the console.<br>
		Additionally, you can choose to ignore specific CTCP requests.<br>
		Even if you ignore a specific CTCP , the <a href="onctcp.kvihelp">OnCtcp</a> event
		will be still triggered.<br>
*/


KviGeneralOptionsCtcpProtectionWidget::KviGeneralOptionsCtcpProtectionWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION)
{
	QGridLayout *g = new QGridLayout(this,12,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Enable CTCP flood protection"),&(g_pOptions->m_bUseAntiCtcpFlood));
	g->addMultiCellWidget(b1,0,0,0,1);

	KviNewIntegerSelector * i = new KviNewIntegerSelector(this,__tr("Allow maximum of:"),&(g_pOptions->m_iMaxCtcpCount),KviNewIntegerSelector::Int,1,65535,6,g_pOptions->m_bUseAntiCtcpFlood,100,0,0," CTCP(s)");
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));
	g->addWidget(i,1,0);

	i = new KviNewIntegerSelector(this,__tr(" in:"),&(g_pOptions->m_iMaxCtcpTime),KviNewIntegerSelector::Int,1,65535,10,g_pOptions->m_bUseAntiCtcpFlood,100,0,0," second(s)");
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));
	g->addWidget(i,1,1);

	KviNewBoolSelector *b = new KviNewBoolSelector(this,__tr("CTCP flood warnings to console"),&(g_pOptions->m_bCtcpFloodWarningsToConsole),g_pOptions->m_bUseAntiCtcpFlood);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(b,2,2,0,1);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,3,3,0,1);

	b = new KviNewBoolSelector(this,__tr("Ignore CTCP PING"),&(g_pOptions->m_bIgnoreCtcpPingRequests));
	g->addMultiCellWidget(b,4,4,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore CTCP VERSION"),&(g_pOptions->m_bIgnoreCtcpVersionRequests));
	g->addMultiCellWidget(b,5,5,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore CTCP TIME"),&(g_pOptions->m_bIgnoreCtcpTimeRequests));
	g->addMultiCellWidget(b,6,6,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore CTCP USERINFO"),&(g_pOptions->m_bIgnoreCtcpUserinfoRequests));
	g->addMultiCellWidget(b,7,7,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore CTCP CLIENTINFO"),&(g_pOptions->m_bIgnoreCtcpClientinfoRequests));
	g->addMultiCellWidget(b,8,8,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore CTCP SOURCE"),&(g_pOptions->m_bIgnoreCtcpSourceRequests));
	g->addMultiCellWidget(b,9,9,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore CTCP FINGER"),&(g_pOptions->m_bIgnoreCtcpFingerRequests));
	g->addMultiCellWidget(b,10,10,0,1);
	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f,11,11,0,1);
	g->setRowStretch(11,1);

}

KviGeneralOptionsCtcpProtectionWidget::~KviGeneralOptionsCtcpProtectionWidget()
{
}


void KviGeneralOptionsCtcpProtectionWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewIntegerSelector::commitAll(this);
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsDirBrowserWidget
	@widget: Directory browser options
		Here you can setup the directory browser behaviour.<br>
		You can decide to show or not the hidden (dot) files.<br>
		There are three rather self-explaining options that control the sorting of items inside
		the browser.<br>
		The "Open with editor" command is the KVIrc script command to be executed
		when you select "Open with editor" from the borwser context sensitive popup menu.<br>
		Usually it will be something as "run myeditor <a href="s_execfilename.kvihelp">$ExecFilename</a>".<br>
*/


KviGeneralOptionsDirBrowserWidget::KviGeneralOptionsDirBrowserWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER)
{
	QGridLayout *g = new QGridLayout(this,9,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Show hidden files"),&(g_pOptions->m_bDirBrowserShowHiddenFiles));
	g->addWidget(b,0,0);
	b = new KviNewBoolSelector(this,__tr("Group files by extension"),&(g_pOptions->m_bDirBrowserGroupFilesByExtension));
	g->addWidget(b,1,0);
	b = new KviNewBoolSelector(this,__tr("Sort by size"),&(g_pOptions->m_bDirBrowserSortBySize));
	g->addWidget(b,2,0);
	b = new KviNewBoolSelector(this,__tr("Case insensitive sorting"),&(g_pOptions->m_bDirBrowserSortCaseInsensitive));
	g->addWidget(b,3,0);
	KviNewStringSelector * s = new KviNewStringSelector(this,__tr("\"Open with editor\" command ($ExecFileName = filename):"),&(g_pOptions->m_szDirBrowserOpenWithEditorCmd),true,180);
	g->addWidget(s,4,0);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,5,0);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Open as MDI window"),&(g_pOptions->m_bDirBrowserOpenAsMdiWindow));
	g->addWidget(b1,6,0);
	b = new KviNewBoolSelector(this,__tr("Open as undocked MDI window"),&(g_pOptions->m_bDirBrowserOpenAlwaysUndocked),g_pOptions->m_bDirBrowserOpenAsMdiWindow);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	g->addWidget(b,7,0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f,8,0);
	g->setRowStretch(8,1);

}

KviGeneralOptionsDirBrowserWidget::~KviGeneralOptionsDirBrowserWidget()
{
}


void KviGeneralOptionsDirBrowserWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewStringSelector::commitAll(this);
	g_pApp->updateAllDirectoryBrowsers();
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsScriptCenterWidget
	@widget: Script center options
*/


KviGeneralOptionsScriptCenterWidget::KviGeneralOptionsScriptCenterWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER)
{
	QGridLayout *g = new QGridLayout(this,4,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Show as toplevel dialog"),&(g_pOptions->m_bScriptCenterShowAsDialog));
	g->addWidget(b,0,0);
	b = new KviNewBoolSelector(this,__tr("Include the Help Browser tab"),&(g_pOptions->m_bScriptCenterAddHelpBrowser));
	g->addWidget(b,1,0);
	b = new KviNewBoolSelector(this,__tr("Automatically save changes to disk when dialog is closed"),&(g_pOptions->m_bScriptCenterAutoSaveWhenAccepted));
	g->addWidget(b,2,0);

	// Trick
	QFrame * f = new QFrame(this);
	g->addWidget(f,3,0);
	g->setRowStretch(3,1);

}

KviGeneralOptionsScriptCenterWidget::~KviGeneralOptionsScriptCenterWidget()
{
}


void KviGeneralOptionsScriptCenterWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
//	KviNewStringSelector::commitAll(this);
//	g_pApp->updateAllDirectoryBrowsers();
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsInterfaceMiscWidget
	@widget: Miscellaneous interface options
*/


KviGeneralOptionsInterfaceMiscWidget::KviGeneralOptionsInterfaceMiscWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC)
{
	QGridLayout *g = new QGridLayout(this,13,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewStringSelector *s = new KviNewStringSelector(this,__tr("Main window title:"),&(g_pOptions->m_szCaptionMessage),180);
	g->addWidget(s,0,0);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,1,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Save hacked frame geometry"),&(g_pOptions->m_bUseHackedFrameGeometry));
	g->addWidget(b,2,0);
	b = new KviNewBoolSelector(this,__tr("'Hide/Show' hack for brain-damaged windowmanager"),&(g_pOptions->m_bDialogShowHackForBrainDamagedWM));
	g->addWidget(b,3,0);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Windows remember properties"),&(g_pOptions->m_bWindowsRememberProprietes));
	g->addWidget(b1,4,0);
	b = new KviNewBoolSelector(this,__tr("Windows remember dock state"),&(g_pOptions->m_bWindowsRememberDockState),g_pOptions->m_bWindowsRememberProprietes);
	g->addWidget(b,5,0);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	b = new KviNewBoolSelector(this,__tr("Windows remember maximize state"),&(g_pOptions->m_bWindowsRememberMaximizeState),g_pOptions->m_bWindowsRememberProprietes);
	g->addWidget(b,6,0);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,7,0);

	b = new KviNewBoolSelector(this,__tr("Verbose output mode"),&(g_pOptions->m_bBeVerbose));
	g->addWidget(b,8,0);
	b = new KviNewBoolSelector(this,__tr("Automatically disable broken events"),&(g_pOptions->m_bAutoDisableBrokenEvents));
	g->addWidget(b,9,0);
	b1 = new KviNewBoolSelector(this,__tr("Pedantic parser (Halt commands even on non-fatal errors)"),&(g_pOptions->m_bPedanticParser));
	g->addWidget(b1,10,0);
	b = new KviNewBoolSelector(this,__tr("Avoid parser warnings"),&(g_pOptions->m_bAvoidParserWarnings),!g_pOptions->m_bPedanticParser);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setNotEnabled(bool)));
	g->addWidget(b,11,0);
	b = new KviNewBoolSelector(this,__tr("Send unknown commands to server"),&(g_pOptions->m_bSendUnknownCommandsToServer));
	g->addWidget(b,12,0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f,13,0);
	g->setRowStretch(13,1);

}

KviGeneralOptionsInterfaceMiscWidget::~KviGeneralOptionsInterfaceMiscWidget()
{
}


void KviGeneralOptionsInterfaceMiscWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewStringSelector::commitAll(this);
	g_pApp->updateAllFrameCaptions();
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsCtcpMultimediaWidget
	@widget: Ctcp multimedia (sound) options
		In this page you can setup the CTCP MULTIMEDIA requests handling.<br>
		You will find more informations in the <a href="doc_ctcp_multimedia.kvihelp">"Ctcp multimedia protocol"</a> document.<br>
*/


KviGeneralOptionsCtcpMultimediaWidget::KviGeneralOptionsCtcpMultimediaWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA)
{
	QGridLayout *g = new QGridLayout(this,8,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Enable processing for CTCP MULTIMEDIA (SOUND)"),&(g_pOptions->m_bListenToCtcpMultimedia));
	g->addWidget(b1,0,0);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(f,1,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Play the following file when requested file is not found:"),&(g_pOptions->m_bPlayDefaultFileWhenFileNotFound),g_pOptions->m_bListenToCtcpMultimedia);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	g->addWidget(b,2,0);

	KviNewFileSelector * fs = new KviNewFileSelector(this,&(g_pOptions->m_szCtcpMultimediaDefaultFileName),true,g_pOptions->m_bListenToCtcpMultimedia);
	connect(b1,SIGNAL(toggled(bool)),fs,SLOT(setEnabled(bool)));
	g->addWidget(fs,3,0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(f,4,0);

	b = new KviNewBoolSelector(this,__tr("Send \"!nick <filename>\" privmsg request when file is not found"),&(g_pOptions->m_bSendMultimediaRequestWhenFileNotFound),g_pOptions->m_bListenToCtcpMultimedia);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	g->addWidget(b,5,0);

	b = new KviNewBoolSelector(this,__tr("Accept \"!nick <filename>\" privmsg requests"),&(g_pOptions->m_bListenToMultimediaFileRequests));
	g->addWidget(b,6,0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f,7,0);
	g->setRowStretch(7,1);

}

KviGeneralOptionsCtcpMultimediaWidget::~KviGeneralOptionsCtcpMultimediaWidget()
{
}


void KviGeneralOptionsCtcpMultimediaWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	commitFileSelectors();
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsLoggingWidget
	@widget: Logging options
		Here you can setup logging of KVIrc windows.<br>
		Each KVIrc window view has the logging feature built-in.<br>
		You can enable the logging by clicking with the middle button
		in the window view and selecting "start logging".<br>
		If you don't want to repeat this procedure for each window
		that you want to log , you can set the "auto-enable logging" option
		for the specified window type.<br>
		For example, if you auto-enable logging in query windows ,logging
		will be automatically started in all the newly opened query windows.<br>
		Please note that this will NOT enable the logging for the currently open windows,
		you must do it "by hand".<br>
		The log filename will be automatically generated from the window caption , time and date.<br>
		If you use to stay on multiple servers at the same time it may be useful
		to add the server name to the filename of the log.<br>
		This will prevent log filenames collision when you're on channels with the same name
		but on different server.<br>
		Finally, you can enable or disable logging for specific message types.<br>
		For example you might want to avoid to log the 'internally started processes output'.<br>
*/


KviGeneralOptionsLoggingWidget::KviGeneralOptionsLoggingWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING)
{
	QGridLayout *g = new QGridLayout(this,11,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Automatically enable logging in console window"),&(g_pOptions->m_bAutoLogConsole));
	g->addWidget(b,0,0);
	b = new KviNewBoolSelector(this,__tr("Automatically enable logging in channel windows"),&(g_pOptions->m_bAutoLogChannels));
	g->addWidget(b,1,0);
	b = new KviNewBoolSelector(this,__tr("Automatically enable logging in query windows"),&(g_pOptions->m_bAutoLogQueries));
	g->addWidget(b,2,0);
	b = new KviNewBoolSelector(this,__tr("Automatically enable logging in DCC chat windows"),&(g_pOptions->m_bAutoLogChats));
	g->addWidget(b,3,0);
	b = new KviNewBoolSelector(this,__tr("Automatically enable logging in DCC send windows"),&(g_pOptions->m_bAutoLogSends));
	g->addWidget(b,4,0);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(f,5,0);

	b = new KviNewBoolSelector(this,__tr("Append server name to log filename (if possible)"),&(g_pOptions->m_bAppendServerNameToLogName));
	g->addWidget(b,6,0);

	b = new KviNewBoolSelector(this,__tr("Append date to log filename"),&(g_pOptions->m_bAppendDateToLogName));
	g->addWidget(b,7,0);


	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(f,8,0);

	QLabel * l = new QLabel(_CHAR_2_QSTRING(__tr("Log message types")),this);
	g->addWidget(l,9,0);

	m_pLogMsgTypesView = new QListView(this);
	m_pLogMsgTypesView->addColumn(_CHAR_2_QSTRING(__tr("Message Type")));
	m_pLogMsgTypesView->addColumn(_CHAR_2_QSTRING(__tr("Enable Logging")));
	m_pLogMsgTypesView->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
	m_pLogMsgTypesView->setSorting(-1);
	m_pLogMsgTypesView->header()->setClickEnabled(false);
	m_pLogMsgTypesView->setMultiSelection(false);
	m_pLogMsgTypesView->setAllColumnsShowFocus(true);

	QListViewItem * it = 0;
	// DO NOT TRANSLATE YES AND NO HERE!
	for(int i=0;i< KVI_OUT_NUM_IMAGES;i++){
		it = new QListViewItem(m_pLogMsgTypesView,
			_CHAR_2_QSTRING(_i18n_translateNoText(messageTypeString[i])),
			(g_pOptions->m_bLogMsgType[i] ? _CHAR_2_QSTRING("yes") : _CHAR_2_QSTRING("no")) );
		it->setPixmap(0,(*g_pixViewOut[i]));
	}

	connect(m_pLogMsgTypesView,SIGNAL(doubleClicked(QListViewItem *)),
		this,SLOT(logMsgTypeViewItemDoubleClicked(QListViewItem *)));


	g->addWidget(m_pLogMsgTypesView,10,0);
	g->setRowStretch(10,2);

}

KviGeneralOptionsLoggingWidget::~KviGeneralOptionsLoggingWidget()
{
}

void KviGeneralOptionsLoggingWidget::logMsgTypeViewItemDoubleClicked(QListViewItem *it)
{
	if(!it)return;
	KviStr state = it->text(1);
	if(kvi_strEqualCIN("yes",state.ptr(),3)){
		it->setText(1,_CHAR_2_QSTRING("no"));
	} else it->setText(1,_CHAR_2_QSTRING("yes"));
}

void KviGeneralOptionsLoggingWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	QListViewItem * it = m_pLogMsgTypesView->firstChild();
	while(it){
		// Can not rely on sorting order of the QListView..:(((
		KviStr tmp = it->text(0);
		for(int i = 0;tmp.hasData() && (i < KVI_OUT_NUM_IMAGES);i++){
			if(kvi_strEqualCI(_i18n_translateNoText(messageTypeString[i]),tmp.ptr())){
				tmp = it->text(1);
				g_pOptions->m_bLogMsgType[i] = kvi_strEqualCIN("yes",tmp.ptr(),3);
				tmp = "";
			}
		}
		if(tmp.hasData())debug(__tr("Warning: Cannot update logging state for message type %s"),tmp.ptr());
		it = it->nextSibling();
	}
}

/////////////////

/*
	@quickhelp: KviGeneralOptionsRedirectionsWidget
	@widget: Output messages redirection options
		Most of the messages that KVIrc prints in the channel
		or "active" windows can be redirected to the console.<br>
		For example , if you use to join high traffic channels
		with many users joining and leaving , you may want
		to redirect QUIT, JOIN and PART messages to console
		so you will be able to follow the discussions on the channel.
*/


KviGeneralOptionsRedirectionsWidget::KviGeneralOptionsRedirectionsWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS)
{
	QGridLayout *g = new QGridLayout(this,17,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,0);

	QLabel * l = new QLabel(_CHAR_2_QSTRING(__tr("Redirect to console the following messages:")),this);
	g->addMultiCellWidget(l,0,0,0,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Join messages"),&(g_pOptions->m_bJoinMsgsToConsole));
	g->addWidget(b,1,0);
	b = new KviNewBoolSelector(this,__tr("Part messages"),&(g_pOptions->m_bPartMsgsToConsole));
	g->addWidget(b,2,0);
	b = new KviNewBoolSelector(this,__tr("Kick messages"),&(g_pOptions->m_bKickMsgsToConsole));
	g->addWidget(b,3,0);
	b = new KviNewBoolSelector(this,__tr("Quit messages"),&(g_pOptions->m_bQuitMsgsToConsole));
	g->addWidget(b,4,0);
	b = new KviNewBoolSelector(this,__tr("Nick changes"),&(g_pOptions->m_bNickMsgsToConsole));
	g->addWidget(b,5,0);
	b = new KviNewBoolSelector(this,__tr("Nickname errors"),&(g_pOptions->m_bNicknameErrorsToConsole));
	g->addWidget(b,6,0);
	b = new KviNewBoolSelector(this,__tr("User mode changes"),&(g_pOptions->m_bUserModeChangesToConsole));
	g->addWidget(b,7,0);
	b = new KviNewBoolSelector(this,__tr("Channel mode changes"),&(g_pOptions->m_bChannelModeChangesToConsole));
	g->addWidget(b,8,0);
	b = new KviNewBoolSelector(this,__tr("Ban, invite and exception lists"),&(g_pOptions->m_bBanAndExceptionListToConsole));
	g->addWidget(b,9,0);
	b = new KviNewBoolSelector(this,__tr("Topic changes"),&(g_pOptions->m_bTopicMsgsToConsole));
	g->addWidget(b,10,0);
	b = new KviNewBoolSelector(this,__tr("Invite messages"),&(g_pOptions->m_bInviteMessagesToConsole));
	g->addWidget(b,11,0);
	b = new KviNewBoolSelector(this,__tr("Notices from off-channel users"),&(g_pOptions->m_bOffChannelNoticesToConsole));
	g->addWidget(b,12,0);
	b = new KviNewBoolSelector(this,__tr("Private CTCP requests"),&(g_pOptions->m_bCtcpRequestsToConsole));
	g->addWidget(b,13,0);
	b = new KviNewBoolSelector(this,__tr("Channel CTCP requests"),&(g_pOptions->m_bChannelCtcpRequestsToConsole));
	g->addWidget(b,14,0);
	b = new KviNewBoolSelector(this,__tr("CTCP replies"),&(g_pOptions->m_bCtcpRepliesToConsole));
	g->addWidget(b,15,0);


	b = new KviNewBoolSelector(this,__tr("Wallop messages"),&(g_pOptions->m_bWallopsToConsole));
	g->addWidget(b,1,1);
	b = new KviNewBoolSelector(this,__tr("Names replies"),&(g_pOptions->m_bNamesReplyToConsole));
	g->addWidget(b,2,1);
	b = new KviNewBoolSelector(this,__tr("Who replies"),&(g_pOptions->m_bWhoMsgsToConsole));
	g->addWidget(b,3,1);
	b = new KviNewBoolSelector(this,__tr("Whois replies"),&(g_pOptions->m_bWhoisRepliesToConsole));
	g->addWidget(b,4,1);
	b = new KviNewBoolSelector(this,__tr("Notify list changes"),&(g_pOptions->m_bNotifyListChangesToConsole));
	g->addWidget(b,5,1);
	b = new KviNewBoolSelector(this,__tr("Server info"),&(g_pOptions->m_bServerInfoToConsole));
	g->addWidget(b,6,1);
	b = new KviNewBoolSelector(this,__tr("Server notices"),&(g_pOptions->m_bServerNoticesToConsole));
	g->addWidget(b,7,1);
	b = new KviNewBoolSelector(this,__tr("Unhandled numerics"),&(g_pOptions->m_bUnhandledNumericsToConsole));
	g->addWidget(b,8,1);
	b = new KviNewBoolSelector(this,__tr("Unhandled literals"),&(g_pOptions->m_bUnhandledLiteralsToConsole));
	g->addWidget(b,9,1);
	b = new KviNewBoolSelector(this,__tr("Unhandled server errors"),&(g_pOptions->m_bUnhandledServerErrorsToConsole));
	g->addWidget(b,10,1);
	b = new KviNewBoolSelector(this,__tr("Local desync warnings"),&(g_pOptions->m_bDesyncMsgsToConsole));
	g->addWidget(b,11,1);
	b = new KviNewBoolSelector(this,__tr("Split warnings"),&(g_pOptions->m_bSplitWarningsToConsole));
	g->addWidget(b,12,1);
	b = new KviNewBoolSelector(this,__tr("DNS results"),&(g_pOptions->m_bDnsResultsToConsole));
	g->addWidget(b,13,1);
	b = new KviNewBoolSelector(this,__tr("Process output"),&(g_pOptions->m_bProcessOutputToConsole));
	g->addWidget(b,14,1);

	// Trick
	QFrame * f = new QFrame(this);
	g->addMultiCellWidget(f,16,16,0,1);
	g->setRowStretch(16,1);

}

KviGeneralOptionsRedirectionsWidget::~KviGeneralOptionsRedirectionsWidget()
{
}


void KviGeneralOptionsRedirectionsWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
}
//////////////////
/*
	@quickhelp: KviGeneralOptionsDccGeneralWidget
	@widget: DCC general options
		Here you can set the general options for all the dcc transfers.<br>
		You can choose to ignore all the incoming DCC request or
		to notify all the requests in the console.<br>
		The outgoing DCC requests may be forced to be bound to a specific
		network interface: you may specify its IP address.<br>
		The outgoing dcc
*/


KviGeneralOptionsDccGeneralWidget::KviGeneralOptionsDccGeneralWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL)
{
	QGridLayout *g = new QGridLayout(this,14,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Ignore all DCC requests"),&(g_pOptions->m_bIgnoreDccRequests));
	g->addMultiCellWidget(b1,0,0,0,1);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,1,1,0,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Notify all requests in console"),&(g_pOptions->m_bNotifyAllDccRequestsInConsole),!g_pOptions->m_bIgnoreDccRequests);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setNotEnabled(bool)));
	g->addMultiCellWidget(b,2,2,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,3,3,0,1);

	QLabel * l = new QLabel(_CHAR_2_QSTRING(__tr("Save incoming files to the following directory:")),this);
	g->addMultiCellWidget(l,4,4,0,1);

	m_pIncomingDirEdit = new QLineEdit(this);
	m_pIncomingDirEdit->setText(g_pOptions->m_szLocalIncomingDirectory.ptr());
	g->addWidget(m_pIncomingDirEdit,5,0);
	QPushButton * pb = new QPushButton(__tr("&Browse..."),this);
	connect(pb,SIGNAL(clicked()),this,SLOT(chooseIncomingDir()));
	g->addWidget(pb,5,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,6,6,0,1);

	b1 = new KviNewBoolSelector(this,__tr("Use the following local IP address for outgoing DCC requests"),&(g_pOptions->m_bUseUserDefinedIpForDccRequests));
	g->addMultiCellWidget(b1,7,7,0,1);

	KviNewIpSelector * i = new KviNewIpSelector(this,__tr("Local IP address to force: "),&(g_pOptions->m_szDccLocalIpAddress),g_pOptions->m_bUseUserDefinedIpForDccRequests);
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(i,8,8,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f,9,9,0,1);

	b = new KviNewBoolSelector(this,__tr("Use the following range of ports for send requests"),&(g_pOptions->m_bDccListenOnPortsInRange));
	g->addMultiCellWidget(b,10,10,0,1);

	KviNewIntegerSelector * ins = new KviNewIntegerSelector(this,__tr("Minimum (1-65535):"),&(g_pOptions->m_uMinDccListenPort),
			KviNewIntegerSelector::UShort,1,65535,1025,g_pOptions->m_bDccListenOnPortsInRange);
	g->addMultiCellWidget(ins,11,11,0,1);
	connect(b,SIGNAL(toggled(bool)),ins,SLOT(setEnabled(bool)));

	ins = new KviNewIntegerSelector(this,__tr("Maximum (1-65535):"),&(g_pOptions->m_uMaxDccListenPort),
			KviNewIntegerSelector::UShort,1,65535,65000,g_pOptions->m_bDccListenOnPortsInRange);
	g->addMultiCellWidget(ins,12,12,0,1);
	connect(b,SIGNAL(toggled(bool)),ins,SLOT(setEnabled(bool)));

	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f,13,13,0,1);
	g->setRowStretch(13,1);

}

KviGeneralOptionsDccGeneralWidget::~KviGeneralOptionsDccGeneralWidget()
{
}

void KviGeneralOptionsDccGeneralWidget::chooseIncomingDir()
{
	KviStr szPath;
	g_pApp->getLocalKVircDirectory(szPath,KviApp::None);
	KviStr tmp = kvi_askForDirectoryName(szPath.ptr());
	if(tmp.hasData())m_pIncomingDirEdit->setText(tmp.ptr());
}

void KviGeneralOptionsDccGeneralWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	commitIpSelectors();
	KviNewIntegerSelector::commitAll(this);
	g_pOptions->m_szLocalIncomingDirectory = m_pIncomingDirEdit->text();
}

//////////////////
/*
	@quickhelp: KviGeneralOptionsDccChatWidget
	@widget: DCC chat options
		Here you can set the options for the DCC chat connections.<br>
		You can choose to make KVIrc automatically accept all the incoming DCC Chat
		connections (otherwise you will be asked for the permission).<br>
		Please note that if you have disabled all the incoming DCC requests
		the DCC chat will NOT WORK.<br>
*/


KviGeneralOptionsDccChatWidget::KviGeneralOptionsDccChatWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT)
{
	QGridLayout *g = new QGridLayout(this,3,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Automatically accept"),&(g_pOptions->m_bAutoAcceptDccChat));
	g->addWidget(b,0,0);

	b = new KviNewBoolSelector(this,__tr("Create iconified"),&(g_pOptions->m_bCreateIconifiedDccChat));
	g->addWidget(b,1,0);

	// Trick
	QFrame * f = new QFrame(this);
	g->addWidget(f,2,0);
	g->setRowStretch(2,1);

}

KviGeneralOptionsDccChatWidget::~KviGeneralOptionsDccChatWidget()
{
}
void KviGeneralOptionsDccChatWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
//	commitIpSelectors();
}
//////////////////

/*
	@quickhelp: KviGeneralOptionsDccSendWidget
	@widget: DCC send options
		Here you can set the options for the DCC send connections.<br>
		You can choose to make KVIrc automatically accept all the incoming DCC Chat
		connections (otherwise you will be asked for the permission and a directory).<br>
		For the autoaccepted dcc sends KVIrc will choose automatically a destination
		directory (the save path of the <a href="doc_mimetypes.kvihelp">mimetype</a> of the incoming file
		or the default dcc save directory that is the $LocalKVIrcDir/incoming).<br>
		KVIrc is able to resume interrupted dcc send connections.<br>
		If you choose to autoaccept the dcc sends , the file transfers will be NEWER resumed:
		the new files will be always autorenamed and saved to the usual directory.<br>
		Some users with ip masquerading may choose to ignore the port number in the incoming
		resume requests : the explaination is quite complex so if resume does not work for you
		and you have an ip-masq'ed machine, just try this.<br>
		You can choose to use the fast-send method (also known as "send-ahead"):
		usually it is a good choice , it will make your transfers faster.<br>
		For the packet size 512 is usually a good choice.<br>
		Some minor options can be also set:<br>
		- notification of the succesful transfers to the console.<br>
		- auto close of the dcc send window after a succesfull transfer.<br>
		- replacement of spaces with underscores in filenames (may help some clients in processing the
		dcc requests).<br>
		Please note that if you have disabled all the incoming DCC requests
		the DCC send will NOT WORK.<br>
		The "Send zero ack in dcc get sessions" is an option for some broken
		IRC clients that need a 0 bytes acknowledge to start sending the file.<br>
		If you see that all your dcc get sessions stall without receiving data ,
		you may try this option.<br>
*/


KviGeneralOptionsDccSendWidget::KviGeneralOptionsDccSendWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND)
{
	QGridLayout *g = new QGridLayout(this,11,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Automatically accept"),&(g_pOptions->m_bAutoAcceptDccSend));
	g->addWidget(b,0,0);

	b = new KviNewBoolSelector(this,__tr("Enable resume on auto-accept"),&(g_pOptions->m_bEnableResumeOnAutoAccept));
	g->addWidget(b,1,0);

	b = new KviNewBoolSelector(this,__tr("Create iconified"),&(g_pOptions->m_bCreateIconifiedDccSend));
	g->addWidget(b,2,0);

	b = new KviNewBoolSelector(this,__tr("Automatically close on success"),&(g_pOptions->m_bAutoCloseDccSendOnSuccess));
	g->addWidget(b,3,0);

	b = new KviNewBoolSelector(this,__tr("Notify completion in console"),&(g_pOptions->m_bNotifyDccSendCompletionInConsole));
	g->addWidget(b,4,0);

	b = new KviNewBoolSelector(this,__tr("Replace spaces with underscores in filenames"),&(g_pOptions->m_bReplaceSpacesInDccSendFileNames));
	g->addWidget(b,5,0);

	b = new KviNewBoolSelector(this,__tr("Ignore port number in resume requests"),&(g_pOptions->m_bIgnorePortNumberInResumeRequests));
	g->addWidget(b,6,0);

	b = new KviNewBoolSelector(this,__tr("Send zero ack in DCC get sessions (for broken clients)"),&(g_pOptions->m_bDccGetSendZeroAck));
	g->addWidget(b,7,0);

	b = new KviNewBoolSelector(this,__tr("Use fast send (a.k.a. send ahead)"),&(g_pOptions->m_bUseFastDccSend));
	g->addWidget(b,8,0);

	KviNewIntegerSelector * i = new KviNewIntegerSelector(this,__tr("Packet size (1-4096 bytes):"),&(g_pOptions->m_iDccSendBlockSize),
			KviNewIntegerSelector::Int,1,KVI_DCC_SEND_MAX_BLOCK_SIZE,512);
	g->addWidget(i,9,0);

	// Trick
	QFrame * f = new QFrame(this);
	g->addWidget(f,10,0);
	g->setRowStretch(10,1);

}

KviGeneralOptionsDccSendWidget::~KviGeneralOptionsDccSendWidget()
{
}
void KviGeneralOptionsDccSendWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewIntegerSelector::commitAll(this);
}

//////////////////
/*
	@quickhelp: KviGeneralOptionsDccVoiceWidget
	@widget: DCC voice options
		Here you can set the options for the DCC Voice connections.<br>
		You can choose to auto accepth the connection (otherwise you will be asked for the permission).<br>
		KVIrc 0.9.0 had a "theoretical" bug in the compression/decompression algorythms that
		made it compress the data stream inefficently.<br>
		You can choose to emulate this bug if you want to talk with 0.9.0 clients.<br>
		It will work even without this option , but the remote user will hear
		a small "click" for each data packet decompressed.<br>
		The same may happen if you try to talk to a KVIrc >= 1.0.0 client with this option enabled.<br>
*/


KviGeneralOptionsDccVoiceWidget::KviGeneralOptionsDccVoiceWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE)
{
	QGridLayout *g = new QGridLayout(this,6,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Automatically accept"),&(g_pOptions->m_bAutoAcceptDccVoice));
	g->addWidget(b,0,0);

	b = new KviNewBoolSelector(this,__tr("Create iconified"),&(g_pOptions->m_bCreateIconifiedDccVoice));
	g->addWidget(b,1,0);

	KviNewStringSelector *s = new KviNewStringSelector(this,__tr("Sound device:"),&(g_pOptions->m_szSoundDevice),180);
	g->addWidget(s,2,0);

	b = new KviNewBoolSelector(this,__tr("Sound device is full-duplex"),&(g_pOptions->m_bFullDuplexSoundDevice));
	g->addWidget(b,3,0);

	b = new KviNewBoolSelector(this,__tr("KVIrc 0.9.0 compatible compression (Simulate 0.9.0 bug)"),&(g_pOptions->m_b090CompatibleVoiceCompression));
	g->addWidget(b,4,0);

	// Trick
	QFrame * f = new QFrame(this);
	g->addWidget(f,5,0);
	g->setRowStretch(5,1);

}

KviGeneralOptionsDccVoiceWidget::~KviGeneralOptionsDccVoiceWidget()
{
}

void KviGeneralOptionsDccVoiceWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewStringSelector::commitAll(this);
//	commitIpSelectors();
}

//////////////////
/*
	@quickhelp: KviGeneralOptionsOutputWidget
	@widget: Irc output options
		Here you can fine tune some of the KVIrc output.<br>
		The "Show server pings" option enables or disables displaying of the
		"Ping request from irc.myserver.com...replied" messages.<br>
		On some "pedantic" servers these messages can flood the console.<br>
		When the "Show own parts" option is enabled , when you leave a channel
		the notification of the PART is printed in the console.<br>
		This is useful when you want to "remember" which channels you have visited.<br>
		Own nickname changes are usually shown only in the channel windows.<br>
		If you want to "centralize" this output, you can ask KVIrc to print it to
		the console too.<br>
		The "Ignore MOTD" option hides the "Message of the day" sent by the servers.<br>
		The "Show extended server info" option enables analyzing of the informations
		sent by the server at login time.<br>
		The server flags are analyzed and converted into nearly human readable
		feature descriptions of the current server daemon.<br>
		KVIrc usually will not show the channel WHO replies , since these are requested
		often for entire channels to acquire users data.<br>
		You can force KVIrc to show all that messages.<br>
		The same applies to the invite and exception list replies.<br>
		KVIrc features a small anti-spam algorithm.<br>
		If you enable it, KVirc will try to scan the private messages directed
		specifically to you and that would cause a new query window to be created.<br>
		In the scan KVIrc will look for some common "spam features", and once classified
		a private message as a spam attempt, it will redirect it to the console.
		This will avoid you to be flooded by new senseless query windows that would
		just interrupt your other "serious" conversations.<br>
*/


KviGeneralOptionsOutputWidget::KviGeneralOptionsOutputWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT)
{
	QGridLayout *g = new QGridLayout(this,20,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	KviNewBoolSelector *b = new KviNewBoolSelector(this,__tr("Show channel sync time"),&(g_pOptions->m_bShowChannelSyncTime));
	g->addMultiCellWidget(b,0,0,0,1);
	b = new KviNewBoolSelector(this,__tr("Show multiple channel mode changes in single message"),&(g_pOptions->m_bSingleMessageForChannelModes));
	g->addMultiCellWidget(b,1,1,0,1);
	b = new KviNewBoolSelector(this,__tr("Show server pings"),&(g_pOptions->m_bShowPingPong));
	g->addMultiCellWidget(b,2,2,0,1);
	b = new KviNewBoolSelector(this,__tr("Show own parts"),&(g_pOptions->m_bShowOwnParts));
	g->addMultiCellWidget(b,3,3,0,1);
	b = new KviNewBoolSelector(this,__tr("Show own nick changes in console"),&(g_pOptions->m_bShowOwnNickChanges));
	g->addMultiCellWidget(b,4,4,0,1);
	b = new KviNewBoolSelector(this,__tr("Ignore MOTD"),&(g_pOptions->m_bSkipMotd));
	g->addMultiCellWidget(b,5,5,0,1);
	b = new KviNewBoolSelector(this,__tr("Show extended server info"),&(g_pOptions->m_bShowExtendedServerInfo));
	g->addMultiCellWidget(b,6,6,0,1);
	b = new KviNewBoolSelector(this,__tr("Show internal who replies"),&(g_pOptions->m_bShowInternalWhoMessages));
	g->addMultiCellWidget(b,7,7,0,1);
	b = new KviNewBoolSelector(this,__tr("Show internal ban and invite exception list replies"),&(g_pOptions->m_bShowBanAndExceptionList));
	g->addMultiCellWidget(b,8,8,0,1);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(f,9,9,0,1);

	b = new KviNewBoolSelector(this,__tr("Create query windows on remote privmsg"),&(g_pOptions->m_bCreateQueryOnPrivmsg));
	g->addMultiCellWidget(b,10,10,0,1);
	b = new KviNewBoolSelector(this,__tr("Create query windows on remote notice"),&(g_pOptions->m_bCreateQueryOnNotice));
	g->addMultiCellWidget(b,11,11,0,1);
	b = new KviNewBoolSelector(this,__tr("Create minimized query windows"),&(g_pOptions->m_bCreateIconifiedQuery));
	g->addMultiCellWidget(b,12,12,0,1);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addMultiCellWidget(f,13,13,0,1);

	b = new KviNewBoolSelector(this,__tr("Filter common \"spam\" messages from new queries"),&(g_pOptions->m_bUseSmallAntispamOnPrivmsg));
	g->addMultiCellWidget(b,14,14,0,1);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(this,__tr("Enable query/clone flood protection"),&(g_pOptions->m_bUseAntiQueryFlood));
	g->addMultiCellWidget(b1,15,15,0,1);
	KviNewIntegerSelector * i = new KviNewIntegerSelector(this,__tr("Maximum number of query windows (QUERY can override):"),&(g_pOptions->m_iMaxTotalQueries),KviNewIntegerSelector::Int,1,65535,12,g_pOptions->m_bUseAntiQueryFlood);
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(i,16,16,0,1);
	i = new KviNewIntegerSelector(this,__tr("Create maximum of:"),&(g_pOptions->m_iMaxQueryCount),KviNewIntegerSelector::Int,1,65535,3,g_pOptions->m_bUseAntiQueryFlood);
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));
	g->addWidget(i,17,0);
	i = new KviNewIntegerSelector(this,__tr(" query windows in:"),&(g_pOptions->m_iMaxQueryTime),KviNewIntegerSelector::Int,1,65535,10,g_pOptions->m_bUseAntiQueryFlood,100,0,0," second(s)");
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));
	g->addWidget(i,17,1);
	b = new KviNewBoolSelector(this,__tr("Clone flood warnings to console"),&(g_pOptions->m_bQueryFloodWarningsToConsole),g_pOptions->m_bUseAntiQueryFlood);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));
	g->addMultiCellWidget(b,18,18,0,1);

//	KviIpEditor * ed = new KviIpEditor(this,"127.0.0.1");
//	ed->setEnabled(false);
//	g->addWidget(ed,9,0);
	// Trick
	f = new QFrame(this);
	g->addMultiCellWidget(f,19,19,0,1);
	g->setRowStretch(19,1);

}

KviGeneralOptionsOutputWidget::~KviGeneralOptionsOutputWidget()
{
}


void KviGeneralOptionsOutputWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewIntegerSelector::commitAll(this);
}
/////////////

/*
	@quickhelp: KviGeneralOptionsIrcMiscWidget
	@widget: Miscellaneous IRC options
		<h2>Audio Notification</h2>
		A few enhancements to make conversation easier when multi-tasking at or
		away from the desktop, by allowing you to select that certain users will
		cause a beep to be sounded if they type something to you and the window
		is hidden.<br><br>
		<b>Enable Beeping</b>&nbsp;Globally enables/disables whether any event
		will cause an audio alert to be generated, whilst preserving any individual settings.<br>
		<b>Beep on new query opened</b>&nbsp;Causes an audio alert to be sounded
		if a query box is opended from a /msg, regardless of whether the remote user
		is in the registered users database or not. Also works for DCC chat sessions.<br>
		<b>Make beep setting persistant</b>&nbsp;If this option is selected, the
		registered users database is used to hold a record of beep options for all users,
		even if you had not previously entered that user. This is handy, as it provides
		persistant beep settings across multiple sessions. It has the downside that it
		could clutter up your user database if you do not turn beeping off on a user
		before you finish talking to them (though you could always hand delete later).<br>
		If you <em>do</em> turn this feature on, KVirc will forget who you want to have
		beep unless they are already in the database for another reason.<br>
*/


KviGeneralOptionsIrcMiscWidget::KviGeneralOptionsIrcMiscWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC)
{

	QGridLayout *g = new QGridLayout(this,20,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Force 'brutal' quit"),&(g_pOptions->m_bBrutalQuit));
	g->addWidget(b,0,0);

	QFrame * f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,1,0);

	b = new KviNewBoolSelector(this,__tr("Automatically rejoin channels when kicked"),&(g_pOptions->m_bAutoRejoinOnKick));
	g->addWidget(b,2,0);
	b = new KviNewBoolSelector(this,__tr("Dump channel status to file when kicked"),&(g_pOptions->m_bDumpChannelOnKick));
	g->addWidget(b,3,0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,4,0);

	b = new KviNewBoolSelector(this,__tr("Automatically join channels when invited"),&(g_pOptions->m_bAutoJoinChanOnInvite));
	g->addWidget(b,5,0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,6,0);

	b = new KviNewBoolSelector(this,__tr("Request ban and invite exception lists on join"),&(g_pOptions->m_bRequestBanExceptionListOnJoin));
	g->addWidget(b,7,0);
	b = new KviNewBoolSelector(this,__tr("Request who list after end of names list"),&(g_pOptions->m_bRequestWhoAfterEndOfNames));
	g->addWidget(b,8,0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,9,0);

	b = new KviNewBoolSelector(this,__tr("Disable updates to the internal userlist"),&(g_pOptions->m_bDisableUpdateUserList));
	g->addWidget(b,10,0);

	KviNewIntegerSelector * i = new KviNewIntegerSelector(this,__tr("Userlist update interval:"),&(g_pOptions->m_iUserListUpdateTimeoutInSecs),
		KviNewIntegerSelector::Int,1,65535,10,!g_pOptions->m_bDisableUpdateUserList,100,0,0," second(s)");
	connect(b,SIGNAL(toggled(bool)),i,SLOT(setNotEnabled(bool)));
	g->addWidget(i,11,0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,12,0);

	b = new KviNewBoolSelector(this,__tr("Enable beeping"),&(g_pOptions->m_bEnableBeeping));
	g->addWidget(b,13,0);

	b = new KviNewBoolSelector(this,__tr("Beep on new query/DCC chat"),&(g_pOptions->m_bBeepOnNewQuery));
	g->addWidget(b,14,0);

	b = new KviNewBoolSelector(this,__tr("Make beep setting persistant"),&(g_pOptions->m_bAddUsersForBeepControl));
	g->addWidget(b,15,0);

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f,16,0);

	i = new KviNewIntegerSelector(this, __tr("Length of inactivity after " \
		"OnIdleStart event is triggered:"),
		&(g_pOptions->m_iOnIdleAfter), KviNewIntegerSelector::Int, 20,
		65535, 10, true, 100,0,0," second(s)");
	g->addWidget(i,17,0);
	
	b = new KviNewBoolSelector(this, __tr("Trigger OnIdleStop event even on"
		" command input"), &(g_pOptions->m_bCancelIdleOnAnyInput));
	g->addWidget(b,18,0);

	f = new QFrame(this);
	g->addWidget(f,19,0);
	g->setRowStretch(19,1);
}

KviGeneralOptionsIrcMiscWidget::~KviGeneralOptionsIrcMiscWidget()
{
}


void KviGeneralOptionsIrcMiscWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	KviNewIntegerSelector::commitAll(this);
}

/////////////

/*
	@quickhelp: KviGeneralOptionsPluginsWidget
	@widget: Plugin manager dialog
		From this dialog you can load and unload plugins.<br>
		You can obtain help about one of the loaded plugins
		by clicking the "plugin help" button after selecting
		the plugin in the list box.<br>
		This function will be available only if the plugin
		exports a help routine.<br>
		If the plugin has a configuration dialog , it will be
		accessible by clicking the "Configure plugin" button.<br>
		The "autoload on startup" option makes the plugin be
		loaded at every KVIrc startup until is explicitly unloaded.<br>
		This dialog will not be available if KVIrc has been compiled
		without the plugin support.<br>
*/


KviGeneralOptionsPluginsWidget::KviGeneralOptionsPluginsWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS)
{

#ifdef COMPILE_PLUGIN_SUPPORT

	QGridLayout *g = new QGridLayout(this,8,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	m_pPluginBox = new QListBox(this);
	m_pPluginBox->setMultiSelection(false);
	connect(m_pPluginBox,SIGNAL(highlighted(const QString &)),this,SLOT(pluginListItemSelected(const QString &)));
	g->addMultiCellWidget(m_pPluginBox,0,5,0,0);

	QPushButton *load = new QPushButton(__tr("&Load Plugin"),this);
	connect(load,SIGNAL(clicked()),this,SLOT(pluginLoad()));
	g->addWidget(load,6,0);

	m_pUnloadPlugin = new QPushButton(__tr("&Unload Plugin"),this);
	connect(m_pUnloadPlugin,SIGNAL(clicked()),this,SLOT(pluginUnload()));
	g->addWidget(m_pUnloadPlugin,7,0);

	QLabel * l = new QLabel(_CHAR_2_QSTRING(__tr("Module name:")),this);
	g->addWidget(l,0,1);
	m_pPluginModuleNameLabel = new QLabel(this);
	m_pPluginModuleNameLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pPluginModuleNameLabel,0,2);

	l = new QLabel(_CHAR_2_QSTRING(__tr("Service name:")),this);
	g->addWidget(l,1,1);
	m_pPluginServiceNameLabel = new QLabel(this);
	m_pPluginServiceNameLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pPluginServiceNameLabel,1,2);

	l = new QLabel(_CHAR_2_QSTRING(__tr("Author:")),this);
	g->addWidget(l,2,1);
	m_pPluginAuthorLabel = new QLabel(this);
	m_pPluginAuthorLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pPluginAuthorLabel,2,2);

	l = new QLabel(_CHAR_2_QSTRING(__tr("Version:")),this);
	g->addWidget(l,3,1);
	m_pPluginVersionLabel = new QLabel(this);
	m_pPluginVersionLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	g->addWidget(m_pPluginVersionLabel,3,2);

	l = new QLabel(_CHAR_2_QSTRING(__tr("Description:")),this);
	l->setAlignment(AlignTop);
	g->addWidget(l,4,1);
	m_pPluginDescriptionLabel = new QLabel(this);
	m_pPluginDescriptionLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	m_pPluginDescriptionLabel->setAlignment(AlignLeft|AlignTop|WordBreak);
	g->addWidget(m_pPluginDescriptionLabel,4,2);

	g->setRowStretch(4,2);

	m_pPluginAutoloadCheck = new QCheckBox(__tr("Automatically load on startup"),this);
	m_pPluginAutoloadCheck->setMinimumSize(m_pPluginAutoloadCheck->sizeHint());
	connect(m_pPluginAutoloadCheck,SIGNAL(toggled(bool)),this,SLOT(pluginAutoloadToggled(bool)));
	g->addMultiCellWidget(m_pPluginAutoloadCheck,5,5,1,2);

	m_pConfigurePlugin = new QPushButton(__tr("&Configure Plugin"),this);
	connect(m_pConfigurePlugin,SIGNAL(clicked()),this,SLOT(pluginConfigure()));
	g->addMultiCellWidget(m_pConfigurePlugin,6,6,1,2);

	m_pHelpOnPlugin = new QPushButton(__tr("Plugin &Help"),this);
	connect(m_pHelpOnPlugin,SIGNAL(clicked()),this,SLOT(pluginHelp()));
	g->addMultiCellWidget(m_pHelpOnPlugin,7,7,1,2);

	fillPluginBox();

#endif

}

KviGeneralOptionsPluginsWidget::~KviGeneralOptionsPluginsWidget()
{
}


void KviGeneralOptionsPluginsWidget::commitChanges()
{
}

#ifdef COMPILE_PLUGIN_SUPPORT

void KviGeneralOptionsPluginsWidget::fillPluginBox(unsigned int selectIdx)
{
	m_pPluginBox->clear();
	QList<KviPluginData> *l=g_pPluginManager->pluginList();
	for(KviPluginData *d=l->first();d;d=l->next()){
		m_pPluginBox->insertItem(_CHAR_2_QSTRING(d->filename.ptr()));
	}
	if(m_pPluginBox->count() == 0){
		m_pPluginModuleNameLabel->setText("");
		m_pPluginVersionLabel->setText("");
		m_pPluginServiceNameLabel->setText("");
		m_pPluginDescriptionLabel->setText("");
		m_pPluginAuthorLabel->setText("");
		m_pUnloadPlugin->setEnabled(false);
		m_pConfigurePlugin->setEnabled(false);
		m_pPluginAutoloadCheck->setEnabled(false);
		m_pHelpOnPlugin->setEnabled(false);
	} else m_pPluginBox->setCurrentItem(selectIdx);
}

#endif

void KviGeneralOptionsPluginsWidget::pluginListItemSelected(const QString &str)
{
#ifdef COMPILE_PLUGIN_SUPPORT
	KviStr tmp = str;
	KviPluginData * d = g_pPluginManager->findPlugin(tmp.ptr());
	if(!d){
		debug("Warning...could not find plugin %s",tmp.ptr());
		return;
	}
	m_pPluginModuleNameLabel->setText(d->description->module_name);
	m_pPluginServiceNameLabel->setText(d->description->service_name);
	m_pPluginAuthorLabel->setText(d->description->author);
	m_pPluginVersionLabel->setText(d->description->version);
	m_pPluginDescriptionLabel->setText(d->description->description);
	m_pUnloadPlugin->setEnabled(true);
	m_pConfigurePlugin->setEnabled(d->description->config_routine);
	m_pPluginAutoloadCheck->setEnabled(true);
	m_pPluginAutoloadCheck->setChecked(d->bAutoload);
	m_pHelpOnPlugin->setEnabled(d->description->help_routine);
#endif
}

void KviGeneralOptionsPluginsWidget::pluginAutoloadToggled(bool bActive)
{
#ifdef COMPILE_PLUGIN_SUPPORT
	KviStr tmp = m_pPluginBox->text(m_pPluginBox->currentItem());
	if(tmp.isEmpty())return;
	KviPluginData * d = g_pPluginManager->findPlugin(tmp.ptr());
	if(!d){
		debug("Warning...could not find plugin %s",tmp.ptr());	
		return;
	}
	d->bAutoload = bActive;
#endif
}

void KviGeneralOptionsPluginsWidget::pluginUnload()
{
#ifdef COMPILE_PLUGIN_SUPPORT
	KviStr tmp = m_pPluginBox->text(m_pPluginBox->currentItem());
	if(tmp.isEmpty())return;
	if(!g_pPluginManager->unloadPlugin(tmp.ptr())){
		debug("Warning...could not find plugin %s",tmp.ptr());	
		return;
	}
	fillPluginBox();
#endif
}

void KviGeneralOptionsPluginsWidget::pluginLoad()
{
#ifdef COMPILE_PLUGIN_SUPPORT
	KviStr tmp;
	g_pApp->getGlobalKVircDirectory(tmp,KviApp::Plugins);
	KviStr fName = QFileDialog::getOpenFileName(tmp.ptr(),"*.so");
	if(fName.hasData()){
		KviStr error;
		KviPluginData * d= g_pPluginManager->loadPlugin(fName.ptr(),true,&error);
		if(!d){
			g_pApp->warningBox(__tr("Could not load plugin %s\n%s"),fName.ptr(),error.ptr());
			return;
		}

		KviPluginCommandStruct plgcmd;

		plgcmd.app     = g_pApp;
		plgcmd.handle  = d->handle;
		plgcmd.params  = 0;
		plgcmd.frame   = g_pApp->m_pFrameList->first();
		plgcmd.error   = KVI_ERROR_NoError;
		plgcmd.console = plgcmd.frame->m_pConsole;
		plgcmd.window  = plgcmd.console;
		plgcmd.sock    = plgcmd.frame->m_pSocket;

		if(!g_pPluginManager->executeInitRoutine(d,&plgcmd)){
			g_pApp->warningBox(__tr("Plugin initialization failed\n%s\n%s"),fName.ptr(),
					plgcmd.errorstr.hasData() ? plgcmd.errorstr.ptr() : "Unspecified error\nMore info may be available in the shell output");
			g_pPluginManager->unloadPlugin(d->filename.ptr());
			return;
		}
		fillPluginBox(m_pPluginBox->count());
	}
#endif
}

void KviGeneralOptionsPluginsWidget::pluginConfigure()
{
#ifdef COMPILE_PLUGIN_SUPPORT
	KviStr tmp = m_pPluginBox->text(m_pPluginBox->currentItem());
	if(tmp.isEmpty())return;
	KviPluginData * d = g_pPluginManager->findPlugin(tmp.ptr());
	if(!d){
		debug("Warning...could not find plugin %s",tmp.ptr());	
		return;
	}
	if(d->description->config_routine){
		d->description->config_routine();
	}
#endif
}

void KviGeneralOptionsPluginsWidget::pluginHelp()
{
#ifdef COMPILE_PLUGIN_SUPPORT
	KviStr tmp = m_pPluginBox->text(m_pPluginBox->currentItem());
	if(tmp.isEmpty())return;
	KviPluginData * d = g_pPluginManager->findPlugin(tmp.ptr());
	if(!d){
		debug("Warning...could not find plugin %s",tmp.ptr());	
		return;
	}
	if(d->description->help_routine)d->description->help_routine();
#endif
}

/////////////

/*
	@document: doc_mimetypes.kvihelp
	@title: The mime types in KVIrc
		The mime types are the standard way of recognizing the "meaning" of the
		data contained in a file.<br>
		KVIrc contains a really simpified implementation of this "protocol".<br>
		The mimetypes are used by the <a href="play.kvihelp">PLAY</a> command,
		by the <a href="doc_ctcp_multimedia.kvihelp">CTCP MULTIMEDIA</a> handling
		protocol and by the directory browser.<br>
		Each mime type has 7 fields:<br>
		<b>Name</b><br>
		No special meaning : just a human readable name for the mimetype,
		such as "Shell script" , "Text file" or "Jpeg Image".<br>
		In fact this could be the real "RFC" mime name ...<br>
		<b>File mask</b><br>
		This is a "standard" file mask that may contain '*' wildcards:<br>
		*.cpp , *.rpm , *.mp3 , Makefile* , *.so* ...<br>
		<b>Magic bytes</b><br>
		This is a regular expression (grep-like) that describes the first bytes
		of the file.<br>
		KVIrc will read few bytes from the beginning of the file and check
		if these match the given "Magic bytes".<br>
		For example : ^\x7f\x45\x4c\x46 recognizes the first four bytes of
		the ELF executable file format:<br>
		^ matches start of input , \x7f describes the character 7f (hex),
		\x45 describes the character 'E' (45 hex), \x4c the character 'L'
		(4c hex) and \x46 the character 'F'.<br>
		^MThd describes the first four bytes of the standard MIDI (*.mid)
		file format (that correspond literally to the characters M,T,h and d).<br>
		If you leave this field empty the matching will be done only on the file mask basis.<br>
		<b>Run script</b><br>
		This is a kvirc script that is executed every time that "running the file of that type"
		is needed; for example when you click on a recognized file in the directory browser.<br>
		The identifier <a href="s_execfilename.kvihelp">$ExecFileName</a> will contain
		the complete path and filename of the file being executed.<br>
		The identifier <a href="s_isremoteexec.kvihelp">$IsRemoteExec</a> will contain
		1 if the execution was triggered by a remote user via <a href="doc_ctcp_multimedia.kvihelp">CTCP MULTIMEDIA</a>
		protocol , 0 otherwise. (See below)<br>
		For example, for the *.txt (text file) mimetype you can specify the following run script:<br>
		<example>
			<a href="run.kvihelp">run</a> xedit <a href="s_execfilename.kvihelp">$ExecFileName</a>
		</example>
		A more complex example; for the *.sh (shell script) mimetype use:<br>
		<example>
			<a href="if.kvihelp">if</a>(<a href="s_isremoteexec.kvihelp">$isRemoteExec</a>)<a href="run.kvihelp">run</a> xedit <a href="s_execfilename.kvihelp">$ExecFileName</a>; <a href="if.kvihelp">else</a> <a href="run.kvihelp"> /bin/bash <a href="s_execfilename.kvihelp">$ExecFileName</a>
		</example>
		This executes the shell script only if the exec is requested from the local user,
		otherwise the script is opened with a text editor (that is relatively safe).<br>
		In this dialog the script myst fit in a single line of text.<br>
		If you want to write more complex routines you can make use of aliases.<br>
		Note:<br>
		You can use variables to change your "player" applications at runtime.<br>
		<example>
			<a href="run.kvihelp">run</a> %TextEditor <a href="s_execfilename.kvihelp">$ExecFileName</a>
		</example>
		<b>Save path</b><br>
		This path is used to save the matching files when being autoaccepted (DCC).<br>
		It is also the first directory that KVIrc looks in when searching for
		a file of this kind.<br>
		If you leave this field empty, the default save path will be used.<br>
		<b>Remote exec safe</b>
		This flag indicates if the files of that type may be executed
		by remote user via the <a href="doc_ctcp_multimedia.kvihelp">CTCP MULTIMEDIA</a> protocol.<br>
		<b>Icon path</b>
		This is a filename of an image that the directory browser will use as icon for this file type.<br>
		If the filename does not contain a complete path , KVIrc will look for the image
		in a standard set of directories (Global and Local pics directory , $HOME dir etc...).<br>
		<br><br>
		KVIrc orders the mimetypes internally in a way that the mimetypes with
		less * wildcards (in file masks) are "tried" first.<br>
		The mime that has less wildcards , comes first (README);<br>
		then longer fileMasks (*.tar.gz);<br>
		then shorter ones  (*.gz) (*);<br>
		the mimes with a magic go before similar mimes without.<br>
		So for example, you can have two different mime types for
		README.txt and *.txt.<br>
		README.txt will be tried first and recognized as "Readme file"
		otherwise the *.txt (Text file) mime will match.<br>
*/

/*
	@quickhelp: KviGeneralOptionsMimeTypesWidget
	@widget: Mime types table
		Here you can edit the types and attributes of files recognized by KVIrc.<br>
		The meaning of each field of the table is described in detail in the <a href="doc_mimetypes.kvihelp">Mime types documentation</a>.<br>
*/


KviGeneralOptionsMimeTypesWidget::KviGeneralOptionsMimeTypesWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES)
{
	QGridLayout *g = new QGridLayout(this,2,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);

	m_pMimeView = new KviListView(this);
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("Name")));
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("File Mask")));
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("Magic Bytes")));
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("\"Run\" Script")));
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("Save Path")));
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("Remote Exec")));
	m_pMimeView->addColumn(_CHAR_2_QSTRING(__tr("Icon Path")));
	m_pMimeView->setSorting(-1);
	g->addMultiCellWidget(m_pMimeView,0,0,0,1);

	QPushButton *pb = new QPushButton(_CHAR_2_QSTRING(__tr("&Add MIME Type")),this);
	connect(pb,SIGNAL(clicked()),this,SLOT(addNewMime()));
	g->addWidget(pb,1,0);

	pb = new QPushButton(_CHAR_2_QSTRING(__tr("&Remove MIME Type")),this);
	connect(pb,SIGNAL(clicked()),this,SLOT(deleteSelectedMimes()));
	g->addWidget(pb,1,1);

	QListViewItem * it;

	for(KviMimeType * m=g_pOptions->m_pMimeManager->m_pMimeList->first();m;m=g_pOptions->m_pMimeManager->m_pMimeList->next()){
		it = new QListViewItem(m_pMimeView,
				_CHAR_2_QSTRING(m->mimeName.ptr()),_CHAR_2_QSTRING(m->fileMask.ptr()),
				_CHAR_2_QSTRING(m->magicBytes.ptr()),_CHAR_2_QSTRING(m->commandline.ptr()),
				_CHAR_2_QSTRING(m->savePath.ptr()),m->remoteExecSafe ? _CHAR_2_QSTRING("true") : _CHAR_2_QSTRING("false"),
				_CHAR_2_QSTRING(m->iconPath.ptr()));
	}

	g->setRowStretch(0,1);

}

KviGeneralOptionsMimeTypesWidget::~KviGeneralOptionsMimeTypesWidget()
{
}

void KviGeneralOptionsMimeTypesWidget::addNewMime()
{
	(void) new QListViewItem(m_pMimeView,
			_CHAR_2_QSTRING(__tr("__Unnamed_")),_CHAR_2_QSTRING("*"),
			_CHAR_2_QSTRING(""),_CHAR_2_QSTRING(""),
			_CHAR_2_QSTRING(""),_CHAR_2_QSTRING("false"),_CHAR_2_QSTRING(""));
}

void KviGeneralOptionsMimeTypesWidget::deleteSelectedMimes()
{
	QListViewItem * it = m_pMimeView->firstChild();
	while(it){
		QListViewItem * tmp = it;
		it = it->nextSibling();
		if(tmp->isSelected())delete tmp;
	}
}

void KviGeneralOptionsMimeTypesWidget::commitChanges()
{
	while(g_pOptions->m_pMimeManager->m_pMimeList->first())g_pOptions->m_pMimeManager->m_pMimeList->removeFirst();
	QListViewItem * it = m_pMimeView->firstChild();
	while(it){
		KviMimeType * m = new KviMimeType;
		m->mimeName = it->text(0);
		m->mimeName.stripWhiteSpace();
		m->fileMask = it->text(1);
		m->fileMask.stripWhiteSpace();
		m->magicBytes = it->text(2);
		m->magicBytes.stripWhiteSpace();
		m->commandline = it->text(3);
		m->commandline.stripWhiteSpace();
		m->savePath = it->text(4);
		m->savePath.stripWhiteSpace();
		KviStr tmp = it->text(5);
		m->remoteExecSafe = (kvi_strEqualCI("true",tmp.ptr()) || kvi_strEqualCI("1",tmp.ptr()));
		tmp = it->text(6);
		tmp.stripWhiteSpace();
		if(tmp.hasData()){
			if(!g_pApp->findImage(m->iconPath,tmp.ptr()))
			{
				debug("Could not load icon file %s",tmp.ptr());
				m->iconPath = "";				
			}
		}
		if(m->mimeName.hasData() && m->fileMask.hasData())g_pOptions->m_pMimeManager->inSort(m);
		else delete m; //incomplete...unuseful...
		it = it->nextSibling();
	}
	g_pApp->refreshMimeTypeIcons();
	g_pApp->updateAllDirectoryBrowsers();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsGuiMdiWidget
	@widget: Mdi manager GUI options
*/


KviGeneralOptionsGuiMdiWidget::KviGeneralOptionsGuiMdiWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI)
{

	QGridLayout *g = new QGridLayout(this,12,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Active titlebar background color:"),&(g_pOptions->m_clrMdiCaptionActiveBack));
	g->addWidget(s,0,0);
	s = new KviNewColorSelector(this,__tr("Active titlebar foreground color:"),&(g_pOptions->m_clrMdiCaptionActiveFore));
	g->addWidget(s,1,0);
	s = new KviNewColorSelector(this,__tr("Inactive titlebar background color:"),&(g_pOptions->m_clrMdiCaptionInactiveBack));
	g->addWidget(s,2,0);
	s = new KviNewColorSelector(this,__tr("Inactive titlebar foreground color:"),&(g_pOptions->m_clrMdiCaptionInactiveFore));
	g->addWidget(s,3,0);

	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Titlebar font:"),&(g_pOptions->m_fntMdiCaption));
	g->addWidget(f,4,0);

	QFrame * fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr,5,0);

	s = new KviNewColorSelector(this,__tr("Main window background color:"),&(g_pOptions->m_clrMdiBack));
	g->addWidget(s,6,0);

	m_pMdiImageSelector = new KviNewImageSelector(this,__tr("Use main window background image:"),&(g_pOptions->m_szMdiBack),g_pOptions->m_pixMdiBack);
	g->addWidget(m_pMdiImageSelector,7,0);	

	fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr,8,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Windows are opaque while moving"),&(g_pOptions->m_bMdiOpaqueMove));
	g->addWidget(b,9,0);
	b = new KviNewBoolSelector(this,__tr("Windows are opaque while resizing"),&(g_pOptions->m_bMdiOpaqueResize));
	g->addWidget(b,10,0);

	fr = new QFrame(this);
	g->addWidget(fr,11,0);
	g->setRowStretch(11,1);
}

KviGeneralOptionsGuiMdiWidget::~KviGeneralOptionsGuiMdiWidget()
{
}


void KviGeneralOptionsGuiMdiWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	g_pOptions->loadMdiBackgroundImage(m_pMdiImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}


/////////////

/*
	@quickhelp: KviGeneralOptionsGuiInputWidget
	@widget: Input GUI options
*/


KviGeneralOptionsGuiInputWidget::KviGeneralOptionsGuiInputWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT)
{

	QGridLayout *g = new QGridLayout(this,9,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Background color:"),&(g_pOptions->m_clrInputBack));
	g->addWidget(s,0,0);
	s = new KviNewColorSelector(this,__tr("Foreground color:"),&(g_pOptions->m_clrInputFore));
	g->addWidget(s,1,0);
	s = new KviNewColorSelector(this,__tr("Selection background color:"),&(g_pOptions->m_clrInputSeleBack));
	g->addWidget(s,2,0);
	s = new KviNewColorSelector(this,__tr("Selection foreground color:"),&(g_pOptions->m_clrInputSeleFore));
	g->addWidget(s,3,0);
	s = new KviNewColorSelector(this,__tr("Cursor and control marks color:"),&(g_pOptions->m_clrInputCursor));
	g->addWidget(s,4,0);
	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Font:"),&(g_pOptions->m_fntInput));
	g->addWidget(f,5,0);

	QFrame * fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr,6,0);

	m_pInputImageSelector = new KviNewImageSelector(this,__tr("Use background image:"),&(g_pOptions->m_szInputBack),g_pOptions->m_pixInputBack);
	g->addWidget(m_pInputImageSelector,7,0);	

	fr = new QFrame(this);
	g->addWidget(fr,8,0);
	g->setRowStretch(8,1);
}

KviGeneralOptionsGuiInputWidget::~KviGeneralOptionsGuiInputWidget()
{
}


void KviGeneralOptionsGuiInputWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	g_pOptions->loadInputBackgroundImage(m_pInputImageSelector->getImage());
	g_pOptions->calculateInputFontVariables();
	g_pApp->triggerGlobalRepaint();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsGuiLabelsWidget
	@widget: Channel labels GUI options
*/


KviGeneralOptionsGuiLabelsWidget::KviGeneralOptionsGuiLabelsWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS)
{

	QGridLayout *g = new QGridLayout(this,6,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Background color:"),&(g_pOptions->m_clrLabelsBack));
	g->addWidget(s,0,0);
	s = new KviNewColorSelector(this,__tr("Active foreground color:"),&(g_pOptions->m_clrLabelsActiveFore));
	g->addWidget(s,1,0);
	s = new KviNewColorSelector(this,__tr("Inactive foreground color:"),&(g_pOptions->m_clrLabelsInactiveFore));
	g->addWidget(s,2,0);
	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Font:"),&(g_pOptions->m_fntLabels));
	g->addWidget(f,3,0);

	QFrame * fr = new QFrame(this);
	fr->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(fr,4,0);

	m_pLabelsImageSelector = new KviNewImageSelector(this,__tr("Use background image:"),&(g_pOptions->m_szLabelsBack),g_pOptions->m_pixLabelsBack);
	g->addWidget(m_pLabelsImageSelector,5,0);

	fr = new QFrame(this);
	g->addWidget(fr,6,0);
	g->setRowStretch(6,1);

}

KviGeneralOptionsGuiLabelsWidget::~KviGeneralOptionsGuiLabelsWidget()
{
}


void KviGeneralOptionsGuiLabelsWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	g_pOptions->loadLabelsBackgroundImage(m_pLabelsImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsGuiListBoxWidget
	@widget: Channel userlist GUI options
*/


KviGeneralOptionsGuiListBoxWidget::KviGeneralOptionsGuiListBoxWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX)
{

	QGridLayout *g = new QGridLayout(this,12,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Background color:"),&(g_pOptions->m_clrListBoxBack));
	g->addWidget(s,0,0);
	s = new KviNewColorSelector(this,__tr("Owner foreground color:"),&(g_pOptions->m_clrListBoxOwner));
	g->addWidget(s,1,0);
	s = new KviNewColorSelector(this,__tr("Op foreground color:"),&(g_pOptions->m_clrListBoxOp));
	g->addWidget(s,2,0);
	s = new KviNewColorSelector(this,__tr("Halfop foreground color:"),&(g_pOptions->m_clrListBoxHalfOp));
	g->addWidget(s,3,0);
	s = new KviNewColorSelector(this,__tr("Voice foreground color:"),&(g_pOptions->m_clrListBoxVoice));
	g->addWidget(s,4,0);
	s = new KviNewColorSelector(this,__tr("Userop foreground color:"),&(g_pOptions->m_clrListBoxUserOp));
	g->addWidget(s,5,0);
	s = new KviNewColorSelector(this,__tr("Normal foreground color:"),&(g_pOptions->m_clrListBoxNormal));
	g->addWidget(s,6,0);
	s = new KviNewColorSelector(this,__tr("Selection background color:"),&(g_pOptions->m_clrListBoxSeleBack));
	g->addWidget(s,7,0);
	s = new KviNewColorSelector(this,__tr("Selection foreground color:"),&(g_pOptions->m_clrListBoxSeleFore));
	g->addWidget(s,8,0);
	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Font:"),&(g_pOptions->m_fntListBox));
	g->addWidget(f,9,0);
	//Sep
	QFrame * fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr,10,0);

	m_pListBoxImageSelector = new KviNewImageSelector(this,__tr("Use background image:"),&(g_pOptions->m_szListBoxBack),g_pOptions->m_pixListBoxBack);
	g->addWidget(m_pListBoxImageSelector,11,0);
	//Sep
	fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr,12,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Show owner, op, halfop, voice, and userop icons"),&(g_pOptions->m_bListBoxShowImages));
	g->addWidget(b,13,0);

	fr = new QFrame(this);
	g->addWidget(fr,14,0);
	g->setRowStretch(14,1);
}

KviGeneralOptionsGuiListBoxWidget::~KviGeneralOptionsGuiListBoxWidget()
{
}


void KviGeneralOptionsGuiListBoxWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	KviNewBoolSelector::commitAll(this);
	g_pOptions->calculateListBoxFontVariables();
	g_pOptions->loadListBoxBackgroundImage(m_pListBoxImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsGuiOutputWidget
	@widget: Output widget GUI options
*/


KviGeneralOptionsGuiOutputWidget::KviGeneralOptionsGuiOutputWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT)
{

	QGridLayout *g = new QGridLayout(this,9,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * c = new KviNewColorSelector(this,__tr("Background color:"),&(g_pOptions->m_clrViewBack));
	g->addWidget(c,0,0);
	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Font:"),&(g_pOptions->m_fntView));
	g->addWidget(f,1,0);

	QFrame * fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr,2,0);

	m_pOutputImageSelector = new KviNewImageSelector(this,__tr("Use background image:"),&(g_pOptions->m_szViewBack),g_pOptions->m_pixViewBack);
	g->addWidget(m_pOutputImageSelector,3,0);

	fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr,4,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Show message images"),&(g_pOptions->m_bShowImages));
	g->addWidget(b,5,0);
	b = new KviNewBoolSelector(this,__tr("Timestamp output lines"),&(g_pOptions->m_bTimestamp));
	g->addWidget(b,6,0);
	b = new KviNewBoolSelector(this,__tr("Add margin after first word wrap"),&(g_pOptions->m_bWrapMargin));
	g->addWidget(b,7,0);

	fr = new QFrame(this);
	g->addWidget(fr,8,0);
	g->setRowStretch(8,1);
}

KviGeneralOptionsGuiOutputWidget::~KviGeneralOptionsGuiOutputWidget()
{
}


void KviGeneralOptionsGuiOutputWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	KviNewBoolSelector::commitAll(this);
	g_pOptions->loadOutputBackgroundImage(m_pOutputImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsGuiMessagesWidget
	@widget: Message color options
*/

KviMessageColorView::KviMessageColorView(QWidget * par)
: QTableView(par,"message_color_view")
{
	setNumRows(KVI_OUT_NUM_IMAGES + 2);
	setNumCols(1);

	for(int i=0;i<16;i++){
		m_pColorPixmap[i] = new QPixmap(32,16);
		m_pColorPixmap[i]->fill(*(g_pOptions->m_pMircColor[i]));
	}
	
	m_selectedRow = -1;

	m_pFm = new QFontMetrics(g_pOptions->m_fntView);

	m_pForePopup = new QPopupMenu();
	for(int i=0;i<16;i++)m_pForePopup->insertItem(*(m_pColorPixmap[i]),i);
	connect(m_pForePopup,SIGNAL(activated(int)),this,SLOT(forePopupActivated(int)));
	m_pBackPopup = new QPopupMenu();
	for(int i=0;i<16;i++)m_pBackPopup->insertItem(*(m_pColorPixmap[i]),i);
	connect(m_pBackPopup,SIGNAL(activated(int)),this,SLOT(backPopupActivated(int)));
	m_pBackPopup->insertItem(__tr("Transparent"),16);
	m_pPopup = new QPopupMenu();
	m_pPopup->insertItem(__tr("Foreground"),m_pForePopup,1000);
	m_pPopup->insertItem(__tr("Background"),m_pBackPopup,1001);

	for(int i=0;i<KVI_OUT_NUM_IMAGES;i++)
	{
		m_clrBack[i] = g_pOptions->m_cViewOutTypeBack[i];
		m_clrFore[i] = g_pOptions->m_cViewOutTypeFore[i];
	}

	m_clrBack[KVI_OUT_NUM_IMAGES] = g_pOptions->m_cViewOutSeleBack;
	m_clrFore[KVI_OUT_NUM_IMAGES] = g_pOptions->m_cViewOutSeleFore;
	m_clrBack[KVI_OUT_NUM_IMAGES + 1] = KVI_TRANSPARENT;
	m_clrFore[KVI_OUT_NUM_IMAGES + 1] = g_pOptions->m_cViewOutUrlFore;

	int hght = m_pFm->lineSpacing() + 4;
	setCellHeight(hght > 18 ? hght : 18);
	setCellWidth(200);
	setFrameStyle(QFrame::Sunken | QFrame::Panel);
	setMinimumHeight(150);
	setTableFlags(tableFlags() | Tbl_vScrollBar);
}


KviMessageColorView::~KviMessageColorView()
{
	delete m_pPopup;
	delete m_pForePopup;
	delete m_pBackPopup;
	for(int i=0;i<16;i++)delete m_pColorPixmap[i];
	delete m_pFm;
}

void KviMessageColorView::commit()
{
	for(int i=0;i<KVI_OUT_NUM_IMAGES;i++)
	{
		 g_pOptions->m_cViewOutTypeBack[i] = m_clrBack[i];
		 g_pOptions->m_cViewOutTypeFore[i] = m_clrFore[i];
	}

	g_pOptions->m_cViewOutSeleBack = (m_clrBack[KVI_OUT_NUM_IMAGES] != KVI_TRANSPARENT) ? m_clrBack[KVI_OUT_NUM_IMAGES] : KVI_BLACK;
	g_pOptions->m_cViewOutSeleFore = m_clrFore[KVI_OUT_NUM_IMAGES];
	g_pOptions->m_cViewOutUrlFore = m_clrFore[KVI_OUT_NUM_IMAGES + 1];
}

void KviMessageColorView::forePopupActivated(int id)
{
	if((m_selectedRow > -1) && (m_selectedRow < (KVI_OUT_NUM_IMAGES + 2)) && (id >= 0) && (id < 16))
	{
		m_clrFore[m_selectedRow] = id;
		int y;
		if(rowYPos(m_selectedRow,&y))
		{
			repaint(0,y,width(),y + cellHeight(),false);
		}
	}
}

void KviMessageColorView::backPopupActivated(int id)
{
	if((m_selectedRow > -1) && (m_selectedRow < (KVI_OUT_NUM_IMAGES + 2)) && (id >= 0) && (id <= 16))
	{
		if(id < 16)m_clrBack[m_selectedRow] = id;
		else m_clrBack[m_selectedRow] = KVI_TRANSPARENT;
		int y;
		if(rowYPos(m_selectedRow,&y))
		{
			repaint(0,y,width(),y + cellHeight(),false);
		}
	}
}

void KviMessageColorView::mousePressEvent(QMouseEvent *e)
{
	if((m_selectedRow > -1) && (m_selectedRow < (KVI_OUT_NUM_IMAGES + 2)))
	{
		int theRow = m_selectedRow;
		int y;
		m_selectedRow = -1;
		if(rowYPos(theRow,&y))
		{
			repaint(0,y,width(),y + cellHeight(),false);
		}
	}
	m_selectedRow = findRow(e->pos().y());
	if((m_selectedRow > -1) && (m_selectedRow < (KVI_OUT_NUM_IMAGES + 2)))
	{
		m_pPopup->setItemEnabled(1001,m_selectedRow < (KVI_OUT_NUM_IMAGES + 1));
		m_pBackPopup->setItemEnabled(16,m_selectedRow < KVI_OUT_NUM_IMAGES);
		m_pPopup->popup(mapToGlobal(e->pos()));

		repaint(0,e->pos().y() - cellHeight(),width(),e->pos().y() + cellHeight(),false);
	}
}

void KviMessageColorView::paintCell( QPainter *p, int row, int col )
{
	if(g_pOptions->m_pixViewBack->isNull())
	{
		p->fillRect(0,0,cellWidth(),cellHeight(),g_pOptions->m_clrViewBack);
	} else {
		int yPos;
		if(rowYPos(row,&yPos))
		{
			p->drawTiledPixmap(0,0,cellWidth(),cellHeight(),*(g_pOptions->m_pixViewBack),0,(yPos + yOffset()) % g_pOptions->m_pixViewBack->height());
		}
	}

	if(row < KVI_OUT_NUM_IMAGES)p->drawPixmap(1,1,*(g_pixViewOut[row]));

	if(row == m_selectedRow)
	{
		p->setPen(Qt::red);
		p->drawRect(0,0,cellWidth(),cellHeight());
	}

	if(m_clrBack[row] < 16)
	{
		p->fillRect(24,1,cellWidth(),cellHeight() - 2,*(g_pOptions->m_pMircColor[m_clrBack[row]]));
	}
	p->setPen(*(g_pOptions->m_pMircColor[m_clrFore[row]]));
	p->setFont(g_pOptions->m_fntView);

	p->drawText(26,cellHeight() - m_pFm->descent(),messageTypeString[row]);
}

void KviMessageColorView::resizeEvent(QResizeEvent *e)
{
	setCellWidth(width());
	QTableView::resizeEvent(e);
}

void KviMessageColorView::load()
{
	KviStr basePath;
	g_pApp->getLocalKVircDirectory(basePath);
	KviStr fName = kvi_askForOpenFileName(basePath.ptr(),"*.kviclr");
	if(fName.hasData())
	{
		KviConfig cfg(fName.ptr());
		cfg.setGroup("MessageColors");

		for(int j=0;j<(KVI_OUT_NUM_IMAGES + 2);j++){
			KviStr szEntry(KviStr::Format,"TypeBackground%d",j);
			m_clrBack[j] = cfg.readUCharEntry(szEntry.ptr(),KVI_TRANSPARENT);
			szEntry.sprintf("TypeForeground%d",j);
			m_clrFore[j] = cfg.readUCharEntry(szEntry.ptr(),KVI_BLACK);
			if(m_clrFore[j] > 15)m_clrFore[j] = KVI_BLACK;
		}
	}
	repaint();
}

void KviMessageColorView::save()
{
	KviStr basePath;
	g_pApp->getLocalKVircDirectory(basePath,KviApp::MsgColors);
	KviStr fName = kvi_askForSaveFileName(basePath.ptr());
	if(fName.hasData())
	{
		KviConfig cfg(fName.ptr());
		cfg.setGroup("MessageColors");

		for(int j=0;j<(KVI_OUT_NUM_IMAGES + 2);j++){
			KviStr szEntry(KviStr::Format,"TypeBackground%d",j);
			cfg.writeEntry(szEntry.ptr(),m_clrBack[j]);
			szEntry.sprintf("TypeForeground%d",j);
			cfg.writeEntry(szEntry.ptr(),m_clrFore[j]);
		}
	}
}

KviGeneralOptionsGuiMessagesWidget::KviGeneralOptionsGuiMessagesWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES)
{
	QGridLayout *g = new QGridLayout(this,2,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	m_pMessageColorView = new KviMessageColorView(this);
	g->addMultiCellWidget(m_pMessageColorView,0,0,0,1);

	QPushButton * pb = new QPushButton(__tr("&Load Colors..."),this);
	connect(pb,SIGNAL(clicked()),m_pMessageColorView,SLOT(load()));
	g->addWidget(pb,1,0);
	pb = new QPushButton(__tr("&Save Colors"),this);
	connect(pb,SIGNAL(clicked()),m_pMessageColorView,SLOT(save()));
	g->addWidget(pb,1,1);

	g->setRowStretch(0,1);

//	QFrame *fr = new QFrame(this);
//	g->addWidget(fr,1,0);

}

KviGeneralOptionsGuiMessagesWidget::~KviGeneralOptionsGuiMessagesWidget()
{
}


void KviGeneralOptionsGuiMessagesWidget::commitChanges()
{
	m_pMessageColorView->commit();
//	commitColorSelectors();
//	commitFontSelectors();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsGuiHelpWidget
	@widget: Help browser GUI options
*/


KviGeneralOptionsGuiHelpWidget::KviGeneralOptionsGuiHelpWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP)
{
	QGridLayout *g = new QGridLayout(this,9,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Background color:"),&(g_pOptions->m_clrHelpBack));
	g->addWidget(s,0,0);
	s = new KviNewColorSelector(this,__tr("Foreground color:"),&(g_pOptions->m_clrHelpFore));
	g->addWidget(s,1,0);
	s = new KviNewColorSelector(this,__tr("Title foreground color:"),&(g_pOptions->m_clrHelpTitle));
	g->addWidget(s,2,0);
	s = new KviNewColorSelector(this,__tr("Subtitle foreground color:"),&(g_pOptions->m_clrHelpSubtitle));
	g->addWidget(s,3,0);
	s = new KviNewColorSelector(this,__tr("Example foreground color:"),&(g_pOptions->m_clrHelpExample));
	g->addWidget(s,4,0);
	KviNewFontSelector *f = new KviNewFontSelector(this,__tr("Normal font:"),&(g_pOptions->m_fntHelpNormal));
	g->addWidget(f,6,0);
	f = new KviNewFontSelector(this,__tr("Fixed font:"),&(g_pOptions->m_fntHelpFixed));
	g->addWidget(f,7,0);

	QFrame *fr = new QFrame(this);
	g->addWidget(fr,8,0);
	g->setRowStretch(8,1);

}

KviGeneralOptionsGuiHelpWidget::~KviGeneralOptionsGuiHelpWidget()
{
}


void KviGeneralOptionsGuiHelpWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	KviHelpQMLStyleSheet * s = new KviHelpQMLStyleSheet(g_pApp);
	QStyleSheet::setDefaultSheet(s);
	/* FIXME : Should trigger updating the help windows open ? */
}


/////////////

/*
	@quickhelp: KviGeneralOptionsGuiSysTrayWidget
	@widget: Sys tray GUI options
*/


KviGeneralOptionsGuiSysTrayWidget::KviGeneralOptionsGuiSysTrayWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY)
{
	QGridLayout *g = new QGridLayout(this,4,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("System display background:"),&(g_pOptions->m_clrSysTrayBack));
	g->addWidget(s,0,0);
	s = new KviNewColorSelector(this,__tr("System display foreground:"),&(g_pOptions->m_clrSysTrayFore));
	g->addWidget(s,1,0);
	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("System display font (face only):"),&(g_pOptions->m_fntSysTray));
	g->addWidget(f,2,0);

	QFrame *fr = new QFrame(this);
	g->addWidget(fr,3,0);
	g->setRowStretch(3,1);

}

KviGeneralOptionsGuiSysTrayWidget::~KviGeneralOptionsGuiSysTrayWidget()
{
}


void KviGeneralOptionsGuiSysTrayWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	g_pApp->triggerGlobalRepaint();
}

/////////////

/*
	@quickhelp: KviGeneralOptionsCharsetTranslationWidget
	@widget: Charset translation options
		This options page is available only if the charset
		translation support has been enabled at compilation time.<br>
		Charset translations are useful for non english users that
		have more than one charset in their language.<br>
		Russian is a good example of this case: Linux users
		generally have the KOI charset , Windows users have
		the Windows native russian charset.<br>
		If you're going to speak on a channel where all other
		users are using the Windows charset , it may be a good idea
		to remap your KOI charset to the Windows one when writing
		to that channel and do the inverse mapping for the data that
		arrives from the server.<br>
		A translation map describes this operation.<br>
		KVIrc translation maps are compatible with the ones
		used by IRCII.<br><br>
		<b>translation map file format</b><br><br>
		The translation map is a text file with a sequence of 512 numbers.<br>
		Each number is specified as "0xYY" where YY are two hexadecimal digits.<br>
		Numbers are separated by commas and arranged in lines of 8 entries.<br>
		So the whole translation map has 64 lines of 8 hexadecimal numbers.<br>
		The first 256 numbers are used as <b>Server To Client map</b>
		and the remaining part as the <b>Client To Server map</b>.<br>
		Example:<br><br>
		The first four lines of a hypotetical translation map:<br>
		<i>
			0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,<br>
			0x21,0x12,0xa0,0xee,0x0c,0x0d,0x0e,0x0f,<br>
			0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,<br>
			0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,<br>
			...<br>
		</i>
		These lines will be used as the first 32 entries
		in the Server-To-Client map.<br>
		So for example if the character 9 (decimal , not ASCII!!!)
		arrives from server , it will be mapped to 0x12 (that is 18 decimal).<br>
		<br><br>Notes:<br><br>
		It is absolutely easy to mess up everything when writing
		a translation map.<br>
		There are special characters that CAN'T be remapped,
		so be sure to know what are you doing!.<br>
		Usually the remapped characters are over 127 (decimal),
		and the standard ASCII set is left unchanged.<br>
*/


KviGeneralOptionsCharsetTranslationWidget::KviGeneralOptionsCharsetTranslationWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION)
{
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	QGridLayout *g = new QGridLayout(this,3,2,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Use the following translation map:"),&(g_pOptions->m_bUseCharsetTranslation));
	g->addMultiCellWidget(b,0,0,0,1);


	m_pMapFileEdit = new QLineEdit(this);
	g->addWidget(m_pMapFileEdit,1,0);
	m_pMapFileEdit->setEnabled(g_pOptions->m_bUseCharsetTranslation);
	connect(b,SIGNAL(toggled(bool)),m_pMapFileEdit,SLOT(setEnabled(bool)));
	m_pMapFileEdit->setText(g_pOptions->m_szCharsetTranslationMapFile.ptr());

	m_pBrowseBtn = new QPushButton(__tr("&Browse..."),this);
	g->addWidget(m_pBrowseBtn,1,1);
	m_pBrowseBtn->setEnabled(g_pOptions->m_bUseCharsetTranslation);
	connect(b,SIGNAL(toggled(bool)),m_pBrowseBtn,SLOT(setEnabled(bool)));
	connect(m_pBrowseBtn,SIGNAL(clicked()),this,SLOT(chooseTranslationMap()));

	QFrame *fr = new QFrame(this);
	g->addMultiCellWidget(fr,2,2,0,1);
	g->setRowStretch(2,1);
#endif
}

KviGeneralOptionsCharsetTranslationWidget::~KviGeneralOptionsCharsetTranslationWidget()
{
}

void KviGeneralOptionsCharsetTranslationWidget::chooseTranslationMap()
{
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	KviStr szPath;
	g_pApp->getGlobalKVircDirectory(szPath,KviApp::Charmaps);
	KviStr tmp = kvi_askForOpenFileName(szPath.ptr());
	if(tmp.hasData())
	{
		if(g_pCharsetTranslator->setTranslationMap(tmp.ptr(),true))
		{
			m_pMapFileEdit->setText(tmp.ptr());
		} else {
			g_pApp->warningBox(__tr("Invalid or corrupted charset translation map."));			
		}
	}
#endif
}

#ifdef COMPILE_NEED_CHARSET_TRANSLATION
void KviGeneralOptionsCharsetTranslationWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	if(g_pOptions->m_bUseCharsetTranslation)
	{
		KviStr tmp = m_pMapFileEdit->text();
		if(g_pCharsetTranslator->setTranslationMap(tmp.ptr(),true))
		{
			g_pOptions->m_szCharsetTranslationMapFile = tmp;
			g_pCharsetTranslator->setTranslationMap(tmp.ptr());
		} else {
			// failed to read it
			g_pOptions->m_bUseCharsetTranslation = false;
			g_pOptions->m_szCharsetTranslationMapFile = "";
			g_pApp->warningBox(__tr("Invalid or corrupted charset translation map."));
		}
	}
}
#endif


/////////////

/*
	@quickhelp: KviGeneralOptionsGuiGlobalWidget
	@widget: Global GUI options
*/


KviGeneralOptionsGuiGlobalWidget::KviGeneralOptionsGuiGlobalWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL)
{
#ifdef COMPILE_USE_AA_FONTS
	QGridLayout *g = new QGridLayout(this,14,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Global application font:"),&(g_pOptions->m_fntApplication));
	g->addMultiCellWidget(f,0,0,0,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Enable anti-aliasing for fonts (Requires restart)"),&(g_pOptions->m_bUseFontAntiAliasing));
	g->addMultiCellWidget(b,1,1,0,1);

	QFrame * r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r,2,2,0,1);

	b = new KviNewBoolSelector(this,__tr("Use private global color palette"),&(g_pOptions->m_bSetGlobalPaletteAtStartup));
	g->addMultiCellWidget(b,3,3,0,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Foreground:"),&(g_pOptions->m_clrNormalGlobalForeground));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,4,0);
	s = new KviNewColorSelector(this,__tr("Background:"),&(g_pOptions->m_clrNormalGlobalButton));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,5,0);
	s = new KviNewColorSelector(this,__tr("Light shadow:"),&(g_pOptions->m_clrNormalGlobalLight));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,6,0);
	s = new KviNewColorSelector(this,__tr("Middle shadow:"),&(g_pOptions->m_clrNormalGlobalMid));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,7,0);
	s = new KviNewColorSelector(this,__tr("Dark shadow:"),&(g_pOptions->m_clrNormalGlobalDark));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,8,0);
	s = new KviNewColorSelector(this,__tr("Text:"),&(g_pOptions->m_clrNormalGlobalText));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,4,1);
	s = new KviNewColorSelector(this,__tr("Base:"),&(g_pOptions->m_clrNormalGlobalBase));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,5,1);
	s = new KviNewColorSelector(this,__tr("Disabled foreground:"),&(g_pOptions->m_clrDisabledGlobalForeground));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,6,1);
	s = new KviNewColorSelector(this,__tr("Disabled text:"),&(g_pOptions->m_clrDisabledGlobalText));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,7,1);
	s = new KviNewColorSelector(this,__tr("Disabled base:"),&(g_pOptions->m_clrDisabledGlobalBase));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,8,1);

	QLabel * l=new QLabel(_CHAR_2_QSTRING(__tr("Application GUI style:")),this);
//	l->setMinimumSize(l->sizeHint());
	g->addWidget(l,9,0);

	m_pGUIStyleBox = new QComboBox(false,this);
	g->addWidget(m_pGUIStyleBox,9,1);

	r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r,10,10,0,1);

	b = new KviNewBoolSelector(this,__tr("Use large main toolbar images"),&(g_pOptions->m_bUseBigToolbarPixmaps));
	g->addWidget(b,11,0);
	b = new KviNewBoolSelector(this,__tr("Use large user toolbar images"),&(g_pOptions->m_bUseBigUToolbarPixmaps));
	g->addWidget(b,12,0);
	b = new KviNewBoolSelector(this,__tr("Show text under toolbar icons"),&(g_pOptions->m_bUseTextToolbarComment));
	g->addWidget(b,11,1);
	b = new KviNewBoolSelector(this,__tr("Use KDE theme background for menubar"),&(g_pOptions->m_bUseThemeMenubarBackground));
	g->addWidget(b,12,1);

	r = new QFrame(this);
	g->addMultiCellWidget(r,13,13,0,1);
	g->setRowStretch(13,1);

#else
	QGridLayout *g = new QGridLayout(this,13,1,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);

	KviNewFontSelector * f = new KviNewFontSelector(this,__tr("Global application font:"),&(g_pOptions->m_fntApplication));
	g->addMultiCellWidget(f,0,0,0,1);

	QFrame * r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r,1,1,0,1);

	KviNewBoolSelector * b = new KviNewBoolSelector(this,__tr("Use private global color palette"),&(g_pOptions->m_bSetGlobalPaletteAtStartup));
	g->addMultiCellWidget(b,2,2,0,1);

	KviNewColorSelector * s = new KviNewColorSelector(this,__tr("Foreground:"),&(g_pOptions->m_clrNormalGlobalForeground));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,3,0);
	s = new KviNewColorSelector(this,__tr("Background:"),&(g_pOptions->m_clrNormalGlobalButton));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,4,0);
	s = new KviNewColorSelector(this,__tr("Light shadow:"),&(g_pOptions->m_clrNormalGlobalLight));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,5,0);
	s = new KviNewColorSelector(this,__tr("Middle shadow:"),&(g_pOptions->m_clrNormalGlobalMid));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,6,0);
	s = new KviNewColorSelector(this,__tr("Dark shadow:"),&(g_pOptions->m_clrNormalGlobalDark));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,7,0);
	s = new KviNewColorSelector(this,__tr("Text:"),&(g_pOptions->m_clrNormalGlobalText));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,3,1);
	s = new KviNewColorSelector(this,__tr("Base:"),&(g_pOptions->m_clrNormalGlobalBase));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,4,1);
	s = new KviNewColorSelector(this,__tr("Disabled foreground:"),&(g_pOptions->m_clrDisabledGlobalForeground));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,5,1);
	s = new KviNewColorSelector(this,__tr("Disabled text:"),&(g_pOptions->m_clrDisabledGlobalText));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,6,1);
	s = new KviNewColorSelector(this,__tr("Disabled base:"),&(g_pOptions->m_clrDisabledGlobalBase));
	s->setEnabled(g_pOptions->m_bSetGlobalPaletteAtStartup);
	connect(b,SIGNAL(toggled(bool)),s,SLOT(setEnabled(bool)));
	g->addWidget(s,7,1);

	QLabel * l=new QLabel(_CHAR_2_QSTRING(__tr("Application GUI style:")),this);
//	l->setMinimumSize(l->sizeHint());
	g->addWidget(l,8,0);

	m_pGUIStyleBox = new QComboBox(false,this);
	g->addWidget(m_pGUIStyleBox,8,1);

	r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r,9,9,0,1);

	b = new KviNewBoolSelector(this,__tr("Use big toolbar images (System display)"),&(g_pOptions->m_bUseBigToolbarPixmaps));
	g->addWidget(b,10,0);
	b = new KviNewBoolSelector(this,__tr("Use big toolbar images (User toolbar)"),&(g_pOptions->m_bUseBigUToolbarPixmaps));
	g->addWidget(b,11,0);
	b = new KviNewBoolSelector(this,__tr("Show toolbar button text (System display)"),&(g_pOptions->m_bUseTextToolbarComment));
	g->addWidget(b,10,1);


	r = new QFrame(this);
	g->addMultiCellWidget(r,12,12,0,1);
	g->setRowStretch(12,1);
#endif

	fillGuiStylesBox();
}

KviGeneralOptionsGuiGlobalWidget::~KviGeneralOptionsGuiGlobalWidget()
{
}

void KviGeneralOptionsGuiGlobalWidget::fillGuiStylesBox()
{
	int idx = 1;
	int currentStyle = -1;
	m_pGUIStyleBox->insertItem("default");
	if(kvi_strEqualCI("default",g_pOptions->m_szApplicationGUIStyle.ptr()))currentStyle = 0;
	for(KviStyleEntry * e=g_pApp->m_pStyleList->first();e;e=g_pApp->m_pStyleList->next()){
		m_pGUIStyleBox->insertItem(_CHAR_2_QSTRING(e->name.ptr()));
		if(kvi_strEqualCI(e->name.ptr(),g_pOptions->m_szApplicationGUIStyle.ptr()))currentStyle = idx;
		idx++;
	}
	if(currentStyle != -1)m_pGUIStyleBox->setCurrentItem(currentStyle);
}

void KviGeneralOptionsGuiGlobalWidget::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	KviNewBoolSelector::commitAll(this);

	KviStr save = g_pOptions->m_szApplicationGUIStyle;
	g_pOptions->m_szApplicationGUIStyle = m_pGUIStyleBox->currentText();
	if(g_pOptions->m_szApplicationGUIStyle.isEmpty()){
		g_pOptions->m_szApplicationGUIStyle = save;
	}

	if(!(g_pApp->font() == g_pOptions->m_fntApplication)){
		g_pApp->setFont(g_pOptions->m_fntApplication,true);
	}
	if(g_pOptions->m_bSetGlobalPaletteAtStartup){
		QColorGroup cg(
			g_pOptions->m_clrNormalGlobalForeground,
			g_pOptions->m_clrNormalGlobalButton,
			g_pOptions->m_clrNormalGlobalLight,
			g_pOptions->m_clrNormalGlobalDark,
			g_pOptions->m_clrNormalGlobalMid,
			g_pOptions->m_clrNormalGlobalText,
			g_pOptions->m_clrNormalGlobalText.light(150),
			g_pOptions->m_clrNormalGlobalBase,
			g_pOptions->m_clrNormalGlobalButton
		);
		QColorGroup cgdis(
			g_pOptions->m_clrDisabledGlobalForeground,
			g_pOptions->m_clrNormalGlobalButton,
			g_pOptions->m_clrNormalGlobalLight,
			g_pOptions->m_clrNormalGlobalDark,
			g_pOptions->m_clrNormalGlobalMid,
			g_pOptions->m_clrDisabledGlobalText,
			g_pOptions->m_clrNormalGlobalText.light(150),
			g_pOptions->m_clrDisabledGlobalBase,
			g_pOptions->m_clrNormalGlobalButton
		);
		QPalette pal(cg,cgdis,cg);	
		g_pApp->setPalette(pal,true); //repaint widgets this time
	} else {
		if(!(g_pApp->palette() == g_pApp->m_savedAppPalette))g_pApp->setPalette(g_pApp->m_savedAppPalette,true);
	}
	g_pApp->setApplicationStyle();
	g_pApp->triggerGlobalRepaint();
}


/////////////////////////////////
/*
	@quickhelp: KviGeneralOptionsGuiMircColorsWidget
	@widget: Help browser GUI options
*/

KviGeneralOptionsGuiMircColorsWidget::KviGeneralOptionsGuiMircColorsWidget(QWidget *parent)
:KviGeneralOptionsWidget(parent,KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS)
{
	QGridLayout *g = new QGridLayout(this,8,4,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,1);
	KviNewBoolSelector *b = new KviNewBoolSelector(this,__tr("Use KSirc control codes"),&(g_pOptions->m_bUseKsircControlCodes));
	g->addMultiCellWidget(b,0,0,0,3);
	QLabel *l = new QLabel(_CHAR_2_QSTRING(__tr("mIRC/KSirc colors:")),this);
	g->addMultiCellWidget(l,1,1,0,3);
	KviStr szNum;
	for(int i = 0;i < 16;i++){
		szNum.setNum(i);
		m_pMircColorSelector[i] = new KviNewColorSelector(this,szNum.ptr(),g_pOptions->m_pMircColor[i],true,50);
		g->addWidget(m_pMircColorSelector[i],(i / 4)+2,i % 4);
	}
	QPushButton *pb = new QPushButton(__tr("&Reset"),this);
	g->addWidget(pb,6,0);
	connect(pb,SIGNAL(clicked()),this,SLOT(resetToMircColors()));

	pb = new QPushButton(__tr("&Invert"),this);
	g->addWidget(pb,6,1);
	connect(pb,SIGNAL(clicked()),this,SLOT(invertColors()));

	pb = new QPushButton(__tr("20% &Darker"),this);
	g->addWidget(pb,6,2);
	connect(pb,SIGNAL(clicked()),this,SLOT(makeDarker()));

	pb = new QPushButton(__tr("20% &Lighter"),this);
	g->addWidget(pb,6,3);
	connect(pb,SIGNAL(clicked()),this,SLOT(makeLighter()));

	QFrame *fr = new QFrame(this);
	g->addMultiCellWidget(fr,7,7,0,3);
	g->setRowStretch(7,1);

}

KviGeneralOptionsGuiMircColorsWidget::~KviGeneralOptionsGuiMircColorsWidget()
{
}


void KviGeneralOptionsGuiMircColorsWidget::commitChanges()
{
	KviNewBoolSelector::commitAll(this);
	commitColorSelectors();
}

void KviGeneralOptionsGuiMircColorsWidget::resetToMircColors()
{
	for(int i = 0;i< 16;i++)
		m_pMircColorSelector[i]->setColor(QColor(defaultMircRgb[i]));
}

void KviGeneralOptionsGuiMircColorsWidget::invertColors()
{
	for(int i = 0;i< 16;i++){
		QColor clr(m_pMircColorSelector[i]->getColor());
		clr.setRgb(255 - clr.red(),255 - clr.green(),255 - clr.blue());
		m_pMircColorSelector[i]->setColor(clr);
	}
}

void KviGeneralOptionsGuiMircColorsWidget::makeDarker()
{
	// Just for fun
	for(int i = 0;i < 16;i++)
		m_pMircColorSelector[i]->setColor(m_pMircColorSelector[i]->getColor().dark(120));
}

void KviGeneralOptionsGuiMircColorsWidget::makeLighter()
{
	// Just for fun
	for(int i = 0;i < 16;i++)
		m_pMircColorSelector[i]->setColor(m_pMircColorSelector[i]->getColor().light(120));
}





KviGeneralOptionsListViewItem::KviGeneralOptionsListViewItem(QListView *parent,const QPixmap &pm,const char *category)
:QListViewItem(parent,_CHAR_2_QSTRING(category))
{
	m_id = KVI_GENERAL_OPTIONS_WIDGET_ID_NONE;
	m_pOptionsWidget = 0;
	setPixmap(0,pm);
}

KviGeneralOptionsListViewItem::KviGeneralOptionsListViewItem(QListViewItem *parent,const QPixmap &pm,const char *category,int id)
:QListViewItem(parent,_CHAR_2_QSTRING(category))
{
	m_id = id;
	m_pOptionsWidget = 0;
	setPixmap(0,pm);
}

KviGeneralOptionsListViewItem::~KviGeneralOptionsListViewItem()
{
}

/*
	@quickhelp: KviGeneralOptionsDialog
	@widget: General options dialog
		Here you can set your preferences.<br>
		By selecting a category from the left list view you will
		access the related options.<br>
		By clicking Ok you accept the changes , by clicking Cancel you reject it :)<br>
*/

KviGeneralOptionsDialog::KviGeneralOptionsDialog(QWidget *parent)
:QWidget(parent,"dlgoptions")
{
	setCaption(__tr("KVIrc: General Options"));
	setIcon(*g_pixViewOut[KVI_OUT_KVIRC]);

	QGridLayout * g1 = new QGridLayout(this,2,4,KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER,KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE);
	QSplitter * spl = new QSplitter(QSplitter::Horizontal,this);
	g1->addMultiCellWidget(spl,0,0,0,3);

	// Controlling list view
	m_pListView = new QListView(spl);
	m_pListView->addColumn(__tr("Category"));
	m_pListView->setRootIsDecorated(true);
	connect(m_pListView,SIGNAL(selectionChanged(QListViewItem *)),this,SLOT(listViewItemSelectionChanged(QListViewItem *)));

	KviGeneralOptionsListViewItem * l1;
	KviGeneralOptionsListViewItem * l2;
	KviGeneralOptionsListViewItem * l3;

	l1 = new KviGeneralOptionsListViewItem(m_pListView,*g_pixViewOut[KVI_OUT_SOCKET],__tr("IRC Engine"));
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_MOTD],__tr("Default Messages"),KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_LOG],__tr("Logging"),KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_PART],__tr("Console Messages"),KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_PRIVMSG],__tr("Output"),KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_OP],__tr("Miscellaneous"),KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC);

	l1 = new KviGeneralOptionsListViewItem(m_pListView,*g_pixViewOut[KVI_OUT_CTCPREQUEST],__tr("CTCP"));
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_CTCPREPLY],__tr("Reply Messages"),KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_CTCPERROR],__tr("Flood Protection"),KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_MULTIMEDIA],__tr("Multimedia"),KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA);

	l1 = new KviGeneralOptionsListViewItem(m_pListView,*g_pixViewOut[KVI_OUT_KVIRC],__tr("Interface"));
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_RAW],__tr("Output Widget"),KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_INPUT],__tr("Input Widget"),KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_DIR],__tr("Directory Browser"),KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_SCRIPT],__tr("Script Center"),KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_ECHO],__tr("Miscellaneous"),KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC);

	l1 = new KviGeneralOptionsListViewItem(m_pListView,*g_pixViewOut[KVI_OUT_COLORS],__tr("Appearance"));
		l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_WIDGET],__tr("Fonts & Colors"),KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_NONE],__tr("MDI Windows"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_INPUT],__tr("Input Text"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_TOPIC],__tr("Channel Labels"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_HELP],__tr("Help Browser"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_WHO],__tr("Channel Userlist"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_RAW],__tr("Output Text"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_TIME],__tr("System Tray"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_QUIT],__tr("Application"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL);
		l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_RAW],__tr("Messages"),KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_MIRC],__tr("mIRC & KSirc"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS);
			l3 = new KviGeneralOptionsListViewItem(l2,*g_pixViewOut[KVI_OUT_PRIVMSG],__tr("Message Colors"),KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES);


	l1 = new KviGeneralOptionsListViewItem(m_pListView,*g_pixViewOut[KVI_OUT_DCCINFO],__tr("DCC"));
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_DCCWARNING],__tr("General"),KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_DCCERROR],__tr("Chat"),KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_PACKET],__tr("Send"),KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND);
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_TALK],__tr("Voice"),KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE);


	l1 = new KviGeneralOptionsListViewItem(m_pListView,*g_pixViewOut[KVI_OUT_IDEA],__tr("Miscellaneous"));
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_FILE],__tr("MIME Types"),KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES);
#ifdef COMPILE_PLUGIN_SUPPORT
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_PLUGIN],__tr("Plugins"),KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS);
#endif
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
	l2 = new KviGeneralOptionsListViewItem(l1,*g_pixViewOut[KVI_OUT_ECHO],__tr("Charset Translation"),KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION);
#endif

	QVBox * vbox = new QVBox(spl);

	m_pCategoryLabel = new QLabel(_CHAR_2_QSTRING(__tr("General Options")),vbox);

	// Widget stack
	m_pWidgetStack = new QWidgetStack(vbox);
	vbox->setStretchFactor(m_pWidgetStack,1);

	// First widget visible
	KviGeneralOptionsFrontWidget *w = new KviGeneralOptionsFrontWidget(m_pWidgetStack);
	m_pWidgetStack->addWidget(w,KVI_GENERAL_OPTIONS_WIDGET_ID_NONE);
	m_pWidgetStack->raiseWidget(w);

	// Ok,Cancel,Help
	QPushButton * b = new QPushButton(__tr("What's &This?"),this);
	connect(b,SIGNAL(clicked()),g_pApp,SLOT(slot_whatIsThisRequest()));
	int whatIsThisWidth = b->sizeHint().width();
	g1->addWidget(b,1,1);

	b = new QPushButton(__tr("&OK"),this);
	b->setDefault(true);
	b->setMinimumWidth(whatIsThisWidth);
	connect(b,SIGNAL(clicked()),this,SLOT(okClicked()));
	g1->addWidget(b,1,2);

	b = new QPushButton(__tr("&Cancel"),this);
	connect(b,SIGNAL(clicked()),this,SLOT(cancelClicked()));
	b->setMinimumWidth(whatIsThisWidth);
	g1->addWidget(b,1,3);	

	g1->setRowStretch(0,1);
	g1->setColStretch(0,1);

	setGeometry(g_pOptions->m_rectGeneralOptionsDialog);
}

KviGeneralOptionsDialog::~KviGeneralOptionsDialog()
{
}

void KviGeneralOptionsDialog::cancelClicked()
{
	emit finished(false);
}

void KviGeneralOptionsDialog::okClicked()
{
	if(g_pOptions->m_bUseHackedFrameGeometry){
		g_pOptions->m_rectGeneralOptionsDialog.moveTopLeft(frameGeometry().topLeft());
		g_pOptions->m_rectGeneralOptionsDialog.setSize(size());
	} else g_pOptions->m_rectGeneralOptionsDialog = geometry();

	KviGeneralOptionsListViewItem *it = (KviGeneralOptionsListViewItem *)m_pListView->firstChild();
	while(it)
	{
		recursiveCommit(it);
		it = (KviGeneralOptionsListViewItem *)it->nextSibling();
	}

	for(KviFrame * f = g_pApp->m_pFrameList->first(); f; f = g_pApp->m_pFrameList->next())
		f->restartIdleTimer(); // always do it

	emit finished(true);
}

void KviGeneralOptionsDialog::recursiveCommit(KviGeneralOptionsListViewItem *it)
{
	if(it->m_pOptionsWidget)it->m_pOptionsWidget->commitChanges();

	KviGeneralOptionsListViewItem *it2 = (KviGeneralOptionsListViewItem *)it->firstChild();
	while(it2)
	{
		recursiveCommit(it2);
		it2 = (KviGeneralOptionsListViewItem *)it2->nextSibling();
	}
}

void KviGeneralOptionsDialog::closeEvent(QCloseEvent *e)
{
	e->ignore();
	/* FIXME */
	emit finished(false);
}

void KviGeneralOptionsDialog::listViewItemSelectionChanged(QListViewItem *it)
{
	if(it)
	{
		QString str = it->text(0);
		QListViewItem * par = it->parent();

		while(par)
		{
			str.prepend(" :: ");
			str.prepend(par->text(0));
			par = par->parent();
		}

		KviGeneralOptionsListViewItem *i = (KviGeneralOptionsListViewItem *)it;
		if(!i->m_pOptionsWidget)
		{
			switch(i->m_id)
			{
				case KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES:
					i->m_pOptionsWidget = new KviGeneralOptionsDefaultMessagesWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES:
					i->m_pOptionsWidget = new KviGeneralOptionsCtcpMessagesWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS:
					i->m_pOptionsWidget = new KviGeneralOptionsRedirectionsWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION:
					i->m_pOptionsWidget = new KviGeneralOptionsCtcpProtectionWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA:
					i->m_pOptionsWidget = new KviGeneralOptionsCtcpMultimediaWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW:
					i->m_pOptionsWidget = new KviGeneralOptionsViewWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT:
					i->m_pOptionsWidget = new KviGeneralOptionsInputWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING:
					i->m_pOptionsWidget = new KviGeneralOptionsLoggingWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER:
					i->m_pOptionsWidget = new KviGeneralOptionsDirBrowserWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT:
					i->m_pOptionsWidget = new KviGeneralOptionsOutputWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES:
					i->m_pOptionsWidget = new KviGeneralOptionsMimeTypesWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC:
					i->m_pOptionsWidget = new KviGeneralOptionsIrcMiscWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC:
					i->m_pOptionsWidget = new KviGeneralOptionsInterfaceMiscWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL:
					i->m_pOptionsWidget = new KviGeneralOptionsDccGeneralWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT:
					i->m_pOptionsWidget = new KviGeneralOptionsDccChatWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND:
					i->m_pOptionsWidget = new KviGeneralOptionsDccSendWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE:
					i->m_pOptionsWidget = new KviGeneralOptionsDccVoiceWidget(m_pWidgetStack);
				break;
#ifdef COMPILE_PLUGIN_SUPPORT
				case KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS:
					i->m_pOptionsWidget = new KviGeneralOptionsPluginsWidget(m_pWidgetStack);
				break;
#endif
				case KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER:
					i->m_pOptionsWidget = new KviGeneralOptionsScriptCenterWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiMdiWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiInputWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiLabelsWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiHelpWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiListBoxWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiOutputWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiMircColorsWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiMessagesWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiSysTrayWidget(m_pWidgetStack);
				break;
				case KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL:
					i->m_pOptionsWidget = new KviGeneralOptionsGuiGlobalWidget(m_pWidgetStack);
				break;
#ifdef COMPILE_NEED_CHARSET_TRANSLATION
				case KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION:
					i->m_pOptionsWidget = new KviGeneralOptionsCharsetTranslationWidget(m_pWidgetStack);
				break;
#endif
				default:
					// ID_NONE
					return;
				break;
			}
			m_pWidgetStack->addWidget(i->m_pOptionsWidget,i->m_id);
		}
		m_pWidgetStack->raiseWidget(i->m_pOptionsWidget);
		m_pCategoryLabel->setText(str);
	}
}

void KviGeneralOptionsDialog::showEvent(QShowEvent *e)
{
	move((g_pApp->desktop()->width() - width())/2,
		(g_pApp->desktop()->height() - height())/2);
}


#include "m_kvi_dlgoptions.moc"
