/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef _GENERAL_OPTIONS_H_
#define _GENERAL_OPTIONS_H_

#include <qframe.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>

#include <kconfig.h>
#include <kdialogbase.h>

#include "globals.h"


class GeneralOptions : public QWidget {
	Q_OBJECT
	public:
		GeneralOptions(QWidget *parent = 0);
		
		bool isValid();

	public slots:
		void saveConfig();
		void readConfig();

	signals:
		void optionsChanged(bool valid);
	
	private slots:
		void onOptionsChanged();
		
	private:		
		QSpinBox* maxLines;
		QSpinBox* maxCharacters;
		QCheckBox* deleteDuplicatedLines;
		
		QCheckBox* deleteProcessId;
		QCheckBox* colorizeLogLines;
};

#endif // _GENERAL_PREFERENCES_H_
