/*
Part of KSudoku project
http://ksudoku.sf.net
(c) 2005 Francesco Rossi <redsh@email.it>
(c) 2007 Johannes Bergmeier <Johannes.Bergmeier@gmx.net>
	 Mick Kappenburg <ksudoku@kappenburg.net>
	 Francesco Rossi <redsh@email.it>

This is free software released under GNU GENERAL PUBLIC LICENSE (GPLv2)
See COPYING file in project root directory for more information.

See the credits for this file in AUTHORS file in project root directory
*/
//
// C++ Implementation: PuzzleFactory
//
// Description: 
//
//
// Author:  <>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "puzzlefactory.h"

#include "puzzle.h"


namespace ksudoku {


PuzzleFactory::PuzzleFactory()
{
}


PuzzleFactory::~PuzzleFactory()
{
}

Puzzle* PuzzleFactory::create_instance(GameType type, int order, int difficulty, int symmetry, bool dub, SKSolver* customsolver){
	SKSolver* solver = 0;

	bool d3 = (type == roxdoku) ? 1 : 0; //3d or not 3d
	
	switch(order){
		case  0:
		case  9:
		case 16:
		case 25:
			if(type==ksudoku::custom)
			{
				order = customsolver->order;
				solver = customsolver;
			}
			else
			{
				solver = new SKSolver(order, d3);
				solver->init();
			}
			break;
		default:
			///@todo decide what to do here
			return 0;
			break;
	}
	
	Puzzle* puzzle = new Puzzle(solver, !dub);
	
	if(!dub) {
		if(!puzzle->init(difficulty, symmetry))
			return 0;
	}else {
		if(!puzzle->init())
			return 0;
	}
	return puzzle;
}


}
