/***************************************************************************
 *   Copyright (C) 2005 by Will Entriken                                   *
 *   william.entriken@villanova.edu                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "processcontroller.h"
#include "processlistviewitem.h"

ProcessController::ProcessController(ProcessListViewItem * parent)
  : QObject((QObject *)parent), myParent(parent), myStatus(false), myAutomatic(false), myProcess(new QProcess(this))
{
	connect (myProcess, SIGNAL( readyReadStdout() ), (ProcessController *) this, SLOT( readStdout()) );
	// connect (myProcess, SIGNAL( destroyed() ), myProcess, SLOT( kill()) );
	// this should work, according to http://doc.trolltech.com/3.2/qobject.html#~QObject but it doesn't
}

ProcessController::~ProcessController()
{
	myProcess->kill();
}

void ProcessController::readStdout()
{
	QString tempOutput = myProcess->readStdout();
	
	if( tempOutput.contains( "ripping..." ))
	{
		QString songname = tempOutput.mid( tempOutput.find( "]" )+1, tempOutput.findRev( "[" ) - tempOutput.find( "]" ) - 1);
		myParent->setText( 1, songname.stripWhiteSpace() );
		
		QString bytesR = tempOutput.mid( tempOutput.findRev( "[" )+1, tempOutput.findRev( "]" ) - tempOutput.findRev( "[" ) - 1);
		myParent->setText( 2, bytesR.stripWhiteSpace() );
	}
		
	if( tempOutput.contains( "Connecting..." ))
	{
		myParent->setText( 1, "Connecting..." );
		myParent->setText( 2, "" );
	}
		
	if( tempOutput.contains( "buffering" ))
	{
		myParent->setText( 1, "Buffering..." );
		myParent->setText( 2, "" );
	}
		
	if( tempOutput.contains( "Time to stop is here" ))
	{
		myParent->setText( 1, "Complete" );
		myParent->setText( 2, "" );
		//QTimer::singleShot( 1500, myParent, SLOT( setEmptyText(3) ));
	}
}


void ProcessController::startRip(QString destination, QString time)
{
	myStatus = true;
	myParent->setText( 1, "Ripping" );
	
	myProcess->clearArguments();
	myProcess->addArgument( "streamripper" );
	myProcess->addArgument( myUrl );
	myProcess->addArgument( "-d " );
	myProcess->addArgument( destination );
	if( time.toInt() )
	{
		myProcess->addArgument( "-l " );
		myProcess->addArgument( time );
	}

	myProcess->setCommunication( QProcess::Stdout | QProcess::Stderr | QProcess::DupStderr );
	myProcess->start();
}


void ProcessController::stopRip()
{
	myStatus = false;
	myParent->setText( 1, "" );
	myParent->setText( 2, "" );

	myProcess->tryTerminate();
	QTimer::singleShot( 2000, myProcess, SLOT( kill() ) );
}


bool ProcessController::getStatus()
{
	return myStatus;
}

QString ProcessController::getUrl()
{
	return myUrl;
}

void ProcessController::setAutomatic(bool a)
{
	myAutomatic = a;
}

bool ProcessController::getAutomatic()
{
	return myAutomatic;
}
#if KDE_IS_VERSION(3,3,90)
void ProcessController::setService(DNSSD::RemoteService::Ptr service)
{
	myService = service;
}

DNSSD::RemoteService::Ptr ProcessController::getService()
{
	return myService;
}
#endif

QString ProcessController::getDescription()
{
	return myDescription;
}

void ProcessController::setUrl(QString Url)
{
	myUrl = Url;
}

void ProcessController::setDescription(QString Description)
{
	myDescription = Description;
}
