/*
   ksmp3play - Curses-based MP3 player

   Copyright (C) 2001 Karl Soderstrom

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include "ksmp3play.h"

void
sort_playlist (int what)
{
  /* FIXME: files without ID3 tags go to the top of the list */
  char mp3file_current[256];
  char mp3file_selected[256];
  int i;
  playlist_changes = 1;
  strcpy ((char *) &mp3file_current, (char *) &play[current_song].mp3file);
  strcpy ((char *) &mp3file_selected, (char *) &play[selected].mp3file);

  playlist_sort = what;
  if (what == 1)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_rate);
  else if (what == 2)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_time);
  else if (what == 3)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_artist);
  else if (what == 4)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_title);
  else if (what == 5)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_rate_rev);
  else if (what == 6)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_time_rev);
  else if (what == 7)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_artist_rev);
  else if (what == 8)
    qsort (play, num_songs, sizeof (struct PlayList),
	   (void *) &sort_playlist_title_rev);

  // This is nasty, but I'm tired and can't think of anything better right now
  for (i = 0; i < num_songs; i++)
    {
      if (!strcmp
	  ((const char *) &mp3file_selected, (const char *) &play[i].mp3file))
	selected = i;
      if (!strcmp
	  ((const char *) &mp3file_current, (const char *) &play[i].mp3file))
	current_song = i;
    }
  if (random_play)
    generate_random_playlist ();
  pagetop = selected - (LINES - 9) / 2;
}

int
sort_playlist_rate (const struct PlayList *c1, const struct PlayList *c2)
{
  return ((c1->rate) - (c2->rate));
}

int
sort_playlist_time (const struct PlayList *c1, const struct PlayList *c2)
{
  return ((c1->time) - (c2->time));
}

int
sort_playlist_artist (const struct PlayList *c1, const struct PlayList *c2)
{
  return (strcmp (c1->artist, c2->artist));
}

int
sort_playlist_title (const struct PlayList *c1, const struct PlayList *c2)
{
  return (strcmp (c1->title, c2->title));
}

int
sort_playlist_rate_rev (const struct PlayList *c1, const struct PlayList *c2)
{
  return ((c2->rate) - (c1->rate));
}

int
sort_playlist_time_rev (const struct PlayList *c1, const struct PlayList *c2)
{
  return ((c2->time) - (c1->time));
}

int
sort_playlist_artist_rev (const struct PlayList *c1,
			  const struct PlayList *c2)
{
  return (strcmp (c2->artist, c1->artist));
}

int
sort_playlist_title_rev (const struct PlayList *c1, const struct PlayList *c2)
{
  return (strcmp (c2->title, c1->title));
}
