/*
 *  KSeg
 *  Copyright (C) 1999-2001 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */


#ifndef KSEG_WINDOW_H
#define KSEG_WINDOW_H

#include <qmainwindow.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qfile.h>
#include <vector>

class KSegView;
class KSegDocument;

class KSegWindow : public QMainWindow
{
  Q_OBJECT
public:
  KSegWindow(KSegDocument *doc = 0); //new view for the document

  static bool openFile(QString fileName); //returns true if successful

public slots:
  void newSketch();
  void newConstruction();
  void newView();
  void statusBarMessage(const QString &);

protected slots:

  void updateMenus();

  void updateRecentList();
  void updateNewMenu();
  void updateEditMenu();
  void updateEditColorMenu();
  void updateEditPointstyleMenu();
  void updateEditLinestyleMenu();
  void updateEditFontMenu();
  void updateMeasureMenu();
  void updateTransformMenu();
  void updatePlayMenu();
  void updateQuickPlayMenu();
  void updateConstructionMenu();

  void fileSaveAs();
  void fileSave();
  void fileOpen();
  void filePrint();
  void fileChooseLanguage();
  
  void fileOpenRecent(int);

  void editColorBlack();
  void editColorGray();
  void editColorRed();
  void editColorGreen();
  void editColorBlue();
  void editColorYellow();
  void editColorPurple();
  void editColorCyan();
  void editColorOther();

  void editPointstyleLargecircle();
  void editPointstyleMediumcircle();
  void editPointstyleSmallcircle();

  void editLinestyleSolid();
  void editLinestyleDashed();
  void editLinestyleDotted();
  void editLinestyleThin();
  void editLinestyleNormal();
  void editLinestyleThick();

  void editFont10();
  void editFont12();
  void editFont14();
  void editFont20();
  void editFont30();
  void editFontFont();

  void quickPlay(int);
  void quickPlaySetDirectory();

  void helpAbout();

protected:
  void keyPressEvent(QKeyEvent *ev);
  void keyReleaseEvent(QKeyEvent *ev);
  void closeEvent(QCloseEvent *ev);

private:
  void compressRecentList();

  static vector<QString> KSegWindow::getValidConstructionFiles();
  static QString quickPlayDirectory;

  KSegView *view;

  QPopupMenu *fileMenu;
  QPopupMenu *newMenu;

  QPopupMenu *editMenu;
  QPopupMenu *colorMenu;
  QPopupMenu *pointstyleMenu;
  QPopupMenu *linestyleMenu;
  QPopupMenu *fontMenu;

  QPopupMenu *measureMenu;
  QPopupMenu *transformMenu;
  QPopupMenu *playMenu;
  QPopupMenu *quickPlayMenu;
  QPopupMenu *constructionMenu;
};

#endif //KSEG_WINDOW_H
