// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "TopWidget.h"
#include "CDTrack.h"
#include "ConfigPathWidget.h"
#include "ConfigDialog.h"
#include "AudioFileFormat.h"

#include <kapp.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>

#include <kmessagebox.h>

#include <unistd.h>

TopWidget *MainWin;
KAboutData *myAbout;

static KCmdLineOptions kcdoptions[] =
{
 { "fromdir <dir>", I18N_NOOP("treats the file argument as directory and creates a project from it"), 0 }, 
 { "+[file]", I18N_NOOP("A .cdp file, must have an absolute path."), 0 },
 { 0, 0, 0 } // End of options.
};

int main(int argc,char **argv) {
  int rc;
  KApplication *myApp;

  myAbout=new KAboutData("kreatecd",I18N_NOOP("KreateCD"),VERSION,
			 I18N_NOOP("A CD-recording frontend for KDE"),
			 KAboutData::License_GPL,
			 I18N_NOOP("(c) 1998-2000 by Alexander Feigl"),
			 "http://www.kreatecd.de",
			 0,
			 "kreatecd@kreatecd.de");

  myAbout->addAuthor("Alexander Feigl",I18N_NOOP("Main developer"),
		     "Alexander.Feigl@gmx.de",
		     "http://www.moondream.de");
  myAbout->addAuthor("Joseph Wenninger",
		     I18N_NOOP("DND, project handling"),
		     "jowenn@kde.org",
		     "http://stud3.tuwien.ac.at/~e9925371");
  myAbout->addAuthor("Niels Reedijk", 
		     I18N_NOOP("Configuration Dialog and Konqueror integration"),
                     "nielx@kde.nl");

  myAbout->addCredit("Stefan Gehn", I18N_NOOP("UI Contributions"),"sgehn@gmx.net");
  myAbout->addCredit("Kevin Radlof", I18N_NOOP("Cancel Button Contribution"),"kmradlof@colby.edu");
  myAbout->addCredit("Torsten Rahn", I18N_NOOP("The images for the about page are borrowed from him"),"tackat@suse.de");
  myAbout->addCredit("qwertz", I18N_NOOP("The cogwheel from the CD Copy view is borrowed from him"),"");

  KCmdLineArgs::init(argc,argv,myAbout);
  //We need this for opening files in Konqueror

  KCmdLineArgs::addCmdLineOptions( kcdoptions );

  KApplication::addCmdLineOptions();
  myApp=new KApplication();

  if (!ConfigPathWidget::verifyPrograms()) {
    if (KMessageBox::warningYesNo(0,
				  i18n("Some programs needed by KreateCD\nwere not found!\n\n"
				       "Would you like to go the the path configuration now?"),QString::null ) == 3 ) {
      ConfigDialog *aLocalConfigDialog;
      aLocalConfigDialog = new ConfigDialog( 0 , "aLocalConfigDialog" );
      aLocalConfigDialog->show();
      delete aLocalConfigDialog;
    }
  }

  AudioFileFormat::loadPlugins();

  MainWin=new TopWidget("KreateCD MainWindow");
  myApp->setMainWidget(MainWin);
  myApp->setTopWidget(MainWin);

  MainWin->show(); 
  rc=myApp->exec();

  AudioFileFormat::unloadPlugins();  

  delete myApp;
  delete myAbout;
  return rc;
}
