// KreateCD - CD recording software for the K desktop environment
//
// 1998-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "TOCReader.h"
#include "ProgressDialog.h"

#include <qstring.h>
#include <qmessagebox.h>

#include <kprocess.h>
#include <kapp.h>
#include <kconfig.h>

#include <strings.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include "TOCReader.moc"

int TOCReader::readTOC(bool readBurner) {
  return(invokeTOCReader(readBurner));
}

long int TOCReader::getTOCLBA(int track) {
  if ( (track<1) || (track>99)) return(-1);
  if ( toc_lba[track-1]==-1) return(-1);
  return(toc_lba[track-1]);
}
    
long int TOCReader::getTOCDuration(int track) {
  if ( (track<1) || (track>99)) return(-1);
  if ( toc_lba[track-1]==-1) return(-1);
  return(toc_durat[track-1]);
}

enum CDTrack::TrackType TOCReader::getTOCType(int track) {
  if ( (track<1) || (track>99)) return(CDTrack::Track_Audio);
  if ( toc_lba[track-1]==-1) return(CDTrack::Track_Audio);
  return(toc_ttype[track-1]);
}

long int TOCReader::getTOCSum(void) {
  return(tocsum);
}

void TOCReader::closeTOC(void) {
  toctracks=0;
  while (toc_lba[toctracks]!=-1) {
    ++toctracks;
  }
}

int TOCReader::invokeTOCReader(bool ) {
  return(0);
}
