// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef  NEXTWRITABLE_INCLUDED
#define NEXTWRITABLE_INCLUDED

#include "ProcessInterface.h"
#include <qobject.h>

class NextWritable : public ProcessInterface {
  Q_OBJECT;

 public:
  NextWritable(void);
  ~NextWritable(void);
  bool readWritable(void);
  long int lastSession(void);
  long int nextWritable(void);

 protected:
  virtual int processExited(void);
  virtual bool processStdoutLine(char *buffer);
  virtual bool processStderrLine(char *buffer);
  virtual int  processCleanup(int rval);
  
 private:
  long int nwSession;
  long int nwWritable;
  int cdrflag;

};
#endif

