// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "NewProjectDialog.h"
#include "NewProjectDialog.moc"

#include <klocale.h>
#include <qvbuttongroup.h>
#include <qhbox.h>
#include <kapp.h>
#include <kconfig.h>
#include <qlabel.h>
#include <kiconloader.h>

NewProjectDialog::NewProjectDialog(QWidget *parent, const char *name)
  :KDialogBase( Swallow ,                //SetfaceIconlist
		i18n( "Project type" ) , //Title
		Ok|Cancel ,         //Buttons
		Ok ,                      //MainButton
		parent ,                  //Parent
		name ,                    //name
		true ,                    //Dialog is modal
		true )                    //Draw a separator between buttons and widget
{
  QHBox *box=new QHBox(this);
  box->setSpacing(10);
  QVButtonGroup *btngrp =new QVButtonGroup(box);
  image=new QLabel(box);
  
  btngrp->setExclusive(true);
  for (int i=0; ProjectTypeNames[i]!=0;i++) {
    List[i]=new QRadioButton(i18n(ProjectTypeNames[i]),btngrp);
  }
	

  KConfig *config=kapp->config();
  config->setGroup("Project");
  
  QString sid=config->readEntry("DefaultType");
  int iid;
  if (sid.isNull())
	{
		List[0]->setChecked(true);
		image->setPixmap(UserIcon(ProjectImages[0]));
	}
  else {
    iid=sid.toInt();
    if ((iid>=0) && (iid<TLMMaxTypeCount)) {
      //for further extension:        if (List[iid]!=0) List[iid]->setChecked(true); else List[0]->setChecked(true);
      List[iid]->setChecked(true);
      image->setPixmap(UserIcon(ProjectImages[iid]));
    } else {
      List[0]->setChecked(true);
      image->setPixmap(UserIcon(ProjectImages[0])); }
  }

  setMainWidget(box);
  //(void) addPage(i18n("Seite"),i18n("Beschreibung"));
  //show();
  connect(btngrp,SIGNAL(clicked(int)),this,SLOT(loadImage(int)));
}


void NewProjectDialog::loadImage(int id)
{
	image->setPixmap(UserIcon(ProjectImages[id]));    
}

void NewProjectDialog::slotOk() {
  for (int i=0;(i<TLMMaxTypeCount);i++)
    if (List[i]->isChecked()) {done (i); return;}
  done(-1);
}

void NewProjectDialog::slotCancel() {
  done(-1);
}

