/***************************************************************************
                          fixtextdlg.cpp  -  description
                             -------------------
    begin                : Tue Sep 26 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "fixtextdlg.h"

#include <klocale.h>
#include <qlayout.h>
#include <stdio.h>
#include <qtabwidget.h>

#include "globals.h"

fixtextDlg::fixtextDlg(QWidget *parent)
					 : KDialogBase(parent, "fixtextDlg", true, i18n("Fixtexts"), Ok|Cancel|Help, Ok, true) {

	QWidget* w;
	QLabel* l;
	QHBoxLayout* hbox;
	QVBoxLayout* vbox;
	int i;
	QTabWidget* tab = new QTabWidget(this);
	setMainWidget (tab);

	setWFlags (WDestructiveClose);

	for (i=0;i<12;++i) {
		w = new QWidget(tab);
		vbox = new QVBoxLayout(w, 5, 5);
		text[i] = new QMultiLineEdit (w);
		text[i]->setFont (config.screen.txwinfont);
		text[i]->setText (config.fixtext.text[i]);
		text[i]->setWordWrap (QMultiLineEdit::WidgetWidth);
		text[i]->setMinimumHeight (200);
		vbox->addWidget (text[i]);
		hbox = new QHBoxLayout(0,0,10);
		vbox->addLayout (hbox);
		l = new QLabel (w);
		l->setText (i18n ("&Label:"));
		hbox->addWidget (l);
    label[i] = new QLineEdit (w);
		label[i]->setText (config.fixtext.label[i]);
		label[i]->setFixedWidth (100);
		l->setBuddy (label[i]);
		hbox->addWidget (label[i]);
		hbox->addStretch();
		tab->addTab (w, "F" + QString::number (i+1));
	}	
}

fixtextDlg::~fixtextDlg()
{
}

void fixtextDlg::slotOk()
{
	int i;
	for (i=0;i<12;++i) {
		config.fixtext.text[i]=text[i]->text();
		config.fixtext.label[i]=label[i]->text();
	}
	kpsk->reInit();
	KDialogBase::slotOk();
}
