//
// C++ Interface: kpgtablecolumnwizinfo
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTABLECOLUMNWIZINFO_H
#define KPGTABLECOLUMNWIZINFO_H

// include files for Qt
#include <qstring.h>
#include <qptrlist.h>
#include <qpixmap.h>


/**
  * Storage class for column info - name, base type, icon ... Used by 
  * create table wizard
  *
  *@author Lumir Vanek
  */
class KPGTableColumnWizInfo
{
public:
	KPGTableColumnWizInfo() {;} 
   
	KPGTableColumnWizInfo(const QString &, const QString &, int, int, const QPixmap &, const QString &);
	
	KPGTableColumnWizInfo(const KPGTableColumnWizInfo &);
				
	~KPGTableColumnWizInfo();
	
	void operator = (const KPGTableColumnWizInfo &src)
	{
		m_strName = src.name();
		m_strTypName = src.typName();
		m_Icon = src.icon();
		m_nDimensions = src.nDimensions();
		m_strDescription = src.description();
	}
	
	// Decide, if other column type is compatible for create foreign key
	bool isCompatible(const KPGTableColumnWizInfo &) const;

	// Return columns typname
	const QString & typName() const { return m_strTypName; }
		
	// Return name
	const QString & name() const { return m_strName; }
	
	// Return number of dimensions
	int nDimensions() const { return m_nDimensions; }	
	
	// Return column number in table
	int attNum() const { return m_iAttNum; }
	
	// Return icon
	const QPixmap & icon() const { return m_Icon; }	
	
	// Return description
	const QString & description() const { return m_strDescription; }
		
protected:
	void convertTypNameToBase();
	
protected:
	QString m_strName;
	QString m_strTypName;
	int m_nDimensions;
	int m_iAttNum; 
	QPixmap m_Icon;	
	QString m_strDescription;
};

// Value list for KPGTableColumnWizInfo
typedef QValueList<KPGTableColumnWizInfo> KPGListTableColumns;

// Pointer list for KPGTableColumnWizInfo
class KPGListTableColumnWizInfo : public QPtrList<KPGTableColumnWizInfo>
{
public:
	bool appendColumn(KPGTableColumnWizInfo *);
	void removeColumn(const QString &);
	KPGTableColumnWizInfo * findColumn(const QString &);
};

#endif
