//
// C++ Implementation: kpgdroptableobjectwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdroptableobjectwizard.h"

// include files for Qt
#include <qframe.h> 
#include <qlayout.h>
#include <qpushbutton.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "kpgdropobjectwidget1.h"
#include "../kpgutil.h"

KPGDropTableObjectWizard::KPGDropTableObjectWizard(QWidget *parent, const char *name,
	const QString &strObjectType,
	const QString &strNamespace,
	const QString &strObjectName,
	const QString &strTable)
 : KPG3StepsWizard(parent, name)
{
	m_strObjectType = strObjectType;
  	m_strNamespace = strNamespace; 
	m_strObjectName = strObjectName; 
	m_strTable = strTable;
	
	KPGDropObjectWidget1 *pDropObjectWidget1 = new KPGDropObjectWidget1(WizardPage1, "KPGDropObjectWidget1");
  	m_pPageWidget1 = pDropObjectWidget1;
  	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  
	languageChange();
	setNextEnabled(WizardPage1, true);
}


KPGDropTableObjectWizard::~KPGDropTableObjectWizard()
{
}

void KPGDropTableObjectWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Drop object" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Drop restriction" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGDropTableObjectWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		KPGDropObjectWidget1 *pDropObjectWidget1 = static_cast <KPGDropObjectWidget1 *> (m_pPageWidget1);
		
			QString strSQL("ALTER TABLE ");
			strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strTable));
			strSQL.append(" DROP ");
			strSQL.append(m_strObjectType);
			strSQL.append(" ");
			strSQL.append(KPGUtil::quotedName(m_strObjectName));
			
			strSQL.append(pDropObjectWidget1->getSQL());
			
			m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}

