//
// C++ Interface: kpgcreatetablewidget2
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATETABLEWIDGET2_H
#define KPGCREATETABLEWIDGET2_H

#include "kpgcreatetablewidget2base.h"

#include "kpgtablecolumnwizinfo.h"

class KPGDomainsFolder;
class KPGDatabase;

/**
Widget for Create Table Wizard

@author Lumir Vanek
*/

class KPGCreateTableWidget2 : public KPGCreateTableWidget2Base
{
Q_OBJECT
public:
    KPGCreateTableWidget2(QWidget *parent, const char *name, KPGDatabase *);
    ~KPGCreateTableWidget2();

	const QString getSQL() const;
	bool isDirty1() const { return m_bIsDirty1; }
	bool isDirty2() const { return m_bIsDirty2; }
	void clearDirty1() { m_bIsDirty1 = false; }
	void clearDirty2() { m_bIsDirty2 = false; }
	KPGListTableColumnWizInfo & getListOfColumns() { return m_listOfColumns; }
    
    void refreshListOfDatatypes();
    
protected:
    void fillDomains();
    void fillUserDatatypes();
        
protected:
	bool m_bIsDirty1; // table columns list changed ?
	bool m_bIsDirty2; // table columns list changed ?
	KPGListTableColumnWizInfo m_listOfColumns;
    KPGDatabase *m_pDatabase;
    
protected slots:

    virtual void slotSchemaActivated(int);
    virtual void slotComboDataTypeActivated(const QString &);
	virtual void slotColumnAdd();
    virtual void slotColumnDelete();
    virtual void slotColumnUp();
    virtual void slotColumnDown();
	virtual void slotColumnNameChanged(const QString &);
	virtual void slotColumnSelectionChanged(QListViewItem *);
	virtual void slotColumnCurrentChanged(QListViewItem *);
	virtual void slotNumDimensionsChanged(int);
    virtual void slotCheckToggled(bool);
    virtual void slotDefaultToggled(bool);
    virtual void slotSetDefaultToNow();
		
signals:
	void sigEnableNextButton(bool);
};

#endif
