//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablespacewidget1.h"

#include <kcombobox.h>
#include <klineedit.h>
#include <kurlrequester.h>

#include "../kpgutil.h"


KPGCreateTablespaceWidget1::KPGCreateTablespaceWidget1(QWidget *parent, const char *name)
 : KPGCreateTablespaceWidget1Base(parent, name)
{
  m_pLineEditTablespaceName->setFocus();
  m_pURLRequesterPath->setMode(KFile::Directory);
}


KPGCreateTablespaceWidget1::~KPGCreateTablespaceWidget1()
{
}

void KPGCreateTablespaceWidget1::slotTablespaceNameChanged(const QString& strText)
{
  emit sigEnableNextButton(!strText.isEmpty() && !m_pURLRequesterPath->url().isEmpty());
}

void KPGCreateTablespaceWidget1::slotPathChanged(const QString &strPath)
{
  emit sigEnableNextButton(!strPath.isEmpty() && !m_pLineEditTablespaceName->text().isEmpty());
}

// Return part of SQL stetement for CREATE TABLESPACE
const QString KPGCreateTablespaceWidget1::getSQL() const
{
	QString strSql("CREATE TABLESPACE ");
	
	strSql.append(KPGUtil::quotedName(m_pLineEditTablespaceName->text()));
	
	if(m_pComboBoxOwner->currentItem() > 0)
	{
		strSql.append("\nOWNER ");
		strSql.append(KPGUtil::quotedName(m_pComboBoxOwner->currentText()));
	}
	
	strSql.append(" LOCATION '");
	
	QString strPath(m_pURLRequesterPath->url());
	strPath = strPath.replace("/", "//");
	strSql.append(strPath);
	strSql.append("'");
	
	return strSql;
}

#include "kpgcreatetablespacewidget1.moc"
