//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatesequencewidget1.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlistview.h>

// include files for KDE
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <knuminput.h>

#include "../kpgutil.h"


KPGCreateSequenceWidget1::KPGCreateSequenceWidget1(QWidget *parent, const char *name, QPtrList<QListViewItem> & listOfSchemas)
 : KPGCreateSequenceWidget1Base(parent, name)
{
   
  int iCurrentItem = -1;
  int i = 0;  
  for(QListViewItem *pSchema = listOfSchemas.first(); pSchema; pSchema = listOfSchemas.next())
    {
      m_pComboBoxSchema->insertItem(* pSchema->pixmap(0), pSchema->text(0));
      
      if(pSchema->text(0) == "public")
        iCurrentItem = i;
        
      ++i;
    }
    
  if(iCurrentItem >= 0)
    m_pComboBoxSchema->setCurrentItem(iCurrentItem);
}


KPGCreateSequenceWidget1::~KPGCreateSequenceWidget1()
{
}

void KPGCreateSequenceWidget1::slotSequenceNameChanged(const QString &strText)
{
  emit sigEnableNextButton(! strText.isEmpty() );
}

// Return part of SQL statement for CREATE SEQUENCE
const QString KPGCreateSequenceWidget1::getSQL() const
{
  	QString strSql("CREATE SEQUENCE ");
		
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(),  m_pLineEditSequenceName->text()));
	strSql.append("\n");
	
	// Increment
	if(m_pIntNumInputIncrement->value() != 1)
		strSql.append(QString("INCREMENT %1\n").arg(m_pIntNumInputIncrement->value()));
	
	// Min value
	if(m_pLineEditMinValue->text().isEmpty() == false)	
		strSql.append("MINVALUE " + m_pLineEditMinValue->text() + "\n");
		
	// Max value
	if(m_pLineEditMaxValue->text().isEmpty() == false)	
		strSql.append("MAXVALUE " + m_pLineEditMaxValue->text() + "\n");
		
	// Start value
	if(m_pLineEditStartValue->text().isEmpty() == false)	
		strSql.append("START " + m_pLineEditStartValue->text() + "\n");
		
	// Cache
	if(m_pIntNumInputCache->value() != 1)
		strSql.append(QString("CACHE %1\n").arg(m_pIntNumInputCache->value()));
	
	// Cycle
	if(m_pCheckBoxCycle->isChecked())
		strSql.append("CYCLE");
		
  return strSql;
}

#include "kpgcreatesequencewidget1.moc"
