//
// C++ Interface: kpgtriggerproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTRIGGERPROPPAGE_H
#define KPGTRIGGERPROPPAGE_H

#include "kpgtriggerproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGTrigger;

/**
  * Table trigger property page
  *
  * @author Lumir Vanek
  */
class KPGTriggerPropPage : public KPGTriggerPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGTriggerPropPage(QWidget *parent, KPGTrigger *);
    ~KPGTriggerPropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGTrigger * m_pTrigger;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
		
signals:
	void sigSearchObject(pqxx::oid);	
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
