/***************************************************************************
                          kpgtablecolumnsfolder  -  description
                             -------------------
    begin                : � no 5 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgtablecolumnsfolder.h"

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../kpggeneralsettings.h"
#include "kpgconnection.h"
#include "kpgtablecolumn.h"


KPGTableColumnsFolder::KPGTableColumnsFolder(KPGTable *parent)
	: KPGTableItemsFolder(parent, i18n("Columns"), m_pIconFolderBlueClosed, m_pIconFolderBlueOpen)
{
}

KPGTableColumnsFolder::KPGTableColumnsFolder(KPGTable *parent, KPGTableItemsFolder *after)
	: KPGTableItemsFolder(parent, after, i18n("Columns"), m_pIconFolderBlueClosed, m_pIconFolderBlueOpen)
{
}

KPGTableColumnsFolder::~KPGTableColumnsFolder()
{
}


void KPGTableColumnsFolder::refresh(pqxx::oid oidTable) throw(const KPGSqlException &)
{
	// delete all child items (databases)
	while (QListViewItem * pItem = firstChild())
		delete pItem;
	
	QString strQuery("SELECT a.attname, atttypid, ty.typname, ty.typbasetype, a.attlen, ");
		
	strQuery.append("description, a.attstattarget, a.attnum, a.attndims, a.atttypmod, a.attbyval, a.attnotnull, a.atthasdef, a.attisdropped, a.attislocal, CASE WHEN a.attstorage = 'p' THEN 'PLAIN' WHEN a.attstorage = 'e' THEN 'EXTERNAL' WHEN a.attstorage = 'm' THEN 'MAIN' WHEN a.attstorage = 'x' THEN 'EXTENDED' END AS attstorage, a.attinhcount, ");
		
	strQuery.append("def.adsrc, tn.nspname");
			
	strQuery.append(" FROM pg_catalog.pg_attribute a");
	strQuery.append(" JOIN pg_catalog.pg_type ty ON ty.oid=a.atttypid");
	strQuery.append(" JOIN pg_catalog.pg_namespace tn ON tn.oid=ty.typnamespace");
	strQuery.append(" JOIN pg_catalog.pg_class cl ON cl.oid=a.attrelid");
	//strQuery.append(" JOIN pg_catalog.pg_namespace na ON na.oid=cl.relnamespace");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_type et ON et.oid=ty.typelem");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_attrdef def ON adrelid=a.attrelid AND adnum=a.attnum");
	strQuery.append(" LEFT OUTER JOIN pg_catalog.pg_description des ON des.objoid=attrelid AND des.objsubid=attnum");
	strQuery.append(" WHERE attrelid = ");
	strQuery.append(QString("%1").arg(oidTable));
	
	bool bHideSystemColumns = KPoGreView::configuration()->general()->hideSystemColumns();
	if(bHideSystemColumns)
	{
		strQuery.append(" AND attnum > 0");
	}
	
	strQuery.append(" AND attisdropped IS FALSE");
	strQuery.append(" ORDER BY attnum");
				
    KPGConnection *pConnection = connection();
    try
	{
		m_pqxxResultColumns = pConnection->runQuery(strQuery);
			
		KPGTableColumn *pTableColumn = 0;
			
		for (result::size_type i = 0; i != m_pqxxResultColumns.size(); ++i)
		{
			if(pTableColumn == 0)
				pTableColumn = new KPGTableColumn(this, m_pqxxResultColumns[i]["attname"].c_str());
			else
				pTableColumn = new KPGTableColumn(this, pTableColumn, m_pqxxResultColumns[i]["attname"].c_str());
			
							
			pTableColumn->setProperties(m_pqxxResultColumns[i], pConnection);
		}
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
        throw KPGSqlException(pConnection, e.what(), strQuery);
	} 
}

void KPGTableColumnsFolder::fillListBoxWithChildItems(QListBox *pListBox, bool bIncludeSystemColumns)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTableColumn *pTableColumn = static_cast <KPGTableColumn *> (pItem);
		
		if(bIncludeSystemColumns || (pTableColumn->attNum() >= 0))
		pListBox->insertItem(* pItem->pixmap(0), pItem->text(0));   
		
		pItem = pItem->nextSibling();
	}
}

void KPGTableColumnsFolder::fillListBoxWithChildItems(KListBox *pListBox, bool bIncludeSystemColumns)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTableColumn *pTableColumn = static_cast <KPGTableColumn *> (pItem);
		
		if(bIncludeSystemColumns || (pTableColumn->attNum() >= 0))
		pListBox->insertItem(* pItem->pixmap(0), pItem->text(0));   
		
		pItem = pItem->nextSibling();
	}
}

void KPGTableColumnsFolder::fillComboBoxWithChildItems(KComboBox *pComboBox, bool bIncludeSystemColumns)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTableColumn *pTableColumn = static_cast <KPGTableColumn *> (pItem);
		
		if(bIncludeSystemColumns || (pTableColumn->attNum() >= 0))
		pComboBox->insertItem(* pItem->pixmap(0), pItem->text(0));   
		
		pItem = pItem->nextSibling();
	}
}

void KPGTableColumnsFolder::fillListColumnWizInfoWithChildItems(KPGListTableColumnWizInfo & listColumnWizInfo, bool bIncludeSystemColumns)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTableColumn *pTableColumn = static_cast <KPGTableColumn *> (pItem);
		
		if(bIncludeSystemColumns || (pTableColumn->attNum() > 0))
		{
			listColumnWizInfo.append(new KPGTableColumnWizInfo(
					pTableColumn->text(0), 
					pTableColumn->typName(),
					pTableColumn->attNdims(),
					pTableColumn->attNum(),
					*pTableColumn->pixmap(0),
					pTableColumn->description()
					));
		}
		
		pItem = pItem->nextSibling();
	}
}

void KPGTableColumnsFolder::fillListColumns(KPGListTableColumns &listColumns, bool bIncludeSystemColumns)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTableColumn *pTableColumn = static_cast <KPGTableColumn *> (pItem);
		
		if(bIncludeSystemColumns || (pTableColumn->attNum() > 0))
		{
			listColumns.append(KPGTableColumnWizInfo(
					pTableColumn->text(0), 
					pTableColumn->typName(),
					pTableColumn->attNdims(),
					pTableColumn->attNum(),
					*pTableColumn->pixmap(0),
					pTableColumn->description()
					));
		}
		
		pItem = pItem->nextSibling();
	}
}



