/***************************************************************************
                          kpgobject  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgobject.h"

KPGObject::KPGObject(KPGTreeItem *parent, const QString name, pqxx::oid _oid)
 : KPGTreeItem(parent, name)
{
	m_oid = _oid;
}

KPGObject::KPGObject(KPGTreeItem *parent, KPGTreeItem *after, const QString name, pqxx::oid _oid)
 : KPGTreeItem(parent, after, name)
{
	m_oid = _oid;
}

KPGObject::~KPGObject()
{
}

// search object with given path and OID
KPGTreeItem * KPGObject::searchObject(const QString &strPath, pqxx::oid _oid)
{
	int iPos = strPath.find('/');
	if(iPos <= 0) 
	{
		// path contain only one item name, it must match and OID too
		if((strPath == text(0)) && (_oid == m_oid))
			return this;
		else
			return 0;
	}
		
	return KPGTreeItem::searchObject(strPath, _oid);	
}
