/***************************************************************************
                          kpgitemsfolder.h  -  description
                             -------------------
    begin                : � led 6 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGITEMSFOLDER_H
#define KPGITEMSFOLDER_H

#include "kpgtreeitem.h"

//class QListBox;
class QPixmap;
class KListBox;
class KComboBox;
class KPGOidName;
class KPGObject;

#include <qlistbox.h>

#include "../kpgsqlexception.h"

#define RTTI_KPGLISTBOXITEM 1001

class KPGListBoxItem : public QListBoxPixmap
{
public:
    KPGListBoxItem(const QPixmap &pixmap, const QString& text, KPGTreeItem::eNodeType eNodeType)
        : QListBoxPixmap(pixmap, text) 
    {
        m_eNodeType = eNodeType;
    }  
  
    virtual int rtti() const { return RTTI_KPGLISTBOXITEM; } 
    KPGTreeItem::eNodeType type() const { return m_eNodeType; } // return tree node type

protected:
    KPGTreeItem::eNodeType m_eNodeType;
};


/**
  * Item, that represent folder for tables, views, procedures ....
  * 
  * @author Lumir Vanek
  */
class KPGItemsFolder : public KPGTreeItem
{
public: 
	KPGItemsFolder(KPGTreeItem *, const QString, QPixmap *, QPixmap *);
	KPGItemsFolder(KPGTreeItem *, KPGTreeItem *, const QString, QPixmap *, QPixmap *);
	~KPGItemsFolder();

	//  Change folder icon
	virtual void setOpen( bool);

	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) = 0;
	    	
    void fillListBoxWithChildItems(QListBox *);
	void fillListBoxWithChildItems(KListBox *);
    void fillComboBoxWithChildItems(KComboBox *);
    
    virtual void fillListOfObjectOidsWithChildItems(KPGOidNameList & listOfObjectOids);
    
    // Try find child object by given OID
    KPGObject * getChildItemByOid(pqxx::oid);
	
private:
	
	QPixmap *m_pIconClosed;
	QPixmap *m_pIconOpen;
};

#endif
