/***************************************************************************
                          kpgconfiguration.cpp  -  description
                             -------------------
    begin                : Ne led 18 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgconfiguration.h"

#include "QueryResult/kpgsqleditorsettings.h"
#include "kpggeneralsettings.h"
#include "DataTable/kpgdatatablesettings.h"
#include "XmlSupport/kxetextviewsettings.h"

#include <kglobal.h>
#include <klocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>

#include <qlayout.h>


KPGConfiguration::KPGConfiguration()
 : QObject( 0, "KPoGre's configuration (KPGConfiguration)" ),
   m_pDialog( 0 )
{
	// initialize all setting group objects
  	m_pSettingsGeneral = new KPGGeneralSettings( this, "General settings" );
	m_pSettingsSqlEditor = new KPGSqlEditorSettings( this, "SQL editor config. settings" );
	m_pSettingsDataTable = new KPGDataTableSettings( this, "Datatable settings" );
	//m_pSettingsKXETextView = new KXETextViewSettings( this, "XML Editor settings" );
	// restore the settings from our config file
	restore();
}

KPGConfiguration::~KPGConfiguration()
{
	if ( m_pDialog )
		delete m_pDialog;
}

void KPGConfiguration::store( KConfig * pConfig ) const
{
	if ( ! pConfig )
		pConfig = KGlobal::config();

  	m_pSettingsGeneral->store(pConfig);  
	m_pSettingsSqlEditor->store(pConfig);
	m_pSettingsDataTable->store(pConfig);
	// @deprecated m_pSettingsKXETextView->store(pConfig);
}


void KPGConfiguration::restore( KConfig * pConfig )
{
	if(!pConfig)
		pConfig = KGlobal::config();

  	m_pSettingsGeneral->restore(pConfig);  
	m_pSettingsSqlEditor->restore(pConfig);
	m_pSettingsDataTable->restore(pConfig);
	// @deprecated m_pSettingsKXETextView->store(pConfig);
}


void KPGConfiguration::showDialog()
{
	if ( ! m_pDialog ) // if there is no dialog yet,
	{
		//--- Create one
		m_pDialog = new KDialogBase( KDialogBase::IconList,        // dialog face
		                             i18n("Configure KPoGre"), // caption
		                             KDialogBase::Apply | KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Help,   // buttons
		                             KDialogBase::Ok,              // default button
		                             0,                            // parent
		                             "configuration dialog",       // name
		                             false,                        // not modal
		                             true );                       // show separator
		connect( m_pDialog, SIGNAL(applyClicked()), this, SLOT(slotDlgApplied()) );
		connect( m_pDialog, SIGNAL(okClicked()), this, SLOT(slotDlgApplied()) );

		// and add the pages
		QFrame * pFrame;
		QWidget * pPage;
		QVBoxLayout * pLayout;

		//--- General editor properties page
		pFrame = m_pDialog->addPage( m_pSettingsGeneral->dialogPageName(),
		                             m_pSettingsGeneral->dialogPageHeader(),
		                             KGlobal::instance()->iconLoader()->loadIcon( m_pSettingsGeneral->dialogPageIcon(), KIcon::NoGroup, KIcon::SizeMedium ) );
                                 
		pLayout = new QVBoxLayout( pFrame );
		pPage = m_pSettingsGeneral->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pSettingsGeneral, SIGNAL(sigDialogPageChanged()), this, SLOT(slotDlgChanged()) );
									
		//--- SQL editor properties page
		pFrame = m_pDialog->addPage( m_pSettingsSqlEditor->dialogPageName(),
									m_pSettingsSqlEditor->dialogPageHeader(),
									KGlobal::instance()->iconLoader()->loadIcon( m_pSettingsSqlEditor->dialogPageIcon(), KIcon::NoGroup, KIcon::SizeMedium ) );
									
                                 
		pLayout = new QVBoxLayout( pFrame );
		pPage = m_pSettingsSqlEditor->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pSettingsSqlEditor, SIGNAL(sigDialogPageChanged()), this, SLOT(slotDlgChanged()) );
		
		//--- Datatable editor properties page
		pFrame = m_pDialog->addPage( m_pSettingsDataTable->dialogPageName(),
		                             m_pSettingsDataTable->dialogPageHeader(),
		                             KGlobal::instance()->iconLoader()->loadIcon( m_pSettingsDataTable->dialogPageIcon(), KIcon::NoGroup, KIcon::SizeMedium ) );
                                 
		pLayout = new QVBoxLayout( pFrame );
		pPage = m_pSettingsDataTable->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pSettingsDataTable, SIGNAL(sigDialogPageChanged()), this, SLOT(slotDlgChanged()) );
		
		//--- XML editor properties page
		/* @deprecated
		pFrame = m_pDialog->addPage( m_pSettingsKXETextView->dialogPageName(),
		                             m_pSettingsKXETextView->dialogPageHeader(),
		                             KGlobal::instance()->iconLoader()->loadIcon( m_pSettingsKXETextView->dialogPageIcon(), KIcon::NoGroup, KIcon::SizeMedium ) );
                                 
		pLayout = new QVBoxLayout( pFrame );
		pPage = m_pSettingsKXETextView->dialogPage( pFrame );
		pLayout->addWidget( pPage );
		connect( m_pSettingsKXETextView, SIGNAL(sigDialogPageChanged()), this, SLOT(slotDlgChanged()) ); */
	}

	if ( m_pDialog->isVisible() ) // If the dialog is visible (probably opened by
	{                             // another part), it has to be hidden to make
		m_pDialog->hide();         // it appear on the current desktop by the later
	}                             // call of show.
	else                                      // If the dialog is not visible, it's
	{                                         // Apply- and Ok-buttons have to be
		m_pDialog->enableButtonApply( false ); // disabled (until something is changed
		m_pDialog->enableButtonOK( false );    // within the dialog).
	}

	m_pDialog->show();   // show our configuration dialog
}

void KPGConfiguration::slotDlgApplied()
{
	// reset configuration dialog
	m_pDialog->enableButtonApply( false );
	m_pDialog->enableButtonOK( false );

	// apply the page's data to the corresponding setting groups
	m_pSettingsGeneral->apply();
  	m_pSettingsSqlEditor->apply();
  	m_pSettingsDataTable->apply();
  	// @deprecated m_pSettingsKXETextView->apply();
	
	// store the applied data to our config file
	store();
}

void KPGConfiguration::slotDlgChanged()
{
	m_pDialog->enableButtonApply( true );
	m_pDialog->enableButtonOK( true );
}
