//
// C++ Implementation: kpgmodifyviewwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifyviewwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <ktextedit.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgview.h"
#include "kpgmodifyviewwidget1.h"
#include "../kpgutil.h"


KPGModifyViewWizard::KPGModifyViewWizard(QWidget *parent, const char *name, KPGDatabase *pDatabase, const QString & strNamespace, KPGView *pView)
 : KPG3StepsWizard(parent, name)
{
	m_strNamespace = strNamespace;
  	m_strViewName = pView->text(0);
  
  	KPGModifyViewWidget1 *pModifyViewWidget1 = new KPGModifyViewWidget1(WizardPage1, "KPGModifyViewWidget1", pDatabase);
	m_pPageWidget1 = pModifyViewWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pModifyViewWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));

	languageChange();
		
	// set View definition to edit box
	pModifyViewWidget1->m_pTextEditSQL->setText(pView->definition());
}


KPGModifyViewWizard::~KPGModifyViewWizard()
{
}

void KPGModifyViewWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
		
		setCaption( i18n( "Modify view" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - Enter SQL statement for view" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGModifyViewWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		// prepare SQL statement
		QString strSql("CREATE OR REPLACE VIEW ");
		
		strSql.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strViewName));
		strSql.append(" AS\n");
		
		strSql.append((static_cast <KPGModifyViewWidget1 *> (m_pPageWidget1))->getSQL());
		
		m_pTextEditSQL->setText(strSql);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
	
}
#include "kpgmodifyviewwizard.moc"
