/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */
#ifndef _RND_H_
#define _RND_H_

/*
 * rnd.h -- random item selection from a list
 *
 *	(Need usual copyleft comments and CVS ID headers around here.)
 */

/* Limit types */

typedef unsigned char	u_idx;	/* index -- uchar for max 256 indices */
typedef unsigned char	u_num;	/* number -- uchar for max 256 items */

#define RND_NUMLAST	4  /* max remembered indices -- must be a power of 2 */

#define NEL(x)		(sizeof(x) / sizeof(*x))/* num elements in an array */
#define ARND(x)		(random() & ((x) - 1))	/* x must be a power of 2 */
#define RND(x)		(random() % (x))	/* x must be > 0 */

/*
 * RNDLIST -- structure for randomly picking opaque object pointers from a list
 */

typedef struct s_rndlist {
	u_num	last[RND_NUMLAST];	/* array of last N picked items */
	u_idx	lastidx;		/* index in last array to reuse */
	u_idx	num;			/* number of elements in items */
	void	*items[1];		/* item array - variable sized */
} RNDLIST;

/*
 * RANDOM_NUM_STATE -- a union to make sure that initstate(3)'s data is aligned
 * on a long word boundary.  See random(3) for details.
 * Uses a 256 byte state array for best randomness.
 */

typedef union u_random_state {
	long	l[256 / sizeof(long)];
	char	c[256 / sizeof(char)];
} RANDOM_STATE;

extern RANDOM_STATE  gfx_random;	/* one for gfxDrawSky()		*/
extern RANDOM_STATE  main_random;	/* one for everyone else	*/

extern RNDLIST	*rndNewList(int num, void **items);
extern void	*rndList(RNDLIST *listp);
extern void	rndInit(void);

#endif /* _RND_H_ */
