/***************************************************************************
                          useradd.h  -  description                              
                             -------------------                                         
    begin                : Sun Jan 9 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef USERADD_H
#define USERADD_H

#include <qwidget.h>
#include <kwizard.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qvbox.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <agent.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qpushbutton.h>

#include <kmessagebox.h>

#include <jabbercore.h>
#include <user.h>
#include <group.h>
#include <infoquery.h>



class UserAddPg1;

/**
  * Add user dialog(s)
  *
  * This is a really ugly dialog for searching for or otherwise adding users to the system.
  * This is a really big ugly mess (that needs to be made pretty, both the code and the interface).
  *
  * @author Seth Hartbecke (gandalf@netins.net)
  */
class UserAdd : public KWizard  {
   Q_OBJECT
public:
	UserAdd(QWidget *parent=0, const char *name=0);
	~UserAdd();

        static void showUserAdd();

signals:
	void addThisUser(User *u);

protected:
        void accept();
        void reject();

private:
        static UserAdd *currentWindow;

        UserAddPg1 *firstPage;

};

/**
 * Container widget for all pages in the user add system
 *
 * This shows the pretty konverse logo on the left side of the screen
 * and has a place to put whatever you want on the right of that.  I built this
 * class so that all the pages could have the really cool konverse logo and I would
 * not have to write the code for loading it over and over and over....
 */
class UserAddTemplate
        : public QWidget
{
Q_OBJECT
public:
        UserAddTemplate( KWizard *parent, const char *name = 0 );
        ~UserAddTemplate();


protected:
        /**
	 * This is the object you can use to place any of your controls into
	 */
        QWidget *form;
        KWizard *parent;

private:
        QGridLayout *topLayout;
        QVBox *konverseLogoContainer;
        QWidget *konverseLogo;


};

/**
 * This is the first page of the use add system.
 *
 * This is the page that asks you if you want to search for a user's id or if you
 * know it already and just want to type it in
 */
class UserAddPg1 : public UserAddTemplate {
Q_OBJECT
public:
        UserAddPg1(KWizard *parent, const char *name=0);
        ~UserAddPg1();

public slots:
        void clickIKnowID();
        void clickSearch();

private:
        void deleteOtherPages();

        QGridLayout *topLayout;
        QRadioButton *btnKnowId, *btnSearch;
};

/**
 * Form for entering a user ID.
 *
 * This is the form where a user can enter another user's ID for adding them to the roster
 */
class UserAddPgKnowID : public UserAddTemplate {
Q_OBJECT
public:
        UserAddPgKnowID( KWizard *parent, const char *name=0 );
        ~UserAddPgKnowID();

private slots:
        void changedIMSystem( const QString &system );
        void checkCanProceed();

private:
        QGridLayout *topLayout;

        QComboBox *cboIMSystem;
        QLabel *lblIMSystem;
        QLineEdit *txtUserID;
        QLabel *lblUserID;
        QLineEdit *txtServer;
        QLabel *lblServer;
};

/**
 * This page is shared between both choices in the user add system.  This is the page where they
 * are allowed to enter the user's "real" name and choose which groups to add the user to.
 */
class UserAddPgChooseGroup : public UserAddTemplate {
Q_OBJECT
public:
        UserAddPgChooseGroup( KWizard *parent, const char *name=0 );
        ~UserAddPgChooseGroup();

public slots:
        void setJabberID( JabberID jid );
        void addThisUser();

private slots:
        void createGroup();
        void checkCanFinish();

private:
        QGridLayout *topLayout;

        QGroupBox *grpContainer;
        QGridLayout *grpLayout;
        QListView *groups;
        QLineEdit *txtNewGroup;
        QPushButton *btnAdd;

        QLabel *lblRealName;
        QLineEdit *txtRealName;

        JabberID _jid;
};

/**
 * Choose which system to search for users in form.
 *
 * The user is presented with this form when they claim they do not know the user's ID.  This allows
 * them to choose which system to search.
 */
class UserAddPgChooseSearchSystem : public UserAddTemplate {
Q_OBJECT
public:
        UserAddPgChooseSearchSystem( KWizard *parent, const char *name=0 );
        ~UserAddPgChooseSearchSystem();

private slots:
        void changedIMSystem();

private:
        QGridLayout *topLayout;

        QLabel *lblIMSystem;
        QComboBox *cboIMSystem;
};

/**
 * User search forms.
 *
 * Theis form displays the search form for the requested transport.  It also submits the
 * user's query and displays the result.
 */
class UserAddPgSearchForm : public UserAddTemplate {
Q_OBJECT
public:
        UserAddPgSearchForm( KWizard *parent, const char *name=0 );
        ~UserAddPgSearchForm();

public slots:
        void setService( QString service );

private slots:
        void formRecieved(InfoQuery *, InfoQuery *);
        void searchResults(InfoQuery *, InfoQuery *);
        void searchPushed();
        void tryAgainPushed();
        void itemSelected(QListViewItem *);

private:
        void softReset();

        QString _service;       // Like icq.jabber.org
        QLabel *_instructions;
        QLabel *_status;
        QGridLayout *layout;
        QList<QLabel> _labels;
        QList<QLineEdit> _inputBoxes;
        QPushButton *_btnSearch, *_btnNewSearch;
        QListView *_results;
        QString _key;

};

#endif
