/***************************************************************************
                          messagereciever.h  -  description
                             -------------------
    begin                : Sun  Dec 31, 2000
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _MESSAGE_RECIEVER_H_
#define _MESSAGE_RECIEVER_H_

#include <qstring.h>
#include <jabberid.h>
#include <xmlnode.h>

/**
 * This class aids on message routing for the message bin.  Any class that wants to recieve messages should inherit
 * from this classand override the newPacket method
 *
 * @author Seth Hartbecke (gandalf@netins.net)
 * @short Message reciever object.
 * @see MessageBin
 */
class MessageReciever
{
public:
        MessageReciever( );
        virtual ~MessageReciever();

	/**
	 * Returns the Jid of any messages you want routed here.  If null, any unrouted messages
	 * will be sent here.
	 */
        virtual JabberID getJID() { return _jid; };
	/**
	 * Retruns the thread id of messages routed here.  Null of you want the part of the
	 * message packet ignored.
	 */
        virtual QString thread() { return _thread; };
	/**
	 * Retunrs the chat type that you want routed here.  At the last time I read the jabber docs
	 * the valid types where "chat", "message", and "group".
	 */
        virtual QString chatType() { return _chatType; }; // Something like chat, message, group


	/**
	 * Set the Jabber ID of messages you want routed here
	 */
        virtual void setJID( JabberID jid ) { _jid = jid.getJID(); };
	/**
	 * Sets the thread id of messages you want routed here
	 */
        virtual void setThread( const QString thread ) { _thread = thread; };
	/**
	 * Sets the message type of messages you want routed here.
	 * Valid types are "chat", "message", and "group".
	 */
        virtual void setType( const QString type ) { _chatType = type; };


	/**
	 * Override this method if you are actually inetersed in the messages you have requested.
	 * Every new message you want will be delivered here.
	 */
        virtual void newPacket( XMLNode * ) { /* Logging here? */ };

private:
        JabberID _jid;
        QString _thread;
        QString _chatType;

};

#endif
