/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef MessageBin_H
#define MessageBin_H

#include <config.h>

#include <kmessagebox.h>

#include <qwidget.h>
#include <qobject.h>
#include <qlist.h>
#include <qdatetime.h>

#include <string.h>
#include <time.h>

#include "jabberid.h"
#include "xmlnode.h"
#include "dlgchat.h"
#include <xmlfile.h>
#include <messagereciever.h>

class User;
class UserPresence;
class ConversationView;
class WrapEdit;
class DlgChat;

/**
 * The message bin handles all message routing and storing of messages happens.
 *
 * Messages that do not have a dialog open to go to will be stored utill the
 * user opens a dialog to read them.
 *
 * @author Seth Hartbecke
 */
class MessageBin : public QObject  {
   Q_OBJECT
public:
	MessageBin(QWidget *parent=0, const char *name=0);
	~MessageBin();

	/**
	 * Open a new chat dialog to the user specified.  If there are unread messages
	 * from that user, then they will be sent to the dialog.  If name is null then
	 * the chat dialog will be sent the messages from the oldest unread message.
	 */
	DlgChat *startChat(QString name=(char *)0);

public slots:
        /**
	 * New messages that need to be routed can be input here.
	 */
	void incomingPacket(XMLNode *newTag);
	/**
	 * When a chat dialog closes it should call this when it closes so that messages
	 * are nologer routed there.  Because you inherit from MessageReciever this will
	 * happen automatically.
	 */
	void unregisterInterest(MessageReciever *cd);
	void systemOnline();
	/**
	 * Chat dialogs give thier pointer to this so that message can be routed correctly.
	 * MessageReciever does this for you.
	 */
	void registerInterest(MessageReciever *mr);

signals:
	void currentMessageCount(int totalUnreadMessages);

private:
	XMLNode *getOldestMessage(MessageReciever *mr);

	// Returns true if this was sent to an open chat dialog.
	bool checkInterestList(XMLNode *t);
	void emitCurrentMessageCount();

	XMLFile *messages;
	void appendMessage(XMLNode *tagToAppend);

	QList<MessageReciever> interest;
};

#endif







