/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "messagebin.h"
#include <user.h>
#include <wrapedit.h>
#include <conversationview.h>
#include <userpresence.h>


MessageBin::MessageBin(QWidget *parent, const char *name )
	: QObject(parent,name)
{
	messages = new XMLFile( (char *)0, "unread.xml", this, "unread_messages");
	
	XMLNode::printXML( (XMLNode *)messages);
}

// Should write a destructor to free the message lists, etc.
// currently I am not worried about this as the only time
// this object is destroyed is when the application is shutdown
MessageBin::~MessageBin()
{
 	// Good place to save unread messages to a file?
 	messages->sync();
 	delete messages;
}

// This is for incoming messages.  Currently it will check to make
// sure the tag is a message tag (Any incoming XML tag will be sent
// to this method.)  and if it has a type of "error" then it will
// create an alert box with the error message.
// Perhaps a better way of showing errors should be devised.
void MessageBin::incomingPacket(XMLNode *newTag)
{
	if (strcasecmp(newTag->getName(), "message") == 0)
	{
		if (newTag->getAttribute("type") != NULL)
		{
			if (strcasecmp(newTag->getAttribute("type"), "error") == 0)
			{
		   	        KMessageBox *errorBox = new KMessageBox;
                                QString text = newTag->getChildNode("error")->getValue();
                                if (text.isEmpty())
                                        text = newTag->getChildNode("body")->getValue();

		   	        errorBox->sorry(0, text, "Error - Konverse");
		   	        delete errorBox;
		   	        return;
			}
		}

		if (!checkInterestList(newTag))		// If there is no open window that wants it
			appendMessage(newTag);					// then store it
	}
}


// Append to unread message bin. (list).
// Puts the new item at the beginning of the list
// So if you want the oldest one you need to
// loop through the whole linked list to find it
void MessageBin::appendMessage(XMLNode *tagToAppend)
{
	XMLNode *newXMLNode;

	newXMLNode = new XMLNode( *tagToAppend ); // I want a copy.

        /* First check and see if it has a timestamp...if it does not, then we will add one */
        int i;
        bool timestamp = true;
        for( i=0; i<tagToAppend->numberChildNodes(); i++ )
        {
                if ( tagToAppend->getChildNode( i )->getName() == "x" )
                {
                        if ( tagToAppend->getChildNode( i )->getAttribute( "xmlns" ) == "jabber:x:delay" )
                        {
                                /* Found one! */
                                timestamp = false;
                        }
                }
        }

        if ( timestamp )
        {
                XMLNode *timestamp = new XMLNode( "x" );
                timestamp->setAttribute( "xmlns", "jabber:x:delay" );
                QDateTime dt; dt.setTime_t( time( 0 ) );
                timestamp->setAttribute( "stamp", jabber->convertToJabberTime( dt ) );
                newXMLNode->addChildNode( timestamp );
        }

        messages->addChildNode( newXMLNode );

	// Let everybody know how many messages there are unread.
	emitCurrentMessageCount();
}

// This signal is caught by any object that wants to know
// how many unread messages there are.
void MessageBin::emitCurrentMessageCount()
{
	messages->sync();

	emit(currentMessageCount( messages->numberChildNodes() ));
}


// This function is used internally to removed the "oldest"
// message for a given user & nick from the list.  This is
// used when setting up new chat dialogs to pull all their
// unread messages from the unread linked list.
// The oldest messages are at the end of the linked list
// (This is why the while loop goes through them all.)
// This will also remove it from the message list
XMLNode *MessageBin::getOldestMessage( MessageReciever *mr )
{
	XMLNode *retVal;
	int i;

             if (messages->numberChildNodes() == 0)
             	return 0;


             if (mr->getJID().getDomain().isEmpty())
             {
            		// Just get the oldest message
            		retVal = messages->getChildNode( 0 );
            		messages->deleteChildNode( 0 );
		emitCurrentMessageCount();
            		return retVal;
            	}

 	for (i=0; i<messages->numberChildNodes(); i++)
 	{
 		retVal = messages->getChildNode( i );

 		JabberID jidMessage( retVal->getAttribute("from") );

		if ( strcasecmp( jidMessage.getNode(), mr->getJID().getNode()) == 0
		&& strcasecmp( jidMessage.getDomain(), mr->getJID().getDomain()) == 0
                && ( strcasecmp( jidMessage.getResource(), mr->getJID().getResource() ) == 0 || mr->getJID().getResource().isEmpty() ) )
		{
			if (mr->thread().isNull())
			{
				// Not checking the thread attribute.
				messages->deleteChildNode( i );
				emitCurrentMessageCount();
		                return retVal;
			}
			else
			{
				// We are also checking the thread attribute.
				if (!retVal->getChildNode("thread")->getValue().isNull() && strcmp(retVal->getChildNode("thread")->getValue(), mr->thread() ) == 0)
				{
					messages->deleteChildNode( i );
					emitCurrentMessageCount();
			                return retVal;
				}
			}
		}
	}


	// Still here...guess we did not find anything
	return 0;
}

// This will create a new chat dialog and enable message forwarding
// so that any messages coming from the user/nick/thread are sent to
// the chat dialog just created
void MessageBin::registerInterest(MessageReciever *mr)
{
        /* make sure the thread id is et */
        if ( mr->thread().isEmpty() )
        {
		QString threadID;
		threadID.sprintf("%x", (int)time( 0 ));
		mr->setThread( threadID );
        }

        interest.append( mr );

	// Scan through the new message bin for messages that have not yet been read.
	XMLNode *t;
	// Yes...I actually want it this way (the truth thing that is).
	while((t = getOldestMessage( mr )))
	{
	 	mr->newPacket(t);
	 	delete t;
	}

 	return;
}


void MessageBin::systemOnline()
{
 	emitCurrentMessageCount();
}

// When a new message arrives in the system it is sent to this
// method, this method then looks for any open windows that are
// chatting with that user/nick/thread (all three must match)
// if there is, it will forward the message to them and return
// true.  If there is not it will return false
bool MessageBin::checkInterestList(XMLNode *t)
{
 	bool sentToChatWindow = false;
 	bool sendToThisWindow;
 	MessageReciever *item;
	unsigned int i;
	JabberID messageJID( t->getAttribute("from") );

 	for( i=0; i<interest.count(); i++)
 	{
 	 	item = interest.at( i );

 		sendToThisWindow = true;

               if (strcasecmp( item->getJID().getNode(), messageJID.getNode()) != 0
		|| strcasecmp(item->getJID().getDomain(), messageJID.getDomain()) != 0)
 	 		sendToThisWindow = false;

                if (strcasecmp( item->getJID().getResource(), messageJID.getResource() ) != 0
                    && !item->getJID().getResource().isEmpty() )
                        sendToThisWindow = false;

                if ( t->getAttribute("type") == "groupchat" && item->chatType() != "groupchat" )
                        sendToThisWindow = false;
                if ( t->getAttribute("type") != "groupchat" && item->chatType() == "groupchat" )
                        sendToThisWindow = false;

                if ( !t->getChildNode("thread")->getValue().isNull()
                        && !item->thread().isEmpty()
                        && strcasecmp( t->getChildNode("thread")->getValue(), item->thread() ) != 0 )
                        sendToThisWindow = false;

 	 	if (sendToThisWindow == true)
 	 	{
                        item->newPacket( t );
 	 		sentToChatWindow = true;
 	 	}
 	}

 	return sentToChatWindow;
}

// After a chat dialog closes it is VERY important that
// the forwarding of messages to the object be stopped.
void MessageBin::unregisterInterest(MessageReciever *mr)
{
        interest.remove( mr );
}

// Returns a pointer to a DlgChat.  It will have any messages
// that are unread and waiting for them in it already.
// If you want it to appear on the screen make sure to show() it.
DlgChat *MessageBin::startChat(QString name)
{
        JabberID jid( name );
	DlgChat *retVal = new DlgChat();
	retVal->setJID( jid );

	// First we need to get the oldest matching message
	XMLNode *t;
	t = getOldestMessage( retVal );

	if (t == 0)
	{
		// Humm...no messages
		if (name.isNull())
		{
			// Hummmmmm.  No name either.  Lookes like they wanted
			// a new chat and did not tell us who to chat with
                        delete retVal;
			return 0;		// Sorry, can't help you
		}
	}
	else
	{
		retVal->newPacket(t);
	}

 	// Make sure all messages for this user/nick go to this window
 	registerInterest( retVal );

 	// Please remember to show() it.
 	return retVal;
}

