/***************************************************************************
                          jabberid.cpp  -  description                              
                             -------------------                                         
    begin                : Thu May 18 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "jabberid.h"

JabberID::JabberID()
{

}

JabberID::JabberID( QString jid )
{
	parse(jid);
}

JabberID::JabberID(QString node, QString domain, QString resource )
{
	_node = node.copy();
	_domain = domain.copy();
	_resource = resource.copy();
}

JabberID::JabberID(JabberID &jid)
{
        _node = jid.getNode().copy();
        _domain = jid.getDomain().copy();
        _resource = jid.getResource().copy();
}

JabberID JabberID::operator =(QString &jid)
{
 	parse(jid);
 	return *this;
}

void JabberID::parse(QString jid)
{
	_domain = "";
	_node = "";
	_resource = "";
	
 	if (!jid.isNull())
 	{
 	 	int locAt = jid.find("@");
 	 	if (locAt != -1)
 	 	{
 	 		_node = jid.mid( 0, locAt );
 	 	}

 	 	int locSlash = jid.find("/");
 	 	if (locSlash != -1)
 	 	{
 	 		_resource = jid.mid( locSlash + 1, jid.length() - locSlash );
 	 	}

		if(locAt == -1 && locSlash == -1)
			_domain = jid;
		else	 	 		
		{	
			if (locSlash == -1)
				locSlash = jid.length();

	 	 	_domain	= jid.mid( locAt + 1, locSlash - locAt - 1);
 	 	}

 	 }
}

QString JabberID::getDomain()
{
	return _domain;
}

QString JabberID::getNode()
{
	return _node;
}

QString JabberID::getResource()
{
	return _resource;
}

QString JabberID::getJID()
{
	QString fullID;

	if (!_node.isEmpty())
	{
		fullID.append( _node );
		fullID.append( "@");
	}

	fullID.append( _domain );

	if (!_resource.isEmpty())
	{
		fullID.append( "/" );
		fullID.append( _resource );
	}

	return fullID;
}

