/***************************************************************************
                          expat.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jun 8 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "expat.h"

Expat::Expat(QObject *parent, const char *name)
	: QObject( parent, name )
{
	parser = 0;
	init();
}

Expat::~Expat()
{
	cleanup();
}

void Expat::init()
{
	if (parser != 0)
		cleanup();

	parser = XML_ParserCreate( NULL );
 	XML_SetElementHandler(parser, startElement, endElement);
	XML_SetCharacterDataHandler(parser, charData);
	XML_SetUserData(parser, (void *)this);

	rootRecieved = false;
}

void Expat::cleanup()
{
	if (parser == 0)
		return;

	XML_ParserFree( parser );
	parser = 0;

	// Empty these out
	unsigned int i;
	for(i=0; i<newNodes.count(); i++)
		newNodes.take(i);

	while( !fillingNodes.isEmpty() )
		fillingNodes.pop();
}

void Expat::reset()
{
	cleanup();
	init();
}

void Expat::parse(QString data)
{
 	if (!XML_Parse( parser, (const char *)data, data.length(), false ))
 	{
 		parserError( XML_ErrorString(XML_GetErrorCode(parser)), XML_GetCurrentLineNumber(parser));
 		cleanup();
 		return;
 	}

 	// Send out any new tags
 	while (newNodes.count() > 0)
		recievedTag( newNodes.take( 0 ) );
}

void Expat::recievedTag( XMLNode *n)
{
 	printf("Recieved tag:\n");
 	XMLNode::printXML( n );
}

void Expat::rootTagRecieved(XMLNode *n)
{
	printf("Recieved root tag:\n");
	XMLNode::printXML( n );
}

void Expat::rootTagEnded()
{
	printf("Root tag ended.\n");
}

void Expat::parserError( QString errorMsg, int line )
{
	printf("Expat parser error: %s at %d\n", (const char *)errorMsg, line);
}






void Expat::startElement(void *userData, const XML_Char *name, const XML_Char **atts)
{
	/* get the userdata into a usable form */
	Expat *me = (Expat *)userData;

	/* New tag? Well...create one */
	XMLNode *t = new XMLNode( name );

	/* now put on it's parameters */
	int i=0;
	if (atts != NULL)
	{
		while (atts[i] != '\0')
		{
			t->setAttribute( QString::fromUtf8( atts[i] ), QString::fromUtf8( atts[i+1] ) );
			i+=2;
		}
	}

	if( !me->rootRecieved )
	{
		// This is the first tag...therefore the root tag.
		me->rootTagRecieved(t);
		me->rootRecieved = true;
		return;
	}


	/* Register it as a sub tag of the previous tag */
	if (!me->fillingNodes.isEmpty())
		me->fillingNodes.top()->addChildNode(t);

	/* push this node onto the stack */
	me->fillingNodes.push( t );
}

void Expat::endElement(void *userData, const XML_Char *)
{
	/* get the userdata into a usable form */
	Expat *me = (Expat *)userData;

	if (me->fillingNodes.isEmpty())
	{
		// If this is 0 then this is the end of the root tag...
		me->rootTagEnded();
		return;
	}

	if (me->fillingNodes.count() == 1)
	{
		// We used to send them right out from here...but I found out something very nasty can
		// happen...suppose that the parser is deleted because of this node (login error...)
		me->newNodes.append( me->fillingNodes.top() );

		// We do not delete the node becuse that job belongs to
		// whoever overrid the revieced tag
	}
	me->fillingNodes.pop();
}

void Expat::charData(void *userData, const char *s, int len)
{
	/* get the userdata into a usable form */
	Expat *me = (Expat *)userData;

	if (me->fillingNodes.isEmpty())
	{
		// If this is 0 then this is the data of the root tag...
		return;
	}

	char *data;
	data = new char[len + 1];
	memcpy(data, s, len);
	data[len] = '\0';
        QString cleanData = QString::fromUtf8( data );

 	QString currValue = me->fillingNodes.top()->getValue();
 	if (currValue.isNull())
 		currValue = cleanData;
 	else
 		currValue.append(cleanData);

	me->fillingNodes.top()->setValue(currValue);

	delete data;
}
