#include <dlgchat.h>
/***************************************************************************
                          dlgchat.cpp  -  description
                             -------------------
    begin                : Sat Oct 2 1999
    copyright            : (C) 1999 by Seth Hartbecke
                                (C) 2000-2001 Jerome Lalande
    email                : jerome_lalande@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "dlgchat.h"

#include <qsplitter.h>
#include <jabbercore.h>
#include <user.h>
#include <userpresence.h>



DlgChat::DlgChat(QWidget *parent, const char * )
	: KMainWindow(parent, "Konverse chat" )
        , MessageReciever( )
{

        setIcon( KGlobal::iconLoader()->loadIcon("chat_dlg", KIcon::User) );
        _chat = new KPopupMenu( this, "chatmenu" );
        menuBar()->insertItem( "&Chat", _chat );
       //TODO: Enable for version 0.3  _chat->insertItem( "&Show VCard" );
        //TODO: Enable for version 0.3 _chat->insertSeparator();
        _chat->insertItem( "&Preferences", this, SLOT(showPrefs()) );
        _chat->insertSeparator();
        _chat->insertItem( "&Close", this, SLOT(closeClicked()) );

        //Layout management
        centralWidget = new QWidget ( this, "chat_central_widget");
        setCentralWidget (centralWidget);

        layout = new QGridLayout ( centralWidget, 2, 1, 0, 0, "Chat Window Main Layout" );
        _split = new QSplitter( centralWidget , "split" );
	   _split->setOrientation( QSplitter::Vertical );
	
        layout->setMenuBar ( menuBar ( ));
        layout->addWidget ( _split , 0, 0 );
        btnLayout = new QGridLayout ( NULL, 1, 3, 0, 0, "Chat Window Button Layout");
        layout->addLayout (btnLayout, 1, 0 );

        layout->activate ( );


	// Setup the top half
	conversation = new ConversationView( _split, "Conversation view");

	stuffToSay = new WrapEdit( _split, "What they want to say");
	stuffToSay->setMinimumSize( stuffToSay->minimumSizeHint().width(), stuffToSay->font().pixelSize()+5 );
	stuffToSay->setFocus();

	_split->setResizeMode( stuffToSay, QSplitter::FollowSizeHint );

	setCaption("A chat with a person");

	QSplitter::connect( stuffToSay, SIGNAL(ctlEnter()), this, SLOT(sendClicked()) );

        QSplitter::connect( jabber, SIGNAL(connected()), this, SLOT(myConnectionChanged()) );
        QSplitter::connect( jabber, SIGNAL(disconnected()), this, SLOT(myConnectionChanged()) );

        //Send and close buttons
        btnSend = new KPushButton ("Send", centralWidget);
        btnClose = new KPushButton ("Close", centralWidget);
        btnLayout->addWidget ( btnSend, 0, 1 );
        btnLayout->addWidget ( btnClose, 0, 2 );
        connect (btnSend, SIGNAL (clicked ( )), this, SLOT (sendClicked ( )));
        connect (btnClose, SIGNAL (clicked ( )), this, SLOT (closeClicked ( )));


	stuffToSay->show();
	conversation->show();
        resize( 400, 300 );
        setFrameBorderWidth( 5 );

        _otherGuy = 0;

	setType( "chat" );
}

DlgChat::~DlgChat()
{/*
   delete layout;
   delete btnLayout;
   delete _split;*/
}

void DlgChat::setJID(JabberID &newTo)
{
        MessageReciever::setJID( newTo );

        QString newCaption;

        User *otherGuy = jabber->getUser( newTo.getNode() + "@" + newTo.getDomain() );
        if  ( otherGuy == 0 )
        {
                // JabberCore does not know this user
                newCaption.sprintf("A chat with %s", (const char *)newTo.getJID());
        }
        else
        {
                QString name = otherGuy->getRealName();
                newCaption.sprintf("A chat with %s (%s)", (const char *)name, (const char *)newTo.getJID());
                if ( _otherGuy == 0 )
                        connect( otherGuy, SIGNAL(presenceChanged(User *, UserPresence *)), this, SLOT(presenceChanged( User *, UserPresence *)) );
                _otherGuy = otherGuy;
        }
        setCaption(newCaption);

}

void DlgChat::newPacket(XMLNode *t)
{
        JabberID jid; jid = t->getAttribute("from");
        QString searchBy;
        User *u;
        QString realname;

        /* This stuff should be in jabbercore, because I can think of at least
           two other places where I have this same code */
        // This just strips off the anything after the slash on the jid
        searchBy.sprintf("%s@%s", (const char *)jid.getNode(), (const char *)jid.getDomain() );

        if ( (u = jabber->getUser( searchBy )) != 0)
                realname = u->getRealName();
        else
                realname = t->getAttribute("from");

        QDateTime when;
        when.setTime_t( time( 0 ) );

        /* See if we can find a timestamp */
        int i;
        for( i=0; i<t->numberChildNodes(); i++ )
        {
                if ( t->getChildNode( i )->getName() == "x" )
                {
                        if ( t->getChildNode( i )->getAttribute( "xmlns" ) == "jabber:x:delay" )
                        {
                                /* Found one! */
                                QString txtWhen = t->getChildNode( i )->getAttribute( "stamp" );
                                when = JabberCore::convertFromJabberTime( txtWhen );
                        }
                }
        }


	conversation->addLine( when, t->getChildNode("body")->getValue(), realname, "blue" );

        setJID( jid );
        setThread( t->getChildNode("thread")->getValue() );
}

void DlgChat::sendClicked()
{
	if (!stuffToSay->text().isEmpty())
	{
		XMLNode *t = new XMLNode();
		t->setName("message");
		t->setAttribute("to", getJID().getJID() );
		t->setAttribute("type", "chat");

		if (!thread().isEmpty())
			t->getChildNode("thread")->setValue(thread());

		t->getChildNode("body")->setValue(stuffToSay->text());

                QDateTime when;
                when.setTime_t( time( 0 ) );
		conversation->addLine( when, stuffToSay->text(), jabber->whoAmI().getNode(), "red" );

		jabber->sendTag(*t);
		delete t;

		stuffToSay->setText("");
	}
}


void DlgChat::closeEvent(QCloseEvent *)
{
 	delete this;
}

void DlgChat::closeClicked()
{
	delete this;
}

void DlgChat::presenceChanged( User *, UserPresence *p )
{
	if (p->resourceName() == getJID().getResource()
           || getJID().getResource().isEmpty() )
        {
         	QString text = _otherGuy->getRealName();

                switch( p->getShow() )
                {
                	case JabberCore::Chat:
                        	text.append(" is wanting to chat");
                                break;
                	case JabberCore::Normal:
                        	text.append(" is online");
                                break;
                	case JabberCore::Away:
                        	text.append(" is away");
                                break;
                	case JabberCore::ExtendedAway:
                        	text.append(" is extended away");
                                break;
                	case JabberCore::DND:
                        	text.append(" does not want to be disturbed:");
                                break;
                	case JabberCore::Offline:
                        	text.append(" is offline");
                                break;
                	case JabberCore::Unknown:
                        	text.append(" is online");
                                break;
                 }

                 text.append(": ");
                 text.append( p->status() );

                 QDateTime when;
                 when.setTime_t( time( 0 ) );
                 conversation->systemAnnouncement( when, text, "#808080" );
        }
}

void DlgChat::myConnectionChanged()
{
        QDateTime when;
        when.setTime_t( time( 0 ) );

	if( jabber->isConnected() )
  		conversation->systemAnnouncement( when, "You are online", "#808080" );
    	else
        	conversation->systemAnnouncement( when, "You are offline", "red" );
}

void DlgChat::showPrefs()
{
        jabber->prefs()->showPrefsDialog( "chat" );
}


