/*******************************************************************************
**                       configurationdlg.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef CONFIGURATIONDLG_H
#define CONFIGURATIONDLG_H

// Qt includes
#include <qdict.h>

// My includes
#include "configurationdlgbase.h"
#include "profilemngrinterface.h"

class QListBoxItem;

////////////////////////////////////////////////////////////////////////////////
///////               class ConfigurationDlg                             ///////
////////////////////////////////////////////////////////////////////////////////

class ConfigurationDlg : public ConfigurationDlgBase,
                         public ProfileMngrInterface
{
    Q_OBJECT

public:
    ConfigurationDlg();
    ~ConfigurationDlg();

    void inserted( BackupProfile *b );
    void changed( BackupProfile *b );
    void removed( QString s );

signals:
    void backupActivated();

public slots:
    void slotUpdateUI( QListBoxItem* );
    void slotUpdateDict( QListBoxItem* );

    void slotDataModified();
    void slotDataModified( const QString& );
    void slotDataModified( int );
    void slotDataModified( bool );

    void slotSaveProfile();
    void slotSaveProfile( const QString& identifier );
    void slotRemoveProfile();
    void slotSaveToDeleteItem();
    void slotReset();
    void slotRestore();
    void slotClose();
    void slotAddIdentifierToDict();

private:
    void blockInputWidgetSignals();
    void unblockInputWidgetSignals();
    void setupDataModifyConnections();
    void setupActionConnections();
    void setupConfigKeditListBoxConnections();
    void setIdentifierBackup();
    QString& getIdentifierBackup();
    void setApplyOn( bool on );
    bool unsavedChanges();
    void saveChanges();
    void forgetChanges();

private:
/////////////////////////////////////////////////////////////////////////////
//////////               class MyBackupProfileInfo                  /////////
/////////////////////////////////////////////////////////////////////////////

    //
    // And off goes the Decorator (I think) pattern
    //

    class MyBackupProfileInfo
    {
        friend class ConfigurationDlgTest;

    public:
        MyBackupProfileInfo( BackupProfile* profile );
        ~MyBackupProfileInfo();

        bool modified();
        void modify( BackupProfile* profile );
        void discardChanges();
        void applyChanges();

        bool isActivated();
        KURL getSourceUrl();
        KURL getArchiveUrl();
        TimeInterval getTimeBetweenBackups();
        QString getIdentifier();

    private:
        MyBackupProfileInfo( const MyBackupProfileInfo& copy );
        MyBackupProfileInfo& operator=( const MyBackupProfileInfo& copy );

    private:
        bool           mbModified;
        BackupProfile* mpCurrentData;
        BackupProfile* mpOriginalData;
    };

private:
    bool                       mbProfileDictModified;
    QString                    msIdentifierBackup;
    QDict<MyBackupProfileInfo> mProfileDict;
};
#endif
