/***************************************************************************
 *   Copyright (C) 2005-2010 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATOREMPTYDIRECTORIESJOB_H_
#define _KOMPARATOREMPTYDIRECTORIESJOB_H_

#include <kio/job.h>

#include "komparatorjob.h"

class KomparatorEmptyDirectoryJob : public QObject
{
	Q_OBJECT

	public:
		KomparatorEmptyDirectoryJob( QWidget *_parent );
		virtual ~KomparatorEmptyDirectoryJob();

		bool initialize( KUrl::List *url_list, KUrl::List *file_list );

		void start();
		void stop();
		void run();

		const KUrl::List &getEmptyDirectoryList();

	signals:
		void emitEmptyFinished();
		void emitInteractionMessage( const QString &, const QString & );
		void emitInteractionProgress( const QString &, const int & );

	private slots:
		void slotFile( KIO::Job *job, const KIO::UDSEntryList &list );
		void slotFinished( KJob *job );

	private:
		KUrl::List m_url_list;
		KUrl::List m_search_list;
		KUrl::List m_empty_directory_list;
		KUrl::List m_file_list;
		
		bool m_canceled, m_initialized;

		void emitProgress( QString str, int percent );
		void emitMessage( const QString &message, const QString &title );

		QWidget *m_parent;

		int m_running;
		int m_progress;
		int m_total;
		QString m_status;

		void incrementProgress();
		bool isCanceled() { return m_canceled; };
};

#endif
