h36556
s 00052/00002/00117
d D 1.19 00/08/22 20:00:25 nitehawk 20 19
c Converting to new syslogish logging mechanism
cC
cHlocalhost.1ststep.net
cK12682
cZ-07:00
e
s 00000/00000/00119
d D 1.18 00/03/07 11:48:12 nitehawk 19 18
c Turn on SCCS flag
cC
cK34261
cX0xa1
e
s 00000/00000/00119
d D 1.17 00/02/12 10:04:30 nitehawk 18 17
c Rename: lib/log.c -> lib/koala/log.c
cC
cK30248
cPlib/koala/log.c
e
s 00000/00000/00119
d D 1.16 00/02/07 23:56:57 nitehawk 17 16
c Rename: src/log.c -> lib/log.c
cC
cK26269
cPlib/log.c
e
s 00004/00001/00115
d D 1.15 00/01/11 22:13:20 nitehawk 16 15
c Use confquerybackground to determine if we should reopen
c log files
cC
cK55171
e
s 00004/00000/00112
d D 1.14 00/01/11 22:03:23 nitehawk 15 14
c Add fflush to end of each logging function to force data
c out to disk
cK45056
e
s 00002/00002/00110
d D 1.13 00/01/11 12:27:32 nitehawk 14 13
c Converted RCS tags to SCCS tags
cC
cK32169
e
s 00003/00003/00109
d D 1.12 00/01/01 16:46:51 nitehawk 13 12
c Coverted loginit to use filenames passed in
cC
cK37706
e
s 00011/00002/00101
d D 1.11 99/12/30 09:55:29 nitehawk 12 11
c Added logpreinit to assign 'standard' handles for logging
cC
cK37363
e
s 00010/00014/00093
d D 1.10 99/12/29 21:31:54 nitehawk 11 10
c Converted logging to use fprintf
cC
cK16091
cZ-08:00
e
s 00017/00009/00090
d D 1.9 99/12/20 06:59:10 nitehawk 10 9
c Commented functions
c No longer reopen logs if we are running in foreground
c Fixed logverbose
cC
cK29209
e
s 00002/00002/00097
d D 1.8 99/12/20 06:05:08 nitehawk 9 8
c Change loggingstatus initialization to use stdout and stderr
cK62601
e
s 00011/00016/00088
d D 1.7 99/12/19 17:58:47 nitehawk 8 7
c Fixed log file opening.
c Converted to dprintf for logging output.
cC
cK60758
e
s 00006/00003/00098
d D 1.6 99/12/19 17:57:55 nitehawk 7 6
c Only open log files if we are spawning into the background.
cK21113
e
s 00032/00012/00069
d D 1.5 99/12/19 17:56:45 nitehawk 6 5
c Added global 'loggingstatus' to track logfile handles
c Added loginit to open log files
c Converted logging functions to use loggingstatus handles
cK17919
e
s 00007/00007/00074
d D 1.4 99/12/15 00:01:57 nitehawk 5 4
c fixing header.
cC
cK27447
e
s 00036/00002/00045
d D 1.3 99/12/14 05:42:07 nitehawk 4 3
c added logdbg and logverbose functions
cC
cK27853
e
s 00008/00004/00039
d D 1.2 99/12/14 05:38:14 nitehawk 3 2
c Changed handling to use write and the explicit file handles
cK29075
e
s 00043/00000/00000
d D 1.1 99/12/14 05:37:19 nitehawk 2 1
cF1
cK16358
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 99/12/14 05:37:19 nitehawk 1 0
c BitKeeper file /home/nitehawk/src/koalamud/src/log.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK53634
cPsrc/log.c
cR35ba47fc1c17b3df
cV3
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 3
/* $Id: log.c,v 1.1 1999/11/27 07:34:17 nitehawk Exp $ */
E 3
I 3
D 4
/* $Id: log.c,v 1.2 1999/11/27 20:55:21 nitehawk Exp $ */
E 4
I 4
D 5
/* $Id: log.c,v 1.3 1999/12/04 04:25:09 nitehawk Exp $ */
E 5
I 5
D 14
/* $Id: log.c,v 1.4 1999/12/08 05:12:26 nitehawk Exp $ */
E 14
I 14
/* %Z% %M% %I% %Z% */
E 14
E 5
E 4
E 3
/***************************************************************\
D 5
*	Copyright (c) 1999 First Step Internet Services, Inc.	*
*		All Rights Reserved				*
*	Distributed under the BSD Licenese			*
*								*
*	Module: CORE						*
E 5
I 5
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
E 5
\***************************************************************/

D 3
#define _KOALAMUD_LOG_C "$Id: log.c,v 1.1 1999/11/27 07:34:17 nitehawk Exp $"
E 3
I 3
D 4
#define _KOALAMUD_LOG_C "$Id: log.c,v 1.2 1999/11/27 20:55:21 nitehawk Exp $"
E 4
I 4
D 5
#define _KOALAMUD_LOG_C "$Id: log.c,v 1.3 1999/12/04 04:25:09 nitehawk Exp $"
E 5
I 5
D 14
#define _KOALAMUD_LOG_C "$Id: log.c,v 1.4 1999/12/08 05:12:26 nitehawk Exp $"
E 14
I 14
#define _KOALAMUD_LOG_C "%Z% %K% %Z%"
E 14
E 5
E 4
E 3

#include "autoconf.h"
I 8
#include <sys/stat.h>
E 8

#include "version.h"
#include "koalatypes.h"
I 6
#include "log.h"
I 16
#include "conf.h"
E 16

/* globals */
logging_status loggingstatus =  {
	FALSE,  // Uninitialized
D 9
	-1,   /* Rest is filehandles */
	-1,
E 9
I 9
D 11
	STDOUT_FILENO,   /* Rest is filehandles */
	STDERR_FILENO,
E 11
I 11
D 12
	stdout,   /* Rest is filehandles */
	stderr,
E 12
I 12
	NULL,   /* Rest is filehandles */
	NULL,
I 20
	NULL,
E 20
E 12
E 11
E 9
};
E 6

I 20
char *pritags[] =
{
	"%LOGMSG-EMERGENCY%",
	"%LOGMSG-ALERT%",
	"%LOGMSG-CRITICAL%",
	"%LOGMSG-ERROR%",
	"%LOGMSG-WARNING%",
	"%LOGMSG-NOTICE%",
	"%LOGMSG-INFO%",
	"%LOGMSG-DEBUG%",
};

/* Log messages - Eventually convert into syslog wrapper */
void logmsg(logmsgpri priority, char *format, ...)
{
	time_t curtime;
	struct tm *loctime;
	char buf[MAXLOGLINELEN+5];
	va_list ap;

	/* Error check */
	if (priority < LOGEMERG || priority > LOGDEBUG || format == NULL)
	{
		return;
	}

	/* Build and write the timestamp */
	curtime = time(NULL);
	loctime = localtime(&curtime);
	snprintf(buf, sizeof(buf), "[%04d/%02d/%02d %02d:%02d:%02d] %s ",
			1900+loctime->tm_year, loctime->tm_mon, loctime->tm_mday,
			loctime->tm_hour, loctime->tm_min, loctime->tm_sec,
			pritags[priority]);
	fprintf(loggingstatus.handle, "%s", buf);

	/* Build a string to output */
	va_start(ap, format);
	(void) vsnprintf(buf, sizeof(buf), format, ap);
	va_end(ap);

	fprintf(loggingstatus.handle, "%s\r\n", buf);
	fflush(loggingstatus.handle);

}

E 20
I 10
/* log a standard message */
I 20
/*
E 20
E 10
void logmsg(char *msg)
{
D 11
	char timestamp[15] = {'\0'};
E 11
I 11
	char timestamp[] = "[00:00:00] \0";
E 11
	time_t curtime;
	struct tm *loctime;

	curtime = time(NULL);
	loctime = localtime(&curtime);
D 8
	sprintf(timestamp, "[%02d:%02d:%02d] ", loctime->tm_hour,
E 8
I 8
	sprintf(timestamp, "[%02d:%02d:%02d]", loctime->tm_hour,
E 8
			loctime->tm_min, loctime->tm_sec);

D 3
	fprintf(stdout, "%s%s\r\n", timestamp, msg);
E 3
I 3
D 6
	write(STDOUT_FILENO, timestamp, strlen(timestamp));
	write(STDOUT_FILENO, msg, strlen(msg));
	write(STDOUT_FILENO, "\r\n", 2);
E 6
I 6
D 8
	write(loggingstatus.msghandle, timestamp, strlen(timestamp));
	write(loggingstatus.msghandle, msg, strlen(msg));
	write(loggingstatus.msghandle, "\r\n", 2);
E 8
I 8
D 11
	dprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
E 11
I 11
	fprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
I 15
	fflush(loggingstatus.msghandle);
E 15
E 11
E 8
E 6
E 3
}
I 20
*/
E 20

I 10
/* Log an error message */
E 10
void logerr(char *msg)
{
	char timestamp[] = "[00:00:00] ERROR: \0";
	time_t curtime;
	struct tm *loctime;

	curtime = time(NULL);
	loctime = localtime(&curtime);
	sprintf(timestamp, "[%02d:%02d:%02d] ERROR: ", loctime->tm_hour,
			loctime->tm_min, loctime->tm_sec);

D 3
	fprintf(stdout, "%s%s\r\n", timestamp, msg);
E 3
I 3
D 6
	write(STDERR_FILENO, timestamp, strlen(timestamp));
	write(STDERR_FILENO, msg, strlen(msg));
	write(STDERR_FILENO, "\r\n", 2);
E 6
I 6
D 8
	write(loggingstatus.errhandle, timestamp, strlen(timestamp));
	write(loggingstatus.errhandle, msg, strlen(msg));
	write(loggingstatus.errhandle, "\r\n", 2);
E 8
I 8
D 11
	dprintf(loggingstatus.errhandle, "%s %s\r\n", timestamp, msg);
E 11
I 11
	fprintf(loggingstatus.errhandle, "%s %s\r\n", timestamp, msg);
I 15
	fflush(loggingstatus.errhandle);
E 15
E 11
E 8
E 6
I 4
}

I 10
/* Log a debug message if compiled with --enable-debug */
E 10
void logdbg(char *msg)
{
#if DEBUG
D 10
	char timestamp[15] = {'\0'};
E 10
I 10
	char timestamp[] = "[00:00:00] DEBUG: \0";
E 10
	time_t curtime;
	struct tm *loctime;

	curtime = time(NULL);
	loctime = localtime(&curtime);
D 10
	sprintf(timestamp, "[%02d:%02d:%02d] ", loctime->tm_hour,
E 10
I 10
	sprintf(timestamp, "[%02d:%02d:%02d] DEBUG: ", loctime->tm_hour,
E 10
			loctime->tm_min, loctime->tm_sec);

D 6
	write(STDOUT_FILENO, timestamp, strlen(timestamp));
	write(STDOUT_FILENO, msg, strlen(msg));
	write(STDOUT_FILENO, "\r\n", 2);
E 6
I 6
D 8
	write(loggingstatus.msghandle, timestamp, strlen(timestamp));
	write(loggingstatus.msghandle, msg, strlen(msg));
	write(loggingstatus.msghandle, "\r\n", 2);
E 8
I 8
D 11
	dprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
E 11
I 11
	fprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
I 15
	fflush(loggingstatus.msghandle);
E 15
E 11
E 8
E 6
#endif
}

I 10
/* Log a standard message if the verbosity level is above the specified level */
E 10
void logverbose(char *msg, int level)
{
D 11
	char timestamp[15] = {'\0'};
E 11
I 11
	char timestamp[] = "[00:00:00] \0";
E 11
	time_t curtime;
	struct tm *loctime;

D 10
	curtime = time(NULL);
	loctime = localtime(&curtime);
	sprintf(timestamp, "[%02d:%02d:%02d] ", loctime->tm_hour,
			loctime->tm_min, loctime->tm_sec);
E 10
I 10
	if (level >= koptions.verbosity)
	{
		curtime = time(NULL);
		loctime = localtime(&curtime);
		sprintf(timestamp, "[%02d:%02d:%02d] ", loctime->tm_hour,
				loctime->tm_min, loctime->tm_sec);
E 10

D 6
	write(STDOUT_FILENO, timestamp, strlen(timestamp));
	write(STDOUT_FILENO, msg, strlen(msg));
	write(STDOUT_FILENO, "\r\n", 2);
E 6
I 6
D 8
	write(loggingstatus.msghandle, timestamp, strlen(timestamp));
	write(loggingstatus.msghandle, msg, strlen(msg));
	write(loggingstatus.msghandle, "\r\n", 2);
E 8
I 8
D 10
	dprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
E 10
I 10
D 11
		dprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
E 11
I 11
		fprintf(loggingstatus.msghandle, "%s %s\r\n", timestamp, msg);
I 15
		fflush(loggingstatus.msghandle);
E 15
E 11
	}
E 10
E 8
}

/* loginit - Initialize logging - Open disk logging files */
D 10

E 10
D 13
koalaerror loginit(void)
E 13
I 13
koalaerror loginit(char *outfname, char *errfname)
E 13
{
D 7
	loggingstatus.msghandle = open(koptions.logpath, O_CREAT | O_NOCTTY
E 7
I 7
D 8
	if (koptions.spawnbackground)
E 8
I 8
D 10
	if (!loggingstatus.initialized)
E 10
I 10
	/* Don't reopen things if we are not spawning to background
	 * or we already opened the logs */
D 16
	if (koptions.spawnbackground && !loggingstatus.initialized)
E 16
I 16
	if ((((koptions.spawnbackground == 1) && confquerybackground()) ||
			((koptions.spawnbackground != 1) && koptions.spawnbackground))
			&& !loggingstatus.initialized)
E 16
E 10
E 8
	{
D 11
		loggingstatus.msghandle = open(koptions.logpath, O_CREAT | O_NOCTTY
E 7
D 8
					| O_APPEND | O_NONBLOCK);
E 8
I 8
			| O_APPEND | O_NONBLOCK | O_RDWR, S_IRUSR | S_IWUSR | S_IRGRP
			| S_IWGRP);
E 8
D 7
	loggingstatus.errhandle = open(koptions.errlogpath, O_CREAT | O_NOCTTY
E 7
I 7
		loggingstatus.errhandle = open(koptions.errlogpath, O_CREAT | O_NOCTTY
E 7
D 8
					| O_APPEND | O_NONBLOCK);
E 8
I 8
			| O_APPEND | O_NONBLOCK | O_RDWR, S_IRUSR | S_IWUSR | S_IRGRP
			| S_IWGRP);
E 11
I 11
D 13
		loggingstatus.msghandle = fopen(koptions.logpath, "a+");
		loggingstatus.errhandle = fopen(koptions.errlogpath, "a+");
E 13
I 13
D 20
		loggingstatus.msghandle = fopen(outfname, "a+");
		loggingstatus.errhandle = fopen(errfname, "a+");
E 20
I 20
		loggingstatus.handle = fopen(outfname, "a+");
		loggingstatus.msghandle = loggingstatus.handle;
		loggingstatus.errhandle = loggingstatus.handle;
E 20
E 13
E 11
E 8
D 7
	loggingstatus.initialized = TRUE;
E 7
I 7
		loggingstatus.initialized = TRUE;
	}
I 12
	return KESUCCESS;
}

/* logpreinit - This should be the first function called.
 * 	Initialized logging handles to point to stdout and stderr */
koalaerror logpreinit(void)
{
I 20
	loggingstatus.handle = stdout;
E 20
	loggingstatus.msghandle = stdout;
	loggingstatus.errhandle = stderr;
E 12
E 7
	return KESUCCESS;
E 6
E 4
E 3
}
E 2
I 1
E 1
