/***************************************************************************
                          knutmessage.cpp  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutmessage.h"
#include <kglobal.h>
#include <kiconloader.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qtimer.h>


KNutMessage::KNutMessage(const QString messageText, const typeOfMessage type, const long int timeValidity, QWidget *parent, const char *name) : KDialogBase(Plain, "Messages",Ok,Ok, parent, name, false, false) {


  setCaption("KNutClient");
  m_messageTimer = 0;
  KIconLoader *loader = KGlobal::iconLoader();

  switch(type) {
    case infoMess:
       m_ret = loader->loadIcon("messagebox_info", KIcon::NoGroup, KIcon::SizeMedium, KIcon::DefaultState, 0, true);
       break;
    case warningMess:
       m_ret = loader->loadIcon("messagebox_warning", KIcon::NoGroup, KIcon::SizeMedium, KIcon::DefaultState, 0, true);
       break;
    case criticalMess:
       m_ret = loader->loadIcon("messagebox_critical", KIcon::NoGroup, KIcon::SizeMedium, KIcon::DefaultState, 0, true);
       break;
    }

   QFrame *page = plainPage();

   QVBoxLayout *setTopLayout =     new QVBoxLayout( page, 10, spacingHint(), "setTopLayout" );
   QHBoxLayout *setMessageLayout = new QHBoxLayout( setTopLayout, spacingHint(), "setMessageLayout" );

   QLabel* picture = new QLabel (page);
   QLabel* text = new QLabel (messageText,page);
   picture->setPixmap(m_ret);

   setMessageLayout->addWidget(picture);
   setMessageLayout->addWidget(text);

   if (timeValidity > 0 ) {
     m_messageTimer = new QTimer(this);
     if (timeValidity > maxTime)
       m_messageTimer->start(maxTime*1000);
     else
       m_messageTimer->start(timeValidity*1000);
     connect (m_messageTimer,SIGNAL(timeout()),this,SLOT(timeout()));
     disableResize();
    }
  }

KNutMessage::~KNutMessage(){
  }

void KNutMessage::timeout(void) {

  if (m_messageTimer) m_messageTimer->stop();

  emit endMessage();
  }


void KNutMessage::slotOk (void) {

  if (m_messageTimer) m_messageTimer->stop();
  emit endMessage();
  }

void KNutMessage::moveEvent ( QMoveEvent * e) {

  KDialogBase::moveEvent (e);
  emit messageMoved(x(),y());
}


#include "knutmessage.moc"
