/***************************************************************************
                          knutfrontpanel.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTFRONTPANEL_H
#define KNUTFRONTPANEL_H

#include <qframe.h>
//#include <qlabel.h>
//#include <qcolor.h>
//#include <qlcdnumber.h>
//#include <qpalette.h>
//#include <qfont.h>
//#include <qlayout.h> 

namespace knc {

const int DefaultPanelFlags = 1615; //1+2+4+8+64+512+1024

enum panelBulb {
  PBOnLine = 1, // Panel Bulb On Line
  PBOnBatt = 2, // Panel Bulb On Battery
  PBOver = 4,    // Panel Bulb Overloading
  PBBattLow = 8,    // Panel Bulb Battery Low
  PBRepBatt = 16,    // Panel Bulb Replace Battery
  PBCal = 32,    // Panel Bulb Calibration
  PBMFRMod = 64,    // FRM + Model
  PBMFR = 128,    // FRM
  PBModel = 256,    // Model
  PBSerial = 512,    // Serial
  PBFirm = 1024,    // Firmware Revision
  PBRun=2048    // Panel LCD Number Runtime
  };
}


/**
  *@author Daniel Prynych
  */


class QFont;
class QPalette;
class QColor;
class QLCDNumber;
class QLabel;
class QVBoxLayout;
class QHBoxLayout;

  
/** Trida slouzi pro zobrazeni panelu, ktery zobrazuje informace o UPS.
 *
 * @author Daniel Prynych
 * @short Hlavni panel
 * @version 0.4.0
 */
class KNutFrontPanel : public QFrame  {
  Q_OBJECT
  public:

/**
 * Konstruktor - vytvori panel, ktery zobrazuje stav UPS-ky.
 *
 * @param flags Udava ktere casti se maji na panelu zobrazit.
 * @param panelFonts Odkaz na fonts ktery se ma pouzit pro vykreslovani, pokud je = 0 pouzije se systemovy font pri aplikaci.
 * @since  0.7
 */
  KNutFrontPanel( QPalette* const paletteIn, QWidget *parent = 0, const unsigned int flags = knc::DefaultPanelFlags, QFont* const panelFonts = 0L ,const char *name = 0);

/**
 * Destruktor
 *
 * @since  0.3
 */
  ~KNutFrontPanel();


/**
 * Vykresli na panelu udaje.
 *
 * @since  0.4
 */
 void paintPanel( void);

/**
 * Vrati vysku panelu.
 * Ve verzi 0.4 je vracena vzdy 0. !!!!!!
 * Version 0.4 always gets 0 !!!!!!!!!!!
 *
 * @since  0.4
 */
 int getPanelHeight( void);

/**
 * Vrati nastaveni panelu.
 *
 * @since  0.2
 */
 unsigned int getPanelFlags( void);

/**
 * Vykresli na panelu udaje.
 *
 * @param height udava vysku panelu.
 *
 * @since  0.2
 */
 void setPanelFlags(const int upsPanelFlags);

/**
 * Zobrazi na panelu jmeno UPS-ky.
 *
 * @param upsPanelName Text ktery se zobrazi na panelu (adresa UPS-ky).
 *
 * @since  0.2
 */
	void setAllNameUps(const QString panelUpsAllName);

/**
 * Zobrazi na panelu jmeno UPS-ky.
 *
 * @param upsPanelName Text ktery se zobrazi na panelu (adresa UPS-ky).
 *
 * @since  0.3
 */
  void setNameUps(const QString panelUpsName );

/**
 * Zobrazi na panelu jmeno vyrobce UPS-ky.
 *
 * @param panelUpsFRM Text ktery se zobrazi na panelu (adresa UPS-ky).
 *
 * @since  0.2
 */
  void setMFRUps(const QString panelUpsFRM );

/**
 * Zobrazi na panelu seriove cislo UPS-ky.
 *
 * @param panelUpsSerial Text ktery se zobrazi na panelu (seriove cislo UPS-ky).
 *
 * @since  0.2
 */
  void setSerialUps(const QString panelUpsSerial );

/**
 * Zobrazi na panelu verzi firmwaru cislo UPS-ky.
 *
 * @param upsPanelFormRev Text ktery se zobrazi na panelu (verze firmwaru UPS-ky).
 *
 * @since  0.2
 */
  void setFirmRevUps(const QString upsPanelFormRev );

/**
 * Zhasne indikacni prvky na panelu.
 *
 * @since  0.4
 */
  void cleanPanel(void);

/**
 * Rozsviti indikacni prvky na panelu.
 *
 * @param panelBulbs Kod pro urceni rozsvicenych indikacnich prvku.
 *
 * @since  0.4
 */
  void setPanel(const int panelBulbs);


/**
 * Nastavi hodnotu runtime.
 *
 * @param Runtime hodnota ktera se zobrazi jako runtime.
 *
 * @since  0.4
 */
 void setRuntime(const int runtime);

/**
 * Nastavi Paletu (palette). Predefinovana funkce from QWidget.
 *
 * @param Paleta kterou ma byt vykreslen hlavni panel
 *
 * @since  0.1
 */
 void setPalette (const QPalette & );

  public slots:

/**
 * Zmeni font pro vykresleni.
 *
 * @param panelFonts Novy font.
 *
 * @since  0.2
 */
  void slotSetPanelFont(QFont newPanelFont);

  private:

/**
 * @internal
 * Nastavi palety pro LCDPabel.
 *
 * @since  0.1
 */
  void setLCDPalette (void);

/**
 * @internal
 * Provede zmenu paletty vsech prvku na zaklade promenne myPalette
 *
 * @since  0.1
 */
  void setAllPalettes (void);

  void changePanelFont (void);


  static const int PanelTextTop = 8;
  static const int PanelTextBottom = 4;
  static const int PanelTextHigh = 25;

  QLabel* textLabel1;
  QLabel* textLabel2;
  QLabel* textLabel3;
  QLabel* textLabel4;
  QLabel* textLabel5;
  QLabel* textLabel6;
  QLabel* textLabel7;
  QLabel* textLabel8;
  QLabel* textLabel9;
  QLabel* textLabel10;
  QLabel* textLabel11;

  QLabel* textLabelManufac;
  QLabel* textLabelName;
  QLabel* textLabelSerial;
  QLabel* textLabelFirm;
  QLabel* textLabelRun;


  QFrame* frameOL;
  QFrame* frameOB;
  QFrame* frameOVER;
  QFrame* frameLB;
  QFrame* frameRB;
  QFrame* frameCAL;

  QLCDNumber* LCDNumber1;
  QPalette LCDPaletteOk, LCDPaletteErr;

  QColor upsOk, upsError, upsBack;
  QColor bgColor; // barva pozadi panelu;

  QFont panelFont;        // font pro nadpis
  QFont panelBoldFont;    // font pro data

  unsigned int panelFlags; // urcuji ktera radka bude rozsvicena 1 OL, 2 OB, 3 OVER, 4 RB, CAL 5 ...

  QPalette myPalette;
  
  bool typeOfLCDColor;

  QVBoxLayout* mainLayout;
  
  QHBoxLayout* OLLayout;
  QHBoxLayout* OBLayout;
  QHBoxLayout* OLayout;
  QHBoxLayout* LBLayout;
  QHBoxLayout* RBLayout;
  QHBoxLayout* CALLayout;
  QHBoxLayout* manufacModelLayout;
  QHBoxLayout* manufacLayout;
  QHBoxLayout* nameLayout;
  QHBoxLayout* serialLayout;
  QHBoxLayout* firmLayout;
  QHBoxLayout* runLayout;
};

#endif

