/*
	Knowledgeroot
	Frank Habermann
	This file includes functions that are used to display and work with the ajaxtree
*/

	function AjaxMenuOpen(id,move) {
		ShowMessage(msgboxloading, "loading");
		var ajaxopen = new Ajax.Request(
			"ajax-xml.php",
			{
				method:'post',
				postBody: 'ajaxopen='+id+'&move='+move,
				onComplete:showOpen,
				onFailure:showError
			}
		);

		document.getElementById("menuimg_"+id).src = "images/minus.jpg";
		document.getElementById("linkid_"+id).onclick = function () { AjaxMenuClose(id,move); };
	}
	
	function AjaxMenuClose(id,move) {
			ShowMessage(msgboxloading, "loading");
			var ajaxopen = new Ajax.Request(
				"ajax-xml.php",
				{
					method:'post',
					postBody: 'ajaxclose='+id+'&move='+move,
					onComplete:showClose,
					onFailure:showError
				}
			);
		
			document.getElementById("menuimg_"+id).src = "images/plus.jpg";
			document.getElementById("linkid_"+id).onclick = function () { AjaxMenuOpen(id,move); };
	}
	
	var showOpen = function(r) {
		try {
			var root = r.responseXML.getElementsByTagName("root");

			if (document.all) {
				var data = unescape(r.responseXML.getElementsByTagName("html")[0].firstChild.nodeValue);
			} else {
				var data = unescape(root[0].getElementsByTagName("html")[0].textContent);
			}
			var id = root[0].getElementsByTagName("parentid")[0].firstChild.nodeValue;
			
			if(document.all) {
				// for IE
				new Insertion.Bottom('menu_'+id, data);
			} else {
				// for Mozi
				new Insertion.After('menu_'+id, data);
			}
			
			HideMessage("loading");
		} catch (e) {
			ShowMessage(e.message + "#" + e.name + "#" + e.number + "#" + e.file, "error");
			setTimeout("HideMessage()", 7000);
			//alert(e.message + "#" + e.name + "#" + e.number);
		}
	}
	
	var showClose = function(r) {
		try {
			var root = r.responseXML.getElementsByTagName("root");
			var elements = root[0].getElementsByTagName("element");

			for(var i=0; i<elements.length; i++) {
				var id = root[0].getElementsByTagName("element")[i].firstChild.data;
				//var node = document.getElementById("menu_"+id);
				//var temp = document.getElementById("menu_"+id).removeChild(node.firstChild);

				//Element.remove("menu_"+id);
				// extra function because fucking ie is so stupid
				removeElement("menu_"+id);
			}
			
			HideMessage("loading");
		} catch (e) {
			ShowMessage(e.message + "#" + e.name + "#" + e.number, "error");
			setTimeout("HideMessage()", 7000);
			//alert(e.message + "#" + e.name + "#" + e.number);
		}
	}
	
	var removeElement = function(id) {
		try {
			Element.remove(id);
		} catch (e) {
		
		}
	}
	
	var showError = function(r) {
		alert("Error: " + r.status + "/t" + r.statusText);
	}
	
	var ShowTree = function() {
		$("tree").style.display = "block";
		$("treeopener").style.display = "none";
	}
	
	var HideTree = function() {
		$("tree").style.display = "none";
		$("treeopener").style.display = "block"
	}
	
	var TreeFixed = function() {
		$("tree").style.position = "static";
		$("treeslide").style.display = "block";
		$("treefixed").style.display = "none";
	}
	
	var TreeSlide = function() {
		$("tree").style.position = "absolute";
		$("treeslide").style.display = "none";
		$("treefixed").style.display = "block";
	}
	
	var TreeExpand = function(move) {
		ShowMessage(msgboxloading, "loading");
		var ajaxopen = new Ajax.Request(
			"ajax-xml.php",
			{
				method:'post',
				postBody: 'expandtree=yes&move='+move,
				onComplete:showReloadTree,
				onFailure:showError
			}
		);
	}
	
	var TreeCollapse = function(move) {
		ShowMessage(msgboxloading, "loading");
		var ajaxopen = new Ajax.Request(
			"ajax-xml.php",
			{
				method:'post',
				postBody: 'collapsetree=yes&move='+move,
				onComplete:showReloadTree,
				onFailure:showError
			}
		);
	}
	
	var TreeReload = function(move) {
		ShowMessage(msgboxloading, "loading");
		var ajaxopen = new Ajax.Request(
			"ajax-xml.php",
			{
				method:'post',
				postBody: 'reloadtree=yes&move='+move,
				onComplete:showReloadTree,
				onFailure:showError
			}
		);
	}
	
	var showReloadTree = function(r) {
		try {
			var root = r.responseXML.getElementsByTagName("root");
			if (document.all) {
				var data = unescape(r.responseXML.getElementsByTagName("html")[0].firstChild.nodeValue);
			} else {
				var data = unescape(root[0].getElementsByTagName("html")[0].textContent);
			}

			Element.remove("treeelementtable");
			new Insertion.Top('treeelements', data);
			//alert(data);
			//$("treeanchor").nodeValue = data;
			
			HideMessage("loading");
		} catch (e) {
			ShowMessage(e.message + "#" + e.name + "#" + e.number, "error");
			setTimeout("HideMessage()", 7000);
		}
	}