<?php

/*
 * Knowledgeroot
 * Frank Habermann
 * GPL
 */

// get base url
$baseurl = $_SERVER[HTTP_HOST] . $_SERVER[PHP_SELF];
preg_match("/(.*\/).*/", $baseurl, $url_arr);

if($url_arr[1] == "") {
	$url_arr[1] = $_SERVER[HTTP_HOST];
}

// init session
session_name(md5($url_arr[1]));
session_start();

// load required files
require_once("include/class-tree.php");
require_once("include/function.php");
require_once("include/class-knowledgeroot.php");
require_once("include/fckeditor.php");
require_once("include/tinymce.php");
require_once("include/class-knowledgeroot-header.php");
require_once("include/class-knowledgeroot-content.php");
require_once("include/class-knowledgeroot-themes.php");
require_once("include/class-language.php");
require_once("include/class-email-notification.php");

// check for opera and konqueror
// this is a short fix beacause the ajaxtree does not work in opera and konqueror
if($CONFIG['menu']['ajax'] == "yes") {
	if(preg_match("/.*[Kk]onqueror.*/",$_SERVER['HTTP_USER_AGENT']) || preg_match("/.*[Oo]pera.*/",$_SERVER['HTTP_USER_AGENT'])) {
		$CONFIG['menu']['ajax'] = "no";
	}
}

// this is the variable where all classes are in
$CLASS = array();

// define global variables
$CLASS['vars'] = $CONFIG;

// load databaseclass
if($CLASS['vars']['db']['type'] == "mysql") {
	require_once("include/class-mysql.php");
}

if($CLASS['vars']['db']['type'] == "mysqli") {
	require_once("include/class-mysqli.php");
}

if($CLASS['vars']['db']['type'] == "pgsql") {
	require_once("include/class-pgsql.php");
}

if($KNOWLEDGEROOTDB != "PGSQL" && $KNOWLEDGEROOTDB != "MYSQL") {
	echo "WRONG DBTYPE SELECTED!\n";
	exit();
}

// init language
$CLASS['language'] = new language();
$CLASS['language']->start($CLASS,$CLASS['vars']['knowledgeroot']['language']);

// init databaseclass
$CLASS['db'] = new db();

// connect to database
$CLASS['db']->connect($CLASS['vars']['db']['host'],$CLASS['vars']['db']['user'],$CLASS['vars']['db']['pass'],$CLASS['vars']['db']['database'],$CLASS['vars']['db']['schema'],$CLASS['vars']['db']['encoding']);

// init email notification class
$CLASS['notification'] = new knowledgeroot_notification($CLASS);

// init knowledgerootclass
$CLASS['knowledgeroot'] = new knowledgeroot();
$CLASS['knowledgeroot']->start($CLASS);

// addslashes on GET/POST
$CLASS['knowledgeroot']->addSlashesOnArray($_GET);
$CLASS['knowledgeroot']->addSlashesOnArray($_POST);

// here comes the stuff of index.php

// init tree
$CLASS['tree'] = new categoryTree();
$CLASS['tree']->start($CLASS);

// init tree_path
$CLASS['path'] = new pathTree();
$CLASS['path']->start($CLASS);

// init header
$CLASS['kr_header'] = new knowledgeroot_header();
$CLASS['kr_header']->start($CLASS);

// init content
$CLASS['kr_content'] = new knowledgeroot_content();
$CLASS['kr_content']->start($CLASS);

// check header variables
$CLASS['kr_header']->check_vars();

// check if site is a download
$CLASS['kr_header']->check_download();

// init themes
$CLASS['themes'] = new knowledgeroot_themes();
$CLASS['themes']->start($CLASS,$CLASS['vars']['knowledgeroot']['default_theme']);

// init fckeditor
$CLASS['oFCKeditor'] = new FCKeditor('content');
$CLASS['oFCKeditor']->use = $CLASS['vars']['htmleditor']['use'];
$sBasePath = $_SERVER['PHP_SELF'] ;
$sBasePath = substr( $sBasePath, 0, strpos( $sBasePath, "index.php" ) );
$CLASS['oFCKeditor']->BasePath	= $sBasePath;
$CLASS['oFCKeditor']->Value = '';
$CLASS['oFCKeditor']->Width  = $CLASS['vars']['htmleditor']['fckeditor']['width'];
$CLASS['oFCKeditor']->Height = $CLASS['vars']['htmleditor']['fckeditor']['height'];
$CLASS['oFCKeditor']->Config['AutoDetectLanguage']	= $CLASS['vars']['htmleditor']['fckeditor']['langdetect'];
$CLASS['oFCKeditor']->Config['DefaultLanguage']		= $CLASS['vars']['htmleditor']['fckeditor']['langdefault'];
$CLASS['oFCKeditor']->Config['SkinPath'] = $sBasePath . 'system/fckeditor/skins/' . $CLASS['vars']['htmleditor']['fckeditor']['skin'] . '/' ;
$CLASS['oFCKeditor']->ToolbarSet = $CLASS['vars']['htmleditor']['fckeditor']['toolbar'];

$CLASS['tinymce'] = new tinymce();
$CLASS['tinymce']->start($CLASS);

// add javascript to htmlheader
$CLASS['kr_header']->addjssrc("system/javascript/prototype.js");
$CLASS['kr_header']->addjssrc("system/javascript/scriptaculous.js");
$CLASS['kr_header']->addjssrc("system/javascript/effects.js");
$CLASS['kr_header']->addjssrc("system/javascript/dragdrop.js");
$CLASS['kr_header']->addjssrc("system/javascript/showhide.js");
$CLASS['kr_header']->addjssrc("system/javascript/ajax-tree.js");
$CLASS['kr_header']->addjssrc("system/javascript/messagebox.js");

// add loadingmessage for messagebox
$CLASS['kr_header']->addjs("var msgboxloading = '".$CLASS['language']->get['messagebox']['loading']."';");

// add theme
$CLASS['kr_header']->addheader("<link rel=\"stylesheet\" href=\"". $CLASS['themes']->load_theme() ."\" type=\"text/css\">");

// add generator
$CLASS['kr_header']->addheader("<meta name=\"generator\" content=\"Knowledgeroot - ".$version."\" />");
?>