<?php
class pathTree {
	var $CLASS;
	var $cache = array(); // cache of tree records indexed by tree id


	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	function getPath($id = "0", $urlPrefix = '') {
		if($id == "") { $id = "0"; }
		$treeRecord = $this->getTreeRecord($id);

		if($treeRecord != null)  {
			if($treeRecord->belongs_to == "0") {
				return "/ <a href=\"" . $urlPrefix . "index.php?id=".$treeRecord->id."\">".$treeRecord->title."</a>";
			} else {
				$path = $this->getPath($treeRecord->belongs_to, $urlPrefix);
				return $path . " / <a href=\"" . $urlPrefix . "index.php?id=".$treeRecord->id."\">" . $treeRecord->title."</a>";
			}
		} else {
			return "/ ";
		}
	}
	
	function getTextPath($id = "0", $urlPrefix = '') {
		if($id == "") { $id = "0"; }
		$treeRecord = $this->getTreeRecord($id);

		if($treeRecord != null)  {
			if($treeRecord->belongs_to == "0") {
				return "/ ".$treeRecord->title;
			} else {
				$path = $this->getTextPath($treeRecord->belongs_to, $urlPrefix);
				return $path . " / " . $treeRecord->title;
			}
		} else {
			return "/ ";
		}
	}

	function getUnlinkedPath($id = "0") {
		if($id == "") { $id = "0"; }
		$treeRecord = $this->getTreeRecord($id);

		if($treeRecord != null)  {
			if($treeRecord->belongs_to == "0") {

				return "/ ".$treeRecord->title;
			} else {
				$path = $this->getUnlinkedPath($treeRecord->belongs_to);
				return $path . " / " . $treeRecord->title;
			}
		} else {
			return "/ ";
		}
	}

	function getTreePageTitle($id) {

		$treeRecord = $this->getTreeRecord($id);

		if($treeRecord != null)  {
				return $treeRecord->title;
		} else {
			return "";
		}
	}

	function getTreeRecord($id = "0") {
		if($id == "") { $id = "0"; }
		$treeRecord = null;
		$no_rows = false;

		if($this->cache[$id] != null) {
			$treeRecord = $this->cache[$id];
		} else {
			$res = $this->CLASS['db']->query("SELECT * FROM tree WHERE id='$id'");
			$anz = $this->CLASS['db']->num_rows($res);
			if($anz == 1)  {
				$row = $this->CLASS['db']->fetch_object($res);
				$treeRecord = $row;
				$this->cache[$id] = $treeRecord;
			} else {
				return null;
			}
		}
		return $treeRecord;
	}

	function isTree($id) {
		if($this->cache[$id] != null) {
			return TRUE;
		}

		return FALSE;
	}

	// return parent of element in tree
	function getParent($treeid) {
		$res = $this->CLASS['db']->query("SELECT belongs_to FROM tree WHERE id=".$treeid."");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			return $row['belongs_to'];
		} else {
			return 0;
		}
	}
}

class categoryTree {
	var $out = array();
	var $open = array();
	var $firstrun = 0;
	var $expand = 0;
	var $doexpand = 0;
	var $targetfile = "index.php";
	var $move = False;

	var $CLASS;
	var $category = array();

	var $userid = 0;
	var $groupid = 0;

	var $admin = 0;

	function start(&$CLASS,$move=FALSE,$targetfile="index.php") {
		$this->CLASS =& $CLASS;

		if($_SESSION['firstrun'] == "") {
			$this->doexpand =& $this->CLASS['vars']['menu']['expandall'];
		} else {
			$this->doexpand = 0;
		}

		$this->move = $move;
		$this->targetfile = $targetfile;

		$this->admin = $_SESSION['admin'];
	}

	function readCategories() {
		if($this->category[0] != "") {
			return $this->category;
		}

		//fr mysql umschreiben
		if($this->admin == 1) {
			$query = "SELECT * FROM tree WHERE deleted=0 ORDER BY title ASC";
		} else {
			if($this->CLASS['db']->dbtype == "mysql" || $this->CLASS['db']->dbtype == "mysqli") {
				if($_SESSION['groupid'] == 0) {
					$query = "SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) OR (`group`='".$_SESSION['groupid']."' AND grouprights > 0) OR (owner='".$_SESSION['userid']."' AND userrights>0)) ORDER BY title ASC";
				} else {
					$query_part = " OR (`group`='".$_SESSION['groupid']."' AND grouprights > 0)";
					
					$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$_SESSION['userid']."");
					while($row = $this->CLASS['db']->fetch_assoc($res)) {
						$query_part .= " OR (`group`='".$row['groupid']."' AND grouprights > 0)";
					}
					
					$query = "SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) " . $query_part . " OR (owner='".$_SESSION['userid']."' AND userrights>0)) ORDER BY title ASC";
				}
			} else {
				if($_SESSION['groupid'] == 0) {
					$query = "SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) OR (\"group\"='".$_SESSION['groupid']."' AND grouprights > 0) OR (owner='".$_SESSION['userid']."' AND userrights>0)) ORDER BY title ASC";
				} else {
					$query_part = " OR (\"group\"='".$_SESSION['groupid']."' AND grouprights > 0)";
					
					$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$_SESSION['userid']."");
					while($row = $this->CLASS['db']->fetch_assoc($res)) {
						$query_part .= " OR (\"group\"='".$row['groupid']."' AND grouprights > 0)";
					}
					
					$query = "SELECT * FROM tree WHERE deleted=0 AND ((otherrights > 0) " . $query_part . " OR (owner='".$_SESSION['userid']."' AND userrights>0)) ORDER BY title ASC";
				}
			}
		}

		$res = $this->CLASS['db']->query($query);

		while ( $var = $this->CLASS['db']->fetch_assoc($res) ) {
			$out[ $var[belongs_to] ][ $var[id] ] = $var[title];
			$this->out[ $var[belongs_to] ][ $var[id] ] = $var[title];
			//$this->visible[ $var[id] ] = $var[visible];
			if($this->firstrun == 1) {
				$this->open[$var[id] ] = 0;
				$_SESSION['open'][$var[id]] = 0;
			}
		}

		return $out;
	}

	function isParentelement($element, $parent) {
		$query = "SELECT belongs_to FROM tree WHERE id='".$element."'";
		$res = $this->CLASS['db']->query($query);
		$anz = $this->CLASS['db']->num_rows($res);
		if($anz != 1) {
			return FALSE;
		}

		$row = $this->CLASS['db']->fetch_assoc($res);

		if($row['belongs_to'] == $parent) {
			return TRUE;
		} else {
			return $this->isParentelement($row['belongs_to'],$parent);
		}
	}

	function buildTree( $rec_id ) {
		echo "<table class=\"tree\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n";
		$cats = $this->readCategories();

		if($this->CLASS['vars']['menu']['ajax'] == "yes") {
			if($this->CLASS['vars']['menu']['type'] == "static") {
				$fixedstyle = "style=\"display:none;\"";
				$slidestyle = "style=\"display:block;\"";
			} else {
				$fixedstyle = "style=\"display:block;\"";
				$slidestyle = "style=\"display:none;\"";
			}
			
			if($this->move == TRUE) {
				$moveparam = "1";
			}
			
			echo '
				<tr><td class="treenavi">
					<div>
						<table width="100%">
							<tr>
								<td><a href="#" border="0" onclick="HideTree();"><img border="0" width="22" src="images/left.gif" title="'.$this->CLASS['language']->get['tree']['hidetree'].'"></a></td>
								<td><a href="#" onclick="TreeExpand('.$moveparam.');" alt="reload"><img border="0" width="22" src="images/plus.gif" title="'.$this->CLASS['language']->get['tree']['expand'].'" /></a></td>
								<td><a href="#" onclick="TreeReload('.$moveparam.');" alt="reload"><img border="0" width="22" src="images/reload.gif" title="'.$this->CLASS['language']->get['tree']['reload'].'" /></a></td>
								<td><a href="#" onclick="TreeCollapse('.$moveparam.');" alt="reload"><img border="0" width="22" src="images/minus.gif" title="'.$this->CLASS['language']->get['tree']['collapse'].'" /></a></td>
								<td>
									<div id="treefixed" '.$fixedstyle.'><a href="#" onclick="TreeFixed();"><img border="0" width="22" src="images/fixed.gif" title="'.$this->CLASS['language']->get['tree']['showmenu'].'" /></a></div>
									<div id="treeslide" '.$slidestyle.'><a href="#" onclick="TreeSlide();"><img border="0" width="22" src="images/close.gif" title="'.$this->CLASS['language']->get['tree']['closemenu'].'" /></a></div>
								</td>
							</tr>
						</table>

					</div>
				</td></tr>
			';
			echo "<tr><td>\n";
			echo "<div id=\"treeelements\">\n";
			//echo "<div id=\"treeanchor\"></div>\n";
			echo "<table id=\"treeelementtable\" class=\"treeelements\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n";
			echo $this->showAjaxTreePart( $this->getTreePart(0) );
			echo "</table>\n";
			echo "</div>\n";
			echo "</td></tr>\n";
		} else {
			echo $this->showTreePart( $this->getTreePart(0) );
		}

		echo "</table>\n";
	}

	function buildAjaxTreePart($id) {
		$this->open = $_SESSION['open'];

		$cats = $this->readCategories();

		if($id == "0") {
			$depth = 0;
		} else {
			$depth = 1;
		}

		$spaces = $this->getDeepPart($id) + $depth;
		return $this->showAjaxTreePart( $this->getTreePart($id), $spaces );
	}

	function showTreePart( $arr, $indent = 0 ) {
		$space = "";
		$open = array();

		for ( $i=0; $i<$indent; $i++ ) {
			$space .= "&nbsp;<img src=\"images/clear.gif\" alt=\"\" />&nbsp;";
		}

		$out = "";

		if( count( $arr ) > 0 ) {
        		foreach( $arr as $id => $title ) {
				if($title == "") {
					$title = "[EMPTY]";
				}
				//if($this->visible[$id] == 1) {
					if($this->move == TRUE) {
						$indexfile = "move.php";
					} else {
						$indexfile = "index.php";
					}
					
					if($this->lastPart($id) == 0) {
						if($_SESSION['open'][$id] == 1 || $this->expand == 1 || $this->doexpand == 1) {
							$spaces = $space . "&nbsp;<a class=\"image\" href=\"".$indexfile."?openid=$id\"><img border=\"0\" alt=\"\" src=\"images/minus.jpg\"></a>&nbsp;";
						} else {
							$spaces = $space . "&nbsp;<a class=\"image\" href=\"".$indexfile."?openid=$id\"><img border=\"0\" alt=\"\" src=\"images/plus.jpg\"></a>&nbsp;";
						}
					} else {
						$spaces = $space . "&nbsp;<img border=\"0\" alt=\"\" src=\"images/black.gif\" />&nbsp;";
					}

					if($this->move == TRUE) {
						$out .= "<tr><td class=\"tree\" nowrap=\"nowrap\">".$spaces . "<a href=\"#\" onclick=\"window.opener.document.forms.move.to.value = '".$id."'; window.opener.document.forms.move.submit(); window.close();\">" .$title . "</a></td></tr>\n";
					} else {
						$out .= "<tr><td class=\"tree\" nowrap=\"nowrap\">".$spaces . "<a href=\"index.php?id=$id\">" .$title . "</a></td></tr>\n";
					}

					if($this->open[$id] == 1 || $this->expand == 1 || $this->doexpand == 1) {
						$_SESSION['open'][$id] = 1;
						$this->open[$id] = 1;
						$out .= $this->showTreePart( $this->getTreePart( $id ), $indent+1 );
					}
				//}
			}
		}

		return $out;
	}

	function showAjaxTreePart( $arr, $indent = 0 ) {
		$space = "";
		$open = array();

		for ( $i=0; $i<$indent; $i++ ) {
			$space .= "&nbsp;<img src=\"images/clear.gif\" alt=\"\" />&nbsp;";
		}

		$out = "";

		if( count( $arr ) > 0 ) {
        		foreach( $arr as $id => $title ) {
				if($title == "") {
					$title = "[EMPTY]";
				}
				
				//if($this->visible[$id] == 1) {
					if($this->lastPart($id) == 0) {
						if($_SESSION['open'][$id] == 1 || $this->expand == 1 || $this->doexpand == 1) {
							
							// check if page is movingpage
							$moveparam = "";
							if($this->move == TRUE) {
								$moveparam = ",1"; 
							}
							
							$spaces = $space . "&nbsp;<a id=\"linkid_".$id."\" class=\"image\" href=\"#\" onclick=\"AjaxMenuClose(".$id.$moveparam.");\"><img id=\"menuimg_".$id."\" border=\"0\" alt=\"\" src=\"images/minus.jpg\"></a>&nbsp;";
						} else {
							$spaces = $space . "&nbsp;<a id=\"linkid_".$id."\" class=\"image\" href=\"#\" onclick=\"AjaxMenuOpen(".$id.$moveparam.");\"><img id=\"menuimg_".$id."\" border=\"0\" alt=\"\" src=\"images/plus.jpg\"></a>&nbsp;";
						}
					} else {
						$spaces = $space . "&nbsp;<img border=\"0\" alt=\"\" src=\"images/black.gif\" />&nbsp;";
					}

					if($this->move == TRUE) {
						$out .= "<tr id=\"menu_".$id."\"><td class=\"tree\" nowrap=\"nowrap\">".$spaces . "<a id=\"alink_".$id."\" href=\"#\" onclick=\"window.opener.document.forms.move.to.value = '".$id."'; window.opener.document.forms.move.submit(); window.close();\">" .$title . "</a></td></tr>\n";
					} else {
						$out .= "<tr id=\"menu_".$id."\"><td class=\"tree\" nowrap=\"nowrap\">".$spaces . "<a id=\"alink_".$id."\" href=\"index.php?id=$id\">" .$title . "</a></td></tr>\n";
					}

					if($this->open[$id] == 1 || $this->expand == 1 || $this->doexpand == 1) {
						$_SESSION['open'][$id] = 1;
						$this->open[$id] = 1;
						$out .= $this->showAjaxTreePart( $this->getTreePart( $id ), $indent+1 );
					}
				//}
			}
		}

		return $out;
	}

	// return number of parents to root
	// needed for tree to show subelements
	function getDeepPart($id) {
		$res = $this->CLASS['db']->query("SELECT belongs_to FROM tree WHERE id=".$id." AND deleted=0");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			if($row['belongs_to'] == 0) {
				return "0";
			} else {
				return 1 + $this->getDeepPart($row['belongs_to']);
			}
		} else {
			return "0";
		}
	}

	function getTreePart( $belongs_to ) {
        	// WAAH! ueberfluessig haeufiger Aufruf...mir jetzt egal :)
		$cats = $this->out;
		if( count( $cats[ $belongs_to ] ) > 0 ) {
        		foreach ( $cats[ $belongs_to ] as $id => $entry ) {
            			$out[$id] = $entry;
			}
		}

		return $out;
	}

	function lastPart($id) {
		$res = $this->CLASS['db']->query("SELECT * FROM tree WHERE belongs_to='$id' AND deleted=0");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz >= 1) {
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				if($this->CLASS['knowledgeroot']->getPageRights($row['id'],$_SESSION['userid']) >= 1) {
					return 0;
				}
			}
			
			return 1;
		} else {
			return 1;
		}
	}
}

?>
