<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 11.04.2006
 *
 * This Class inerhits functions that do header/background work
 ******************************/

class knowledgeroot_header {
	var $CLASS;
	var $messages = ""; // var with message that will be display on top
	var $htmlheader = ""; // var with htmlheader tags that will be included to the header

	var $messagetype = "notice"; // default messagetype

	// init/start class
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	function check_vars() {
		//check if userid and groupid is set, if not set to 0
		if($_SESSION['userid'] == "" || $_SESSION['groupid'] == "") {
			$_SESSION['userid'] = 0;
			$_SESSION['groupid'] = 0;
		}

		// check for first run in this session and do expand all or not
		if($_SESSION['firstrun'] == "" && $this->CLASS['vars']['menu']['expandall'] == 1) {
			$this->CLASS['vars']['menu']['doexpand'] = 1;
		} else {
			$this->CLASS['vars']['menu']['doexpand'] = 0;
		}

		// if GET[id] not set use POST[id]
		if($_GET['id'] != "") {
			$id = $_GET['id'];
		} else {
			$id = $_POST['id'];
		}

		// set siteid to session
		if($id != "") {
			$_SESSION['cid'] = $id;

			// check if page is available
			$res = $this->CLASS['db']->query("SELECT count(id) as anz FROM tree WHERE id=".$_SESSION['cid']."");
			$row = $this->CLASS['db']->fetch_assoc($res);

			// if page is not available set to defaultpage
			if($row['anz'] == 0) {
				$id = $this->CLASS['vars']['knowledgeroot']['defaultpage'];
				$_SESSION['cid'] = $this->CLASS['vars']['knowledgeroot']['defaultpage'];
			}
		} else {
			if($_SESSION['cid'] == "") {
				$id = $this->CLASS['vars']['knowledgeroot']['defaultpage'];
				$_SESSION['cid'] = $this->CLASS['vars']['knowledgeroot']['defaultpage'];
			}
		}

		// do logout
		if($_GET['action'] == "logout") {
			$this->logout();
		}

		// check usersession
		$this->check_loged_in_userrights();

		// do login
		if($_POST['login'] != "") {
			$this->login();
		}

		// edit content?
		if($_POST['submit'] && $_POST['editid']) {
			$this->edit_content();
		}

		// create new content?
		if($_POST['submit'] && $_POST['neditid']) {
			$this->new_content();
		}

		// create new page?
		if($_POST['submit'] && $_POST['newpage']) {
			$this->new_page();
		}

		// file upload?
		if($_POST['submit'] && $_POST['upload']) {
			$this->upload_file();
		}

		// delete content?
		if($_GET['delid'] != "") {
			$this->delete_content();
		}

		// delete page?
		if($_GET['delpage'] != "") {
			$this->delete_page();
		}

		// edit page?
		if($_POST['editpage'] != "") {
			$this->edit_page();
		}

		// delete file?
		if($_GET['delfile'] != "") {
			$this->delete_file();
		}

		// create root?
		if($_POST['submit'] && $_POST['action'] == "createroot") {
			$this->create_root();
		}

		// add user?
		if($_POST['submit'] && $_POST['action'] == "adduser" && $_POST['name'] != "") {
			$this->add_user();
		}

		// edit user?
		if($_POST['submit'] && $_POST['action'] == "edituser" && $_POST['name'] != "") {
			$this->edit_user();
		}

		// add group?
		if($_POST['submit'] && $_POST['action'] == "addgroup" && $_POST['name'] != "") {
			$this->add_group();
		}

		// edit group?
		if($_POST['submit'] && $_POST['action'] == "editgroup" && $_POST['name'] != "") {
			$this->edit_group();
		}

		// delete user?
		if($_GET['action'] == "deluser" && $_GET['uid'] != "") {
			$this->delete_user();
		}

		// delete group?
		if($_GET['action'] == "delgroup" && $_GET['gid'] != "") {
			$this->delete_group();
		}

		// edit options?
		if($_POST['action'] == "options") {
			$this->edit_options();
		}

		// move page?
		if($_POST['move'] == "move" && $_POST['to'] != $_SESSION['cid']) {
			$this->move_page();
		}

		// move content?
		if($_POST['move'] == "cmove" && $_POST['to'] != $_SESSION['cid'] && $_POST['contentid'] != "") {
			$this->move_content();
		}

		// will move content up on the page
		if($_GET['moveup'] != "") {
			$this->move_content_up();
		}

		// will move content down on the page
		if($_GET['movedown'] != "") {
			$this->move_content_down();
		}

		// open tree element?
		if($_GET['openid'] != "") {
			$this->open_tree_element();
		}

		// add title to htmlheader
		$this->addtitle();

		// set charset
		if($this->CLASS['vars']['knowledgeroot']['charset'] != "") {
			if($this->CLASS['vars']['knowledgeroot']['charset'] == "utf8") {
				$charset = "utf-8";
			} else {
				$charset = $this->CLASS['vars']['knowledgeroot']['charset'];
			}
			
			$this->addheader("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" . $charset . "\">");
		}

		return 0;
	}

	// make login
	function login() {
		$user = addslashes($_POST['user']);
		$pass = md5(addslashes($_POST['password']));

		$res = $this->CLASS['db']->query("SELECT id, defaultgroup, admin, rightedit, treecache, theme, language FROM users WHERE name='$user' and password='$pass' and enabled=1");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			$_SESSION['userid'] = $row['id'];
			$_SESSION['groupid'] = $row['defaultgroup'];
			$_SESSION['user'] = $user;
			$_SESSION['password'] = $pass;
			$_SESSION['md5hash'] = md5($user . $pass);
			$_SESSION['admin'] = $row['admin'];
			$_SESSION['rightedit'] = $row['rightedit'];
			$_SESSION['open'] = array();
			$_SESSION['open'] = unserialize($row['treecache']);
			$_SESSION['theme'] = $row['theme'];
			$_SESSION['language'] = $row['language'];
			$this->CLASS['language']->load_language($_POST['language']);

			// clean treecache
			unset($this->CLASS['tree']);
			$this->CLASS['tree'] = new categoryTree();
			$this->CLASS['tree']->start($this->CLASS);

			// do a reload for a new clean initialisation after logout
			header("Location: index.php?".session_name(). "=" .session_id());
			exit();
		} else {
			$_SESSION['user'] = "guest";
			$_SESSION['password'] = "guest";
		}

		return 0;
	}

	// destroy session and make clean logout
	function logout() {
		$treecache = $_SESSION['open'];
		$_SESSION = array();
		$_SESSION['user'] = "guest";
		$_SESSION['password'] = "guest";
		$_SESSION['md5hash'] = "";
		$_SESSION['cid'] = "";
		$_SESSION['userid'] = "";
		$_SESSION['groupid'] = "";
		$_SESSION['admin'] = "0";
		//$_SESSION['theme'] = "";
		session_destroy();

		// will not work perhaps session is destroyed
		$_SESSION['open'] = $treecache;

		// do a reload for a new clean initialisation after logout
		header("Location: index.php");
		exit();

		/* old method
		// clean treecache
		unset($this->CLASS['tree']);
		$this->CLASS['tree'] = new categoryTree();
		$this->CLASS['tree']->start($this->CLASS);
		*/

		return 0;
	}
	
	// check usersession
	// if session wrong give guest rights
	function check_loged_in_userrights() {
		if($_SESSION['user'] != "guest" && $_SESSION['password'] != "guest" && $_SESSION['md5hash'] != md5($_SESSION['user'] . $_SESSION['password'])) {
				$_SESSION['user'] = "guest";
				$_SESSION['password'] = "guest";
				$_SESSION['md5hash'] = "";
				$_SESSION['admin'] = "0";
		}

		return 0;
	}

	// download files from knowledgeroot
	function check_download() {
		if($_GET['download'] != "") {
			$rs = $this->CLASS['db']->query("select f.*, c.belongs_to as cid from files f, content c where f.belongs_to = c.id AND f.deleted=0 AND f.id =".$_GET['download'].";");
			$anz = $this->CLASS['db']->num_rows($rs);

			if($anz != 1) {
				echo "WRONG DOWNLOADFILE!\n";
				exit();
			}

			$row = $this->CLASS['db']->fetch_assoc($rs);

			if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['cid'], $_SESSION['userid']) == 0) {
				echo "No File for you!\n";
				exit();
			}

			header('Accept-Ranges: bytes');
			header('Content-Length: '.$row['filesize'].'');
			header('Keep-Alive: timeout=15, max=100');
			header('Content-type: '.$row['filetype'].'');
			header('Content-Disposition: attachment; filename="'.$row['filename'].'"');

			if($this->CLASS['db']->dbtype == "pgsql") {
				$this->CLASS['db']->query ("begin");
				$loid = $this->CLASS['db']->lo_open($row['object'], "r");
				$this->CLASS['db']->lo_read_all ($loid);
				$this->CLASS['db']->lo_close ($loid);
				$this->CLASS['db']->query ("commit");
				$this->CLASS['db']->close();
			}

			if($this->CLASS['db']->dbtype == "mysql" || $this->CLASS['db']->dbtype == "mysqli") {
				echo unserialize($row['file']);
			}


			exit();
		}
	}

	// this will edit a content
	function edit_content() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2 && $this->CLASS['knowledgeroot']->getContentRights($_POST['editid'],$_SESSION['userid']) == 2) {
			if($_POST['close'] == "") {
				$content = stripslashes($content);

				if($_SESSION['rightedit'] == 1) {
					if($this->CLASS['db']->dbtype == "pgsql") {
						$res = $this->CLASS['db']->query("UPDATE content SET content='".$_POST['content']."', owner='".$_POST['user']."', \"group\"='".$_POST['group']."', userrights='".$_POST['userrights']."', grouprights='".$_POST['grouprights']."', otherrights='".$_POST['otherrights']."' WHERE id='".$_POST['editid']."'");
					} else {
						$res = $this->CLASS['db']->query("UPDATE content SET content='".$_POST['content']."', owner='".$_POST['user']."', `group`='".$_POST['group']."', userrights='".$_POST['userrights']."', grouprights='".$_POST['grouprights']."', otherrights='".$_POST['otherrights']."' WHERE id='".$_POST['editid']."'");
					}
				} else {
					$res = $this->CLASS['db']->query("UPDATE content SET content='".$_POST['content']."' WHERE id='".$_POST['editid']."'");
				}

				if($_POST['save'] != "") {
					$_GET['eid'] = $_POST['editid'];
				}

				$pagename = $this->CLASS['path']->getTreePageTitle($_SESSION['cid']);

				// email notification
				$this->CLASS['notification']->send_email_notification($_SESSION['cid'],"content","edited",$pagename,$_POST['editid']);
			}
		}
	}

	// this will create a new content
	function new_content() {
		if($this->CLASS['knowledgeroot']->getPageRights($_POST['belongsto'],$_SESSION['userid']) == 2) {
			if($_POST['close'] == "") {
				$content = stripslashes($content);

				// get next sorting value
				$res = $this->CLASS['db']->query("SELECT max(sorting) as sorting FROM content WHERE belongs_to=".$_POST['belongsto']."");
				$sort = $this->CLASS['db']->fetch_assoc($res);

				$sorting = $sort['sorting'] + 1;

				if($_SESSION['rightedit'] == 1) {
					if($this->CLASS['db']->dbtype == "pgsql") {
						$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,\"group\",userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '".$_POST['user']."', '".$_POST['group']."', '".$_POST['userrights']."', '".$_POST['grouprights']."', '".$_POST['otherrights']."')");
					} else {
						$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,`group`,userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '".$_POST['user']."', '".$_POST['group']."', '".$_POST['userrights']."', '".$_POST['grouprights']."', '".$_POST['otherrights']."')");
					}
				} else {
					if(!empty($_SESSION['userid'])) {
						// user logged in but have no rightedit -> use defaultrights
						$res = $this->CLASS['db']->query("SELECT id,defaultgroup,defaultrights FROM users WHERE id=".$_SESSION['userid']."");
						$anz = $this->CLASS['db']->num_rows($res);

						if($anz == 1) {
							$row = $this->CLASS['db']->fetch_assoc($res);
							if($this->CLASS['db']->dbtype == "pgsql") {
								$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,\"group\",userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '".$row['id']."', '".$row['defaultgroup']."', '".substr($row['defaultrights'],0,1)."', '".substr($row['defaultrights'],1,1)."', '".substr($row['defaultrights'],2,1)."')");
							} else {
								$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,`group`,userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '".$row['id']."', '".$row['defaultgroup']."', '".substr($row['defaultrights'],0,1)."', '".substr($row['defaultrights'],1,1)."', '".substr($row['defaultrights'],2,1)."')");
							}
						} else {
							if($this->CLASS['db']->dbtype == "pgsql") {
								$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,\"group\",userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '0', '0', '2', '2', '2')");
							} else {
								$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,`group`,userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '0', '0', '2', '2', '2')");
							}
						}
					} else {
						// no user logged in
						if($this->CLASS['db']->dbtype == "pgsql") {
							$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,\"group\",userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '0', '0', '2', '2', '2')");
						} else {
							$res = $this->CLASS['db']->query("INSERT INTO content (belongs_to, sorting, content,owner,`group`,userrights,grouprights,otherrights) VALUES(".$_POST['belongsto'].", ".$sorting.", '".$_POST['content']."', '0', '0', '2', '2', '2')");
						}
					}
				}

				if($_POST['save'] != "") {
					$_GET['eid'] = $this->CLASS['db']->last_id("seq_knowledge");
				}

				$pagename = $this->CLASS['path']->getTreePageTitle($_POST['belongsto']);

				// email notification
				$this->CLASS['notification']->send_email_notification($_POST['belongsto'],"content","created",$pagename, $_GET['eid']);
			}
		}
	}

	// this will create a new page
	function new_page() {
		if($this->CLASS['knowledgeroot']->getPageRights($_POST['belongsto'],$_SESSION['userid']) == 2 && $_POST['title'] != "") {
			if($_SESSION['rightedit'] == 1) {
				//change this for mysql
				if($this->CLASS['db']->dbtype == "pgsql") {
					$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,\"group\",userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '".$_POST['user']."', '".$_POST['group']."', '".$_POST['userrights']."', '".$_POST['grouprights']."', '".$_POST['otherrights']."')");
				} else {
					$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,`group`,userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '".$_POST['user']."', '".$_POST['group']."', '".$_POST['userrights']."', '".$_POST['grouprights']."', '".$_POST['otherrights']."')");
				}
			} else {
				if(!empty($_SESSION['userid'])) {
					// user logged in but have no rightedit -> use defaultrights
					$res = $this->CLASS['db']->query("SELECT id,defaultgroup,defaultrights FROM users WHERE id=".$_SESSION['userid']."");
					$anz = $this->CLASS['db']->num_rows($res);

					if($anz == 1) {
						$row = $this->CLASS['db']->fetch_assoc($res);
						if($this->CLASS['db']->dbtype == "pgsql") {
							$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,\"group\",userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '".$row['id']."', '".$row['defaultgroup']."', '".substr($row['defaultrights'],0,1)."', '".substr($row['defaultrights'],1,1)."', '".substr($row['defaultrights'],2,1)."')");
						} else {
							$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,`group`,userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '".$row['id']."', '".$row['defaultgroup']."', '".substr($row['defaultrights'],0,1)."', '".substr($row['defaultrights'],1,1)."', '".substr($row['defaultrights'],2,1)."')");
						}
					} else {
						if($this->CLASS['db']->dbtype == "pgsql") {
							$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,\"group\",userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '0', '0', '2', '2', '2')");
						} else {
							$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,`group`,userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '0', '0', '2', '2', '2')");
						}
					}
				} else {
					// no user logged in
					if($this->CLASS['db']->dbtype == "pgsql") {
						$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,\"group\",userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '0', '0', '2', '2', '2')");
					} else {
						$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to,title,owner,`group`,userrights,grouprights,otherrights) VALUES ('".$_POST['belongsto']."','".$_POST['title']."', '0', '0', '2', '2', '2')");
					}
				}

			}

			$new_page_id = $this->CLASS['db']->last_id("seq_knowledge");

			// email notification
			$this->CLASS['notification']->send_email_notification($new_page_id,"page","created",$_POST['title'],$new_page_id);

			$_SESSION['open'][$_POST['belongsto']] = 1;

			// simply redirect if the user select "automatically open the created page"
			if (isset($_POST['auto_open']) && $_POST['auto_open'] == "true") {
				$_SESSION['auto_open'] = true;
				header("Location: index.php?id=$new_page_id");
				exit();
			} else {
				$_SESSION['auto_open'] = false;
			}

		}
	}

	// make file upload
	function upload_file() {
		if($this->CLASS['knowledgeroot']->getContentRights($_POST['contentid'],$_SESSION['userid']) == 2) {
			$uploaddir = $this->CLASS['vars']['knowledgeroot']['uploadfolder'];
			if(!is_dir($uploaddir)) {
				$this->addwarning($this->CLASS['language']->get['nouploadfolder']);
				return 0;
			}

			if(move_uploaded_file($_FILES['datei']['tmp_name'], $uploaddir . $_FILES['datei']['name'])) {
				$fp = fopen($uploaddir.$_FILES['datei']['name'],"r");
				$buffer = fread($fp,filesize($uploaddir.$_FILES['datei']['name']));
				fclose($fp);

				//import for postgresql
				if($this->CLASS['db']->dbtype == "pgsql") {
					$this->CLASS['db']->query ("begin");
					$oid = $this->CLASS['db']->lo_create ();
					$rs = $this->CLASS['db']->query("insert into files(belongs_to,object,filename,filesize,filetype,owner) values('".$_POST['contentid']."',$oid,'" . $_FILES['datei']['name'] .  "','" . $_FILES['datei']['size'] . "','" . $_FILES['datei']['type'] . "','".$_SESSION['userid']."');");//object field type must be "oid"
					$handle = $this->CLASS['db']->lo_open ($oid, "w");
					$this->CLASS['db']->lo_write ($handle, $buffer);
					$this->CLASS['db']->lo_close ($handle);
					$this->CLASS['db']->query ("commit");
				}

				//import for mysql
				if($this->CLASS['db']->dbtype == "mysql") {
					$this->CLASS['db']->query("INSERT INTO files(belongs_to,file,filename,filesize,filetype,owner) VALUES ('".$_POST['contentid']."','".addslashes(serialize($buffer))."','" . $_FILES['datei']['name'] .  "','" . $_FILES['datei']['size'] . "','" . $_FILES['datei']['type'] . "','".$_SESSION['userid']."')");
				}

				// email notification
				$this->CLASS['notification']->send_email_notification($_SESSION['cid'],"file","created",$_FILES['datei']['name']);

				unlink($uploaddir.$_FILES['datei']['name']);
			}
		}
	}

	// delete content
	function delete_content() {
		if($this->CLASS['knowledgeroot']->getContentRights($_GET['delid'],$_SESSION['userid']) == 2) {
			$res = $this->CLASS['db']->query("UPDATE content SET deleted=1 WHERE id='".$_GET['delid']."'");
			$res = $this->CLASS['db']->query("UPDATE files SET deleted=1 WHERE belongs_to='".$_GET['delid']."'");

			// get id of page
			$res = $this->CLASS['db']->query("SELECT belongs_to FROM content WHERE id='".$_GET['delid']."'");
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				$pagename = $this->CLASS['path']->getTreePageTitle($row['belongs_to']);
				$pageid = $row['belongs_to'];
			} else {
				$pagename = $this->CLASS['path']->getTreePageTitle($_SESSION['cid']);
				$pageid = $_SESSION['cid'];
			}

			// email notification
			$this->CLASS['notification']->send_email_notification($pageid,"content","deleted",$pagename,$_GET['delid']);
		}
	}

	// delete page
	function delete_page() {
		if($this->CLASS['knowledgeroot']->getPageRights($_GET['delpage'],$_SESSION['userid']) == 2) {
			$res = $this->CLASS['db']->query("SELECT count(*) AS anz FROM content WHERE belongs_to='".$_GET['delpage']."' and deleted=0");
			$row = $this->CLASS['db']->fetch_object($res);
			$anz = $row->anz;

			$res = $this->CLASS['db']->query("SELECT count(*) AS anz FROM tree WHERE belongs_to='".$_GET['delpage']."' and deleted=0");
			$row = $this->CLASS['db']->Fetch_object($res);
			$anz = $anz + $row->anz;

			if($anz == "0") {
				//$res = $this->CLASS['db']->query("DELETE FROM tree WHERE id='".$_GET['delpage']."'");
				$res = $this->CLASS['db']->query("UPDATE tree SET deleted=1 WHERE id='".$_GET['delpage']."'");
				$_SESSION['cid'] = $this->CLASS['path']->getParent($_GET['delpage']);

				$pagename = $this->CLASS['path']->getTreePageTitle($_GET['delpage']);

				$res = $this->CLASS['db']->query("SELECT belongs_to FROM tree WHERE id='".$_GET['delpage']."'");
				$anz = $this->CLASS['db']->num_rows($res);

				if($anz == 1) {
					$row = $this->CLASS['db']->fetch_assoc($res);
					$pageid = $row['belongs_to'];
				} else {
					$pageid = $_GET['delpage'];
				}

				// email notification
				$this->CLASS['notification']->send_email_notification($pageid,"page","deleted",$pagename,$_GET['delpage']);
			} else {
				$this->addwarning($this->CLASS['language']->get['delpagefailed']);
			}
		}
	}

	// edit page
	function edit_page() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2 && $_POST['title'] != "") {
			if($_SESSION['rightedit'] == 1 || $_SESSION['admin'] == 1) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$res = $this->CLASS['db']->query("UPDATE tree SET title='".$_POST['title']."', owner='".$_POST['user']."', \"group\"='".$_POST['group']."', userrights='".$_POST['userrights']."', grouprights='".$_POST['grouprights']."', otherrights='".$_POST['otherrights']."' WHERE id='".$_SESSION['cid']."'");
				} else {
					$res = $this->CLASS['db']->query("UPDATE tree SET title='".$_POST['title']."', owner='".$_POST['user']."', `group`='".$_POST['group']."', userrights='".$_POST['userrights']."', grouprights='".$_POST['grouprights']."', otherrights='".$_POST['otherrights']."' WHERE id='".$_SESSION['cid']."'");
				}

				if($_POST['recursiv'] == 1) {
					$this->CLASS['knowledgeroot']->setRightsRecursiv($_SESSION['cid'],$_SESSION['userid'],$_POST['user'],$_POST['group'],$_POST['userrights'].$_POST['grouprights'].$_POST['otherrights']);
				}
			} else {
				$res = $this->CLASS['db']->query("UPDATE tree SET title='".$_POST['title']."' WHERE id='".$_SESSION['cid']."'");
			}

			$pagename = $this->CLASS['path']->getTreePageTitle($_SESSION['cid']);

			// email notification
			$this->CLASS['notification']->send_email_notification($_SESSION['cid'],"page","edited",$pagename,$_SESSION['cid']);
		}
	}

	// delete file
	function delete_file() {
		$res = $this->CLASS['db']->query("SELECT belongs_to FROM files WHERE id='".$_GET['delfile']."'");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			$belongs_to = $row['belongs_to'];

			if($this->CLASS['knowledgeroot']->getContentRights($belongs_to,$_SESSION['userid']) == 2) {

				if($this->CLASS['db']->dbtype == "pgsql") {
					$res = $this->CLASS['db']->query("SELECT object FROM files WHERE id='".$_GET['delfile']."'");

					$anz = $this->CLASS['db']->num_rows($res);

					if($anz == 1) {
						$row = $this->CLASS['db']->fetch_assoc($res);
						$this->CLASS['db']->lo_unlink($row['object']);
					}
				}

				//$res = $this->CLASS['db']->query("DELETE FROM files WHERE id='".$_GET['delfile']."'");
				$res = $this->CLASS['db']->query("UPDATE files SET deleted=1 WHERE id='".$_GET['delfile']."'");

				// get filename
				$res = $this->CLASS['db']->query("SELECT filename FROM files WHERE id='".$_GET['delfile']."'");
				$anz = $this->CLASS['db']->num_rows($res);

				if($anz == 1) {
					$row = $this->CLASS['db']->fetch_assoc($res);
				}

				// email notification
				$this->CLASS['notification']->send_email_notification($_SESSION['cid'],"file","deleted",$row['filename'],$_GET['delfile']);
			}
		}
	}

	// create root
	function create_root() {
		// rechte checken -> adminrechte
		if($_SESSION['admin'] == 1) {
			if($_POST['title'] == "") {
				$this->addwarning($this->CLASS['language']->get['emptyroot']);
			} else {
				//fr mysql umschreiben wegen " um group
				if($this->CLASS['db']->dbtype == "pgsql") {
					$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to, title, owner, \"group\", userrights, grouprights, otherrights) VALUES (0, '".$_POST['title']."', '".$_POST['user']."', '".$_POST['group']."', '".$_POST['userrights']."', '".$_POST['grouprights']."', '".$_POST['otherrights']."')");
				} else {
					$res = $this->CLASS['db']->query("INSERT INTO tree (belongs_to, title, owner, `group`, userrights, grouprights, otherrights) VALUES (0, '".$_POST['title']."', '".$_POST['user']."', '".$_POST['group']."', '".$_POST['userrights']."', '".$_POST['grouprights']."', '".$_POST['otherrights']."')");
				}

				// email notification
				$this->CLASS['notification']->send_email_notification($this->CLASS['db']->last_id("seq_knowledge"),"page","created",$_POST['title']);
			}
		}
	}

	// add user
	function add_user() {
		if($_SESSION['admin'] == 1) {
			//print_r($_POST['groups']);
			$res = $this->CLASS['db']->query("INSERT INTO users (name, password, theme, enabled, defaultgroup, defaultrights, admin, rightedit) VALUES ('".$_POST['name']."','".md5($_POST['password'])."','".$_POST['theme']."', ".$_POST['enabled'].", ".$_POST['defaultgroup'].", ".$_POST['userrights'].$_POST['grouprights'].$_POST['otherrights'].",".$_POST['admin'].",".$_POST['rightedit'].")");

			$res = $this->CLASS['db']->query("SELECT id FROM users WHERE name='".$_POST['name']."'");
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				if(is_array($_POST['groups'])) {
					foreach($_POST['groups'] as $key => $value) {
						$ressub = $this->CLASS['db']->query("INSERT INTO user_group (userid, groupid) VALUES (".$row['id'].",".$value.")");
					}
				}
			}

			$_GET['action'] = "users";
		}
	}

	// edit user
	function edit_user() {
		if($_SESSION['admin'] == 1) {
			//print_r($_POST['groups']);
			if($_POST['password'] == "") {
				$res = $this->CLASS['db']->query("UPDATE users SET name='".$_POST['name']."', theme='".$_POST['theme']."', enabled=".$_POST['enabled'].", defaultgroup=".$_POST['defaultgroup'].", defaultrights=".$_POST['userrights'].$_POST['grouprights'].$_POST['otherrights'].", admin=".$_POST['admin'].", rightedit=".$_POST['rightedit']." WHERE id=".$_POST['uid']."");
			} else {
				$res = $this->CLASS['db']->query("UPDATE users SET name='".$_POST['name']."', theme='".$_POST['theme']."', password='".md5($_POST['password'])."', enabled=".$_POST['enabled'].", defaultgroup=".$_POST['defaultgroup'].", defaultrights=".$_POST['userrights'].$_POST['grouprights'].$_POST['otherrights'].", admin=".$_POST['admin'].", rightedit=".$_POST['rightedit']." WHERE id=".$_POST['uid']."");
			}

			if(!is_array($_POST['groups'])) {
				$_POST['groups'] = array();
			}

			$res = $this->CLASS['db']->query("DELETE FROM user_group WHERE userid=".$_POST['uid']."");
			foreach($_POST['groups'] as $key => $value) {
				$res = $this->CLASS['db']->query("INSERT INTO user_group (userid, groupid) VALUES (".$_POST['uid'].",".$value.")");
			}

			$_GET['action'] = "users";
		}
	}

	// add group
	function add_group() {
		if($_SESSION['admin'] == 1) {
			$res = $this->CLASS['db']->query("INSERT INTO groups (name,enabled) VALUES ('".$_POST['name']."', 1)");
			$_GET['action'] = "users";
		}
	}

	// edit group
	function edit_group() {
		if($_SESSION['admin'] == 1) {
			$res = $this->CLASS['db']->query("UPDATE groups SET name='".$_POST['name']."' WHERE id=".$_POST['gid']."");
			$_GET['action'] = "users";
		}
	}

	// delete user
	function delete_user() {
		if($_SESSION['admin'] == 1) {
			$res = $this->CLASS['db']->query("DELETE FROM users WHERE id =".$_GET['uid']."");
			$_GET['action'] = "users";
		}
	}

	// delete group
	function delete_group() {
		if($_SESSION['admin'] == 1) {
			$res = $this->CLASS['db']->query("DELETE FROM groups WHERE id =".$_GET['gid']."");
			$_GET['action'] = "users";
		}
	}

	// edit options
	function edit_options() {
		if($_POST['language'] != $_SESSION['language']) {
			$_SESSION['language'] = $_POST['language'];
			$this->CLASS['language']->load_language($_POST['language']);
			$res = $this->CLASS['db']->query("UPDATE users SET language='".$_POST['language']."' WHERE id='".$_SESSION['userid']."'");
			$this->addmessage($this->CLASS['language']->get['optionform']['languagechanged']);
		}

		if($_POST['password'] == $_POST['password1'] && $_POST['password'] != "" && $_SESSION['userid'] != 0) {
			$res = $this->CLASS['db']->query("UPDATE users SET password='".md5($_POST['password'])."' WHERE id=".$_SESSION['userid']."");
			$this->addmessage($this->CLASS['language']->get['optionform']['changed']);
		} else {
			if($_POST['password'] != "") {
				$this->addwarning($this->CLASS['language']->get['optionform']['failed']);
			}
		}

		if($_POST['theme'] != $_SESSION['theme']) {
			$_SESSION['theme'] = $_POST['theme'];
			$res = $this->CLASS['db']->query("UPDATE users SET theme='".$_POST['theme']."' WHERE id='".$_SESSION['userid']."'");
			$this->addmessage($this->CLASS['language']->get['optionform']['themechanged']);
		} else {
			//$this->messages .= "<div class=\"redmsg\">".$this->CLASS['language']->get['optionform']['themefailed']."</div>";
		}
	}

	// move page
	function move_page() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2 && $this->CLASS['knowledgeroot']->getPageRights($_POST['to'],$_SESSION['userid']) == 2) {

			// init class categoryTree because its not definded at this point
			//$this->CLASS['tree'] = new categoryTree();
			//$this->CLASS['tree']->start($this->CLASS);

			// check if element is a kind of element to move -> if yes than abort
			if(!$this->CLASS['tree']->isParentelement($_POST['to'],$_SESSION['cid'])) {
				$res = $this->CLASS['db']->query("UPDATE tree SET belongs_to='".$_POST['to']."' WHERE id='".$_SESSION['cid']."'");

				$pagename = $this->CLASS['path']->getTreePageTitle($_SESSION['cid']);

				// email notification
				$this->CLASS['notification']->send_email_notification($_SESSION['cid'],"page","moved",$pagename,$_SESSION['cid']);
			}
		}
	}

	// move content
	function move_content() {
		if($this->CLASS['knowledgeroot']->getPageRights($_POST['to'],$_SESSION['userid']) == 2 && $this->CLASS['knowledgeroot']->getContentRights($_POST['contentid'],$_SESSION['userid']) == 2) {
			$res = $this->CLASS['db']->query("UPDATE content SET belongs_to='".$_POST['to']."' WHERE id='".$_POST['contentid']."'");

			$pagename = $this->CLASS['path']->getTreePageTitle($_SESSION['cid']);

			// email notification
			$this->CLASS['notification']->send_email_notification($_SESSION['cid'],"content","moved",$pagename,$_POST['contentid']);

		}
	}

	// open tree element
	function open_tree_element() {
		//echo "#$#".$_SESSION['open'][$openid]."#";
		if($_SESSION['open'][$_GET['openid']] == 0) {
			$_SESSION['open'][$_GET['openid']] = 1;
			//echo ":::";
		} else {
			$_SESSION['open'][$_GET['openid']] = 0;
		}

		// save treecache
		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query("UPDATE users SET treecache='".serialize($_SESSION['open'])."' WHERE id=".$_SESSION['userid']."");
		}
	}

	// show messages
	function show_messages() {
		if($this->messages != "") {
			$js = '
			<script language="javascript" type="text/javascript">
				onload = function() {
					ShowMessage("'.$this->messages.'","'.$this->messagetype.'");
					setTimeout("HideMessage()", 5000);
				}
			</script>
			';

			echo $js;
		}
		//echo $this->messages;
	}

	function addmessage($msg) {
		//$this->messages .= "<div class=\"greenmsg\">". $msg . "</div>\n";
		$this->messagetype = "notice";
		$this->messages .= $msg;
	}

	function addwarning($msg) {
		//$this->messages .= "<div class=\"redmsg\">". $msg . "</div>\n";
		$this->messagetype = "error";
		$this->messages .= $msg;
	}

	function addheader($msg) {
		$this->htmlheader .= $msg . "\n";
	}

	function show_header() {
		echo $this->htmlheader;
	}

	// add plain javascriptcode to header
	function addjs($code="") {
		$this->addheader("\t<script language=\"javascript\" type=\"text/javascript\">\n".$code."\t</script>");
	}

	// add source javascript sourcefile to header
	function addjssrc($src) {
		$this->addheader("\t<script src=\"".$src."\" type=\"text/javascript\"></script>");
	}

	// add title to header
	function addtitle() {
		$this->addheader("<title>".$this->CLASS['vars']['knowledgeroot']['title']."</title>");
	}

	// moves content up
	function move_content_up() {
		$contentid = $_GET['moveup'];
		$pageid = $_SESSION['cid'];

		if($contentid == "") {
			return 0;
		}

		// user can only move if he have pagerights
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
			$res = $this->CLASS['db']->query("SELECT id, sorting FROM content WHERE id=".$contentid."");
			$count = $this->CLASS['db']->num_rows($res);

			if($count == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);

				if($row['sorting'] == 0 || $row['sorting'] == null) {
					//$res = $this->CLASS['db']->query("UPDATE content SET sorting=0 WHERE sorting IS NULL AND deleted=0");
					$res = $this->CLASS['db']->query("UPDATE content SET sorting=sorting+1 WHERE belongs_to=".$pageid." AND id<>".$contentid." AND deleted=0");

					$this->addmessage($this->CLASS['language']->get['contentmoved']);
				} else {
					$res = $this->CLASS['db']->query("SELECT id, max(sorting) as sorting FROM content WHERE belongs_to=".$pageid." AND sorting<=".$row['sorting']." AND id<>".$contentid." AND deleted=0 GROUP BY id ORDER BY sorting DESC LIMIT 1");
					$count = $this->CLASS['db']->num_rows($res);

					if($count == 1) {
						$rowelement = $this->CLASS['db']->fetch_assoc($res);
;
						if($row['sorting'] == $rowelement['sorting']) {
							//$res = $this->CLASS['db']->query("UPDATE content SET sorting=0 WHERE sorting IS NULL AND deleted=0");
							$res = $this->CLASS['db']->query("UPDATE content SET sorting=sorting+1 WHERE belongs_to=".$pageid." AND id<>".$contentid." AND sorting>=".$row['sorting']." AND deleted=0");
						} else {
							$res = $this->CLASS['db']->query("UPDATE content SET sorting=".$row['sorting']." WHERE id=".$rowelement['id']."");
							$res = $this->CLASS['db']->query("UPDATE content SET sorting=".$rowelement['sorting']." WHERE id=".$row['id']."");
						}

						$this->addmessage($this->CLASS['language']->get['contentmoved']);
					} // else - do nothing
				}
			}
		}
	}

	function move_content_down() {
		$contentid = $_GET['movedown'];
		$pageid = $_SESSION['cid'];

		if($contentid == "") {
			return 0;
		}

		// user can only move if he have pagerights
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
			$res = $this->CLASS['db']->query("SELECT id, sorting FROM content WHERE id=".$contentid."");
			$count = $this->CLASS['db']->num_rows($res);

			if($count == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);

				// needed if fields have content "null"
				//$res = $this->CLASS['db']->query("UPDATE content SET sorting=0 WHERE sorting IS NULL AND deleted=0");

				$res = $this->CLASS['db']->query("SELECT id, min(sorting) as sorting FROM content WHERE belongs_to=".$pageid." AND sorting>=".$row['sorting']." AND id<>".$contentid." AND deleted=0 GROUP BY id ORDER BY sorting ASC LIMIT 1");
				$count = $this->CLASS['db']->num_rows($res);

				if($count == 1) {
					$rowelement = $this->CLASS['db']->fetch_assoc($res);

					if($row['sorting'] == $rowelement['sorting']) {
						$res = $this->CLASS['db']->query("UPDATE content SET sorting=sorting+1 WHERE belongs_to=".$pageid." AND id<>".$contentid." AND sorting>=".$row['sorting']." AND deleted=0");
					} else {
						$res = $this->CLASS['db']->query("UPDATE content SET sorting=".$row['sorting']." WHERE id=".$rowelement['id']."");
						$res = $this->CLASS['db']->query("UPDATE content SET sorting=".$rowelement['sorting']." WHERE id=".$row['id']."");
					}

					$this->addmessage($this->CLASS['language']->get['contentmoved']);
				}
			}
		}
	}

	function get_base_url() {
		if($_SERVER['HTTPS'] == "on") {
			$scheme = "https://";
		} else {
			$scheme = "http://";
		}

		$baseURL = $scheme . $_SERVER[HTTP_HOST] . $_SERVER[PHP_SELF];
		
		return substr( $baseURL, 0, strpos( $baseURL, "index.php" ) );
	}

}

?>