<?php
/*
 * Knowledgeroot
 * class for ajax functions that return xml
 * Frank Habermann
 */

class ajax_xml {
	// global array with classes
	var $CLASS = array();

	// var with xmlcode to return
	var $xmlcode = "";

	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	// check what to do
	function check_vars() {
		//check if userid and groupid is set, if not set to 0
		if($_SESSION['userid'] == "" || $_SESSION['groupid'] == "") {
			$_SESSION['userid'] = 0;
			$_SESSION['groupid'] = 0;
		}
	
		// try to work only with POST
		if($_POST['ajaxopen'] != "") {
			$this->tree_open($_POST['ajaxopen']);
		} elseif ($_POST['ajaxclose'] != "") {
			$this->tree_close($_POST['ajaxclose']);
		} elseif ($_POST['reloadtree'] != "") {
			$this->tree_reload();
		} elseif ($_POST['expandtree'] != "") {
			$this->tree_expand();
		} elseif ($_POST['collapsetree'] != "") {
			$this->tree_collapse();
		}
	}

	// generate xml to open tree part
	function tree_open($id) {
		// get all elements to open
		$elements = $this->getOpenTreeElements($id);

		// generate xmloutput
		$this->xmlcode = '<?xml version="1.0" ?>' . "\n";
		$this->xmlcode .= "<root>\n";
		$this->xmlcode .= "\t<parentid>".$id."</parentid>\n";
		$this->xmlcode .= "\t<html>\n";
		$this->xmlcode .= "<![CDATA[\n";
		//$this->xmlcode .= htmlentities($elements);
		$this->xmlcode .= $elements;
		$this->xmlcode .= "]]>\n";
		$this->xmlcode .= "\t</html>\n";
		$this->xmlcode .= "</root>\n";

		// save tree status to session and to db
		$_SESSION['open'][$id] = 1;

		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query("UPDATE users SET treecache='".serialize($_SESSION['open'])."' WHERE id=".$_SESSION['userid']."");
		}
	}

	// generate xml to close treepart
	function tree_close($id) {
		// get all elements to close
		$elements = $this->getCloseTreeElements($id);

		// generate xmloutput
		$this->xmlcode = '<?xml version="1.0" ?>' . "\n";
		$this->xmlcode .= "<root>\n";
		$this->xmlcode .= $elements;
		$this->xmlcode .= "</root>\n";

		// save tree status to session and to db
		$_SESSION['open'][$id] = 0;

		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query("UPDATE users SET treecache='".serialize($_SESSION['open'])."' WHERE id=".$_SESSION['userid']."");
		}
	}

	// returns elements to close of an treeparentelement
	function getCloseTreeElements($id) {
		// check if the user have permissions
		if($this->CLASS['knowledgeroot']->checkRecursivPerm($id, $_SESSION['userid']) != 0) {
			if($_SESSION['admin'] == 1) {
				$query = "SELECT id FROM tree WHERE  belongs_to=".$id." AND deleted=0 ORDER BY title ASC";
			} else {
				// get groups from user
				$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$_SESSION['userid']."");
				$orclause = "";
				while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
					if($this->CLASS['db']->dbtype == "pgsql") {
						$orclause .= "OR (\"group\"=".$rowuser['groupid']."  AND grouprights > 0) ";
					} else {
						$orclause .= "OR (`group`=".$rowuser['groupid']."  AND grouprights > 0) ";
					}
				}
				
				if($this->CLASS['db']->dbtype == "pgsql") {
					$query = "SELECT id FROM tree WHERE belongs_to=".$id." AND deleted=0 AND ((otherrights > 0) OR (\"group\"=".$_SESSION['groupid']." AND grouprights > 0) ".$orclause."OR (owner=".$_SESSION['userid']." AND userrights>0)) ORDER BY title ASC";
				} else {
					$query = "SELECT id FROM tree WHERE belongs_to=".$id." AND deleted=0 AND ((otherrights > 0) OR (`group`=".$_SESSION['groupid']." AND grouprights > 0) ".$orclause."OR (owner=".$_SESSION['userid']." AND userrights>0)) ORDER BY title ASC";
				}
			}

			$line = "";

			// get all elements to close in tree
			$res = $this->CLASS['db']->query($query);
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				$line .= "<element>".$row['id']."</element>\n";

				// try to get childs of this element
				if($_SESSION['open'][$row['id']] == 1) {
					$line .= $this->getCloseTreeElements($row['id']);
				}
			}
		}

		return $line;
	}

	// returns elements to open in tree
	function getOpenTreeElements($id) {
		$this->CLASS['tree'] = new categoryTree();
		
		// check if page is movingpage
		if($_POST['move'] == "1") {
			$this->CLASS['tree']->start($this->CLASS,TRUE,"#");
		} else {
			$this->CLASS['tree']->start($this->CLASS);
		}

		$lines = $this->CLASS['tree']->buildAjaxTreePart($id);

		return $lines;
	}

	// return xmlcode
	function get_xml() {
		return $this->xmlcode;
	}

	// returns the hole tree for reloading
	function tree_reload($expand = "") {
		$this->CLASS['tree'] = new categoryTree();

		// check if page is movingpage
		if($_POST['move'] == "1") {
			$this->CLASS['tree']->start($this->CLASS,TRUE,"#");
		} else {
			$this->CLASS['tree']->start($this->CLASS);
		}

		if($expand != "") {
			$this->CLASS['tree']->doexpand = $expand;
			$this->CLASS['tree']->expand = $expand;
		}

		$lines = $this->CLASS['tree']->buildAjaxTreePart("0");

		// generate tree
		$tree = "<table id=\"treeelementtable\" class=\"treeelements\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n";
		$tree .= $lines;
		$tree .= "</table>\n";

		// generate xmloutput
		$this->xmlcode = '<?xml version="1.0" ?>' . "\n";
		$this->xmlcode .= "<root>\n";
		$this->xmlcode .= "\t<html>\n";
		$this->xmlcode .= "<![CDATA[\n";
		$this->xmlcode .= $tree;
		$this->xmlcode .= "]]>\n";
		$this->xmlcode .= "\t</html>\n";
		$this->xmlcode .= "</root>\n";
	}

	// expand tree
	function tree_expand() {
		$_SESSION['firstrun'] = "no";

		if ($_SESSION['open'] != null) {
			foreach($_SESSION['open'] as $key => $value) {
				$_SESSION['open'][$key] = 1;
			}
		}

		// save treecache
		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query("UPDATE users SET treecache='".serialize($_SESSION['open'])."' WHERE id=".$_SESSION['userid']."");
		}
		
		$this->tree_reload("1");
	}

	// collapse tree
	function tree_collapse() {
		$_SESSION['firstrun'] = "no";

		if ($_SESSION['open'] != null) {
			foreach($_SESSION['open'] as $key => $value) {
				$_SESSION['open'][$key] = 0;
			}
		}

		// save treecache
		if(!empty($_SESSION['userid'])) {
			$res = $this->CLASS['db']->query("UPDATE users SET treecache='".serialize($_SESSION['open'])."' WHERE id=".$_SESSION['userid']."");
		}
		
		$this->tree_reload();
	}
}
?>