/* knocker version 0.6.0
 * Release date: 17 February 2002
 *
 * Project homepage: http://knocker.sourceforge.net
 *
 * Copyright 2001,2002 Gabriele Giorgetti <g.gabriele79@genie.it>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>


#include "knocker_term.h"
#include "knocker_args.h"

#ifndef FALSE
enum
{ FALSE, TRUE };
#endif

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_set_default_color (void)
{
  if (!knocker_args.quiet)
    {
      if (knocker_args.colors == TRUE)
        knocker_term_set_color (COLOR_WHITE, COLOR_BLACK, ATTRIB_RESET);
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_reset_color (void)
{
  if (knocker_args.quiet == FALSE)
    {
      if (knocker_args.colors == TRUE)
         knocker_term_set_color (COLOR_WHITE, COLOR_BLACK, ATTRIB_RESET);
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_set_color (int fg, int bg, int attrib)
{
  if (knocker_args.quiet == FALSE)
    {
      char cmd_str[13];

      if (knocker_args.colors == TRUE)
        {
          sprintf (cmd_str, "%c[%d;%d;%dm", 0x1B, attrib, fg + 30, bg + 40);
          printf ("%s", cmd_str);
        }
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_fflush (FILE *fd)
{
  if (knocker_args.quiet == FALSE)
    {
      fflush (fd);
    }
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_printf (const char *buffer)
{
  if (knocker_args.quiet == FALSE)
    {
      printf ("%s", buffer);
    }

  return;
}


/*
   ============================================================================
   ============================================================================
*/
void knocker_term_fprintf (FILE * fd, const char *buffer)
{
  if (knocker_args.quiet == FALSE)
    {
      fprintf (fd, "%s", buffer);
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_color_printf (const char *buffer, int color, int attrib)
{
  if (knocker_args.quiet == FALSE)
    {
      knocker_term_set_color (color, COLOR_BLACK, attrib);
      printf ("%s", buffer);
      knocker_term_reset_color ();
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_color_fprintf (FILE * fd, const char *buffer, int color, int attrib)
{
  if (knocker_args.quiet == FALSE)
    {
      knocker_term_set_color (color, COLOR_BLACK, attrib);
      fprintf (fd, "%s", buffer);
      knocker_term_reset_color ();
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_color_intprintf (const int i, int color, int attrib)
{
  if (knocker_args.quiet == FALSE)
    {
      knocker_term_set_color (color, COLOR_BLACK, attrib);
      printf ("%d", i);
      knocker_term_reset_color ();
    }

  return;
}

/*
   ============================================================================
   ============================================================================
*/
void knocker_term_color_intfprintf (FILE * fd, const int i, int color, int attrib)
{
  if (knocker_args.quiet == FALSE)
    {
      knocker_term_set_color (color, COLOR_BLACK, attrib);
      fprintf (fd, "%d", i);
      knocker_term_reset_color ();
    }

  return;
}



/*
 * function: restore_terminal - restore normal screen mode.
 * algorithm: uses the 'stty' command to restore normal screen mode.
 *            serves as a cleanup function for the user input thread.
 * input: none.
 * output: none.
 */
/*
void restore_terminal (void)
{
    restore_terminal: before 'stty -raw echo'

  system ("stty -raw echo");

   restore_terminal: after 'stty -raw echo'

}
*/




