/***************************************************************************
                          tabpage.h  -  description
                             -------------------
    begin                : Fri Sep 13 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABPAGE_H
#define TABPAGE_H

#include <qframe.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qstring.h>
#include "tabbox.h"

/**
  *@author Troy Corbin Jr.
  */
class resource;
class QToolButton;
class TabGrip;

class TabPage : public QVBox
{
	Q_OBJECT
	public:
								TabPage( QWidget *parent, QWidget *child, resource *rsrc );
								~TabPage();
		void				setCaption( const QString& );
		QWidget*		getChild( void );

	protected slots:
		void				tabDragged( const QPoint&, const QPoint& );

	signals:
		void				newParent( TabBox* );
		void				requestDestruction( void );

	protected:
		TabBox*			parentTabBox( void );

	private:
		QString			myCaption;
		QHBox				*actionBar;
		TabGrip			*grip;
		QToolButton	*closeButton;

		QWidget			*myChild;
		resource		*myResource;
};

#endif
