/***************************************************************************
                          support_funcs.h  -  description
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SUPPORT_FUNCS_H
#define SUPPORT_FUNCS_H

#include <qstring.h>


/**support functions used by many of the classes

  *@author John Donoghue
  */

long getFileSize(const char *filename);
void separate(QString s, int* read, int* size);
QString convertSpeed(int speed);
QString getFileName(const QString &path,bool unixpath=false);
QString getFilePath(const QString &path,bool unixpath=false);
QString makeFullFilePath(const QString &path,const QString &file);
QString convertSize(long sz);
QString extractString(QString &s);

QString toDosName(const QString &name);
QString toUnixName(const QString &name);

QString getTempFileName();

QString expandFileName(const QString &name);

#ifdef NEED_INET_ATON
  // some sun machines dont have this
  int inet_aton(const char *str,struct in_addr *to);
#endif

#endif
