/***************************************************************************
begin                : Mon Feb 4 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTRULE_H
#define IPTRULE_H

#include "netfilterobject.h"

#include <qptrlist.h>
#include <qdict.h>

#include <kdemacros.h>

// Project Includes
#include "iptruleoption.h" 
/**
  *@author Christian Hubinger
  */

class QString;

namespace KMF {

class IPTChain;
class IPTable;
class KMFError;
class KMFCheckInput;
/** This class represents one "Rule" in the ruleset needed to settup
		the firewall those rule look like: $IPT -A CHAINNAME [ OPTIONS ] -j TARGET [ OPTIONS ]
*/

class KDE_EXPORT IPTRule : public NetfilterObject {
public:
	
	/** The only constructor that sets the name,chain,target and table. */
	IPTRule( IPTChain* chain, const char *objectname , const QString& name , const QString& target );
	~IPTRule();
	
	virtual int type();
	virtual void clear();
	
	/** Sets the name of the rule to name.
		This name is displayed in the Document View */
	KMFError* setRuleName( const QString& name ); 

	/** Sets the chain for which this Rule applies */
	void setChain( IPTChain* chain ); 

	/**  Sets the Target for the Rule */
	void setTarget( const QString& target );

	/** Sets the Table of the rule to table */
	void setTable( IPTable* table ); // FIXME: set IPTable to use default="filter"

	/** Enable/Disable cmd line generation for this rule */
	void setEnabled( bool on );

	/** Return true if the Rule is enabled; else returns false */
	bool enabled() const {
		return m_enabled;
	};

	/** Enable/Disable logging rule for this rule */
	void setLogging( bool on );

	/** Return true if the rule logging is turend on; 
		else returns false */
	bool logging() const {
		return m_log_rule;
	};

	/** Addes a ruleoption defined the a string optionname
		e.g. "ip_opt" "state" and the strings needed to define
		all options is given by the list options values of the */
	bool addRuleOption( QString& optionname, QPtrList<QString>& options );


	/** Addes a rule target option defined the a string optionname
		e.g. "ip_opt" "state" and the strings needed to define
		all options is given by the list options values of the */
	bool addTargetOption( QString& optionname, QPtrList<QString>& options );

	/** Returns the chain to which this rule belongs */
	IPTChain* chain() const {
		return m_chain;
	};

	/** Returns the table to which this rule belongs */
	IPTable* table() const {
		return m_table;
	};

	/** Returns a ruleoption object for this option type if it
		exists.
		If no one exists a new rule option will be created with the given type.
		If the type is invalid 0 is returned. */
	IPTRuleOption* getOptionForName( const QString& );

	/** Returns the target of the rule */
	const QString& target() const ;


	/** Return the rule number in it's chain */
	int ruleNum() const;

	/** Return true if this is a rule eith custom options */
	bool customRule() const {
		return m_custom_rule;
	};

	/** Set the custom rule flag */
	void setCustomRule( bool );

	/** Returns the commandline that this rule represents */
	const QString& toString();
	
	/** Serialize the rule to a QDomDocument */
	const QDomDocument& getDOMTree();
	
	/** Load the rule from the QDomDocument */
	virtual void loadXML( const QDomDocument&, QStringList& errors );

	/** Load rule From DomNode */
	virtual void loadXML( QDomNode, QStringList& errors );

	/** Creates a deep copy of the rule */
	void createRuleClone( IPTRule* );


	/** Returns List of all possible Targets for this rule */
	QStringList availableTargets() const;

	/** Returns true if the target is the name of a chain 
		e.g the rule forwards packets to a chain */
	bool isForward() const;

private:
	/**  The chain of the rule */
	IPTChain *m_chain;

	/** The table of the rule */
	IPTable *m_table;

	/** The target of the rule */
	QString m_target;

	KMFError *m_err;
	KMFCheckInput *m_check_input;
	QDict<IPTRuleOption> m_options;

	bool m_enabled;
	bool m_log_rule;
	bool m_custom_rule;

	QString opt; 
	QString ipt_cmd; 
	QString tab; 
	QString ap; 
	QString ws; 
	QString post; 
	QString option_cmd;
};
}
#endif
