/***************************************************************************
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFERROR_H
#define KMFERROR_H

#include <qstring.h> 
#include <kdemacros.h>

/**
  *@author Christian Hubinger
  */

class KDE_EXPORT KMFError {
public:
	KMFError();
	~KMFError();

	enum {  OK = 0, HINT = 1, NORMAL = 2, FATAL = 3 };
	
	/** Set the error message */
	void setErrMsg( const QString& msg );
	
	/** Sets the message type */
	void setErrType( int type );

	/** get the Error message */
	const QString& errMsg() const {
		return m_err_msg;
	};

	/** Get the error number */
	int errNum() const {
		return m_err_num;
	};

	/** Get the error type e.g. HINT, FATAL etc.*/
	int errType() const {
		return m_err_type;
	};

private:
	private: int m_err_type;
	private: QString m_err_msg;
	private: int m_err_num;
};

#endif
