/***************************************************************************
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFCHECKINPUT_H
#define KMFCHECKINPUT_H


/**
  *@author Christian Hubinger
  */

#include <qdict.h>

#include <kdemacros.h>

class QString;
class KMFError;
class KDE_EXPORT KMFCheckInput {
public:
	KMFCheckInput();
	~KMFCheckInput();

	/** Check the given input string is it matches the criterias
		for the given input type */
	void checkInput( QString& inp, const QString& inp_type, KMFError* );

private:    // functions
	void generateMsgDict();
	
	/** Check if inp is a IP address */
	bool checkIP( QString input );
	
	/** Check if inp is a FQHN */
	bool checkFQHN( QString inp );
	
	/** Check if inp can be a chain name */
	bool checkChainName( QString inp );
	
	/** Check if inp can be a rule name */
	bool checkRuleName( QString inp );
	
	/** Check if inp is a MAC address */
	bool checkMAC( QString inp );
	
	/** Check if inp is a net mask */
	bool checkNetMask ( QString inp );
	
	/** Check if inp is a network */
	bool checkNetWork ( QString inp );
	
	/** Check if inp is a port */
	bool checkPORT( QString inp );
	
	/** Check if inp is a portrange */
	bool checkPORTRANGE( QString inp );
	
	/** Check if inp is a multiport string */
	bool checkMULTIPORT( QString inp );
private:     // data
	QDict<QString> m_msg_dict;
};

#endif
