/***************************************************************************
                        main.cpp  -  description
                           -------------------
  begin                : Sun Jan 27 21:17:58 CET 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmyfirewall.h"
#include "version.h"

#include <kmfapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>


#include <qstring.h>


static const char description[] = I18N_NOOP( "KMyFirewall - IPTables configuration tool" );


static KCmdLineOptions options[] =
    {
        { "+[URL]", I18N_NOOP( "Files/URLs to Open." ), 0 },
        { 0, 0, 0}
    };

int main( int argc, char *argv[] ) {

	KAboutData aboutData( "kmyfirewall", I18N_NOOP( "KMyFirewall" ),
	                      KMYFIREWALL_VERSION, description, KAboutData::License_GPL,
	                      "(c) 2002, the KMyFirewall developers", 0, 0, "e9806056@student.tuwien.ac.at" );
	aboutData.addAuthor( "Christian Hubinger", 0, "e9806056@student.tuwien.ac.at" );
	aboutData.addCredit( "Casper Planken", "Gave me some really good hints about how to do ceratin things", "cplanken@chello.nl" );
	aboutData.addCredit( "Malcolm Hunter", "Spell Checking and making messages real english", "malcolm.hunter@gmx.co.uk" );
	aboutData.addCredit( "Carsten Niehaus", "Part of the sanity checks, bugfixes", "cniehaus@gmx.de" );
	aboutData.addCredit( "Christian Deschka", "Artwork", "echos@lycos.at" );

	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	KMFApp a;
  KConfig *_config = a.config();
  _config->setGroup( "STARTUP" );
	QString show_splash = _config->readEntry( "show_splash" );
  kdDebug() << "Show Splash: " << show_splash << endl;
  // Splash screen
  if ( show_splash == "true" )
		showSplash();

	KMyFirewall *kmyfirewall = new KMyFirewall( 0, "MAINAPP" );
	a.setMainWidget( kmyfirewall );
	kmyfirewall->show();

	set_splash_status( i18n("Done") );
	closeSplash();
	return a.exec();
}
